/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.indexreader;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.RandomAccess;
import org.apache.ignite.internal.commandline.indexreader.IndexReaderUtils;
import org.jetbrains.annotations.Nullable;

public class ArrayWrapper<E>
extends AbstractList<E>
implements RandomAccess {
    private Object[] arr = new Object[10];
    private int maxInsertIdx = -1;

    @Override
    @Nullable
    public E set(int idx, @Nullable E element) {
        if (idx < 0) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        this.ensureCapacity(idx + 1);
        Object oldElement = this.arr[idx];
        this.arr[idx] = element;
        this.maxInsertIdx = Math.max(this.maxInsertIdx, idx);
        return (E)oldElement;
    }

    @Override
    @Nullable
    public E get(int idx) {
        if (idx < 0 || idx >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return (E)this.arr[idx];
    }

    @Override
    public int size() {
        return this.maxInsertIdx + 1;
    }

    public ArrayWrapper<E> trimToSize() {
        this.arr = this.isEmpty() ? new Object[]{} : Arrays.copyOf(this.arr, this.size());
        return this;
    }

    private void ensureCapacity(int minCap) {
        if (minCap - this.arr.length <= 0) {
            return;
        }
        this.arr = Arrays.copyOf(this.arr, (int)((double)minCap * 1.5));
    }

    public static long instanceSize() {
        return IndexReaderUtils.objectSize((long)(IndexReaderUtils.linkSize() + 4L));
    }
}

