/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;

public abstract class BaseGetDiffBuilder<PARAMS>
implements GetDiffBuilder {
    private final BiFunction<PARAMS, String, PARAMS> paramsForPage;
    private String pageToken;
    protected Integer maxRecords;
    protected String fromRefName;
    protected String fromHashOnRef;
    protected String toRefName;
    protected String toHashOnRef;
    protected final List<ContentKey> keys = new ArrayList<ContentKey>();
    protected ContentKey minKey;
    protected ContentKey maxKey;
    protected ContentKey prefixKey;
    protected String filter;

    protected BaseGetDiffBuilder(BiFunction<PARAMS, String, PARAMS> paramsForPage) {
        this.paramsForPage = paramsForPage;
    }

    @Override
    public GetDiffBuilder fromRefName(String fromRefName) {
        this.fromRefName = fromRefName;
        return this;
    }

    @Override
    public GetDiffBuilder fromHashOnRef(String fromHashOnRef) {
        this.fromHashOnRef = fromHashOnRef;
        return this;
    }

    @Override
    public GetDiffBuilder toRefName(String toRefName) {
        this.toRefName = toRefName;
        return this;
    }

    @Override
    public GetDiffBuilder toHashOnRef(String toHashOnRef) {
        this.toHashOnRef = toHashOnRef;
        return this;
    }

    @Override
    public GetDiffBuilder maxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    @Override
    public GetDiffBuilder pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Override
    public GetDiffBuilder key(ContentKey key) {
        this.keys.add(key);
        return this;
    }

    @Override
    public GetDiffBuilder keys(Collection<ContentKey> keys) {
        this.keys.addAll(keys);
        return this;
    }

    @Override
    public GetDiffBuilder minKey(ContentKey minKey) {
        this.minKey = minKey;
        return this;
    }

    @Override
    public GetDiffBuilder maxKey(ContentKey maxKey) {
        this.maxKey = maxKey;
        return this;
    }

    @Override
    public GetDiffBuilder prefixKey(ContentKey prefixKey) {
        this.prefixKey = prefixKey;
        return this;
    }

    @Override
    public GetDiffBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DiffResponse get() throws NessieNotFoundException {
        return this.get(this.paramsForPage.apply(this.params(), this.pageToken));
    }

    protected abstract PARAMS params();

    protected abstract DiffResponse get(PARAMS var1) throws NessieNotFoundException;

    @Override
    public Stream<DiffResponse.DiffEntry> stream() throws NessieNotFoundException {
        PARAMS p = this.params();
        return StreamingUtil.generateStream(DiffResponse::getDiffs, pageToken -> this.get(this.paramsForPage.apply(p, pageToken)));
    }
}

