/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.PaginatedResponse;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class StreamingUtil {
    private StreamingUtil() {
    }

    @Deprecated
    public static Stream<Reference> getAllReferencesStream(@NotNull @jakarta.validation.constraints.NotNull NessieApiV1 api, @NotNull @jakarta.validation.constraints.NotNull Function<GetAllReferencesBuilder, GetAllReferencesBuilder> builderCustomizer, @NotNull @jakarta.validation.constraints.NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetAllReferencesBuilder builder = builderCustomizer.apply(api.getAllReferences());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(ReferencesResponse::getReferences, token -> StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    @Deprecated
    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull @jakarta.validation.constraints.NotNull NessieApiV1 api, @NotNull @jakarta.validation.constraints.NotNull Function<GetEntriesBuilder, GetEntriesBuilder> builderCustomizer, @NotNull @jakarta.validation.constraints.NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetEntriesBuilder builder = builderCustomizer.apply(api.getEntries());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(EntriesResponse::getEntries, token -> StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    @Deprecated
    public static Stream<LogResponse.LogEntry> getCommitLogStream(@NotNull @jakarta.validation.constraints.NotNull NessieApiV1 api, @NotNull @jakarta.validation.constraints.NotNull Function<GetCommitLogBuilder, GetCommitLogBuilder> builderCustomizer, @NotNull @jakarta.validation.constraints.NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetCommitLogBuilder builder = builderCustomizer.apply(api.getCommitLog());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(LogResponse::getLogEntries, token -> StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    @Deprecated
    public static Stream<RefLogResponse.RefLogResponseEntry> getReflogStream(@NotNull @jakarta.validation.constraints.NotNull NessieApiV1 api, @NotNull @jakarta.validation.constraints.NotNull Function<GetRefLogBuilder, GetRefLogBuilder> builderCustomizer, @NotNull @jakarta.validation.constraints.NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetRefLogBuilder builder = builderCustomizer.apply(api.getRefLog());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(RefLogResponse::getLogEntries, token -> StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    private static <B extends PagingBuilder<B, ?, ?>> B builderWithPaging(B builder, Integer pageSize, String token) {
        if (pageSize != null) {
            builder.maxRecords(pageSize);
        }
        if (token != null) {
            builder.pageToken(token);
        }
        return builder;
    }

    public static <ENTRY, RESP extends PaginatedResponse> Stream<ENTRY> generateStream(Function<RESP, List<ENTRY>> entriesExtractor, NextPage<RESP> pageFetcher) throws NessieNotFoundException {
        return new ResultStreamPaginator<PaginatedResponse, ENTRY>(entriesExtractor, pageFetcher::getPage).generateStream();
    }

    @FunctionalInterface
    public static interface NextPage<R> {
        public R getPage(String var1) throws NessieNotFoundException;
    }
}

