/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class IgniteStripedThreadPoolExecutor
implements ExecutorService {
    private final ExecutorService[] execs;

    public IgniteStripedThreadPoolExecutor(int concurrentLvl, String igniteInstanceName, String threadNamePrefix, Thread.UncaughtExceptionHandler eHnd, boolean allowCoreThreadTimeOut, long keepAliveTime) {
        this.execs = new ExecutorService[concurrentLvl];
        IgniteThreadFactory factory = new IgniteThreadFactory(igniteInstanceName, threadNamePrefix, eHnd);
        for (int i = 0; i < concurrentLvl; ++i) {
            IgniteThreadPoolExecutor executor = new IgniteThreadPoolExecutor(1, 1, keepAliveTime, new LinkedBlockingQueue<Runnable>(), factory);
            executor.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
            this.execs[i] = executor;
        }
    }

    public void execute(Runnable task, int idx) {
        this.execs[this.threadId(idx)].execute(task);
    }

    public int threadId(int idx) {
        return idx < this.execs.length ? idx : idx % this.execs.length;
    }

    @Override
    public void shutdown() {
        for (ExecutorService exec : this.execs) {
            exec.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.execs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> res = new ArrayList<Runnable>(this.execs.length);
        for (ExecutorService exec : this.execs) {
            for (Runnable r : exec.shutdownNow()) {
                res.add(r);
            }
        }
        return res;
    }

    @Override
    public boolean isShutdown() {
        for (ExecutorService exec : this.execs) {
            if (exec.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (ExecutorService exec : this.execs) {
            if (exec.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean res = true;
        for (ExecutorService exec : this.execs) {
            res &= exec.awaitTermination(timeout, unit);
        }
        return res;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Future<T> submit(Runnable task, T res) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable cmd) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(IgniteStripedThreadPoolExecutor.class, this);
    }
}

