/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeResult;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.jetbrains.annotations.Nullable;

public class VisorValidateIndexesJobResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Map<PartitionKey, ValidateIndexesPartitionResult> partRes;
    @GridToStringInclude
    @Nullable
    private Map<String, ValidateIndexesPartitionResult> idxRes;
    @GridToStringInclude
    @Nullable
    private Collection<IndexIntegrityCheckIssue> integrityCheckFailures;
    @GridToStringInclude
    @Nullable
    private Map<String, ValidateIndexesCheckSizeResult> checkSizeRes;

    public VisorValidateIndexesJobResult(Map<PartitionKey, ValidateIndexesPartitionResult> partRes, @Nullable Map<String, ValidateIndexesPartitionResult> idxRes, @Nullable Collection<IndexIntegrityCheckIssue> integrityCheckFailures, @Nullable Map<String, ValidateIndexesCheckSizeResult> checkSizeRes) {
        this.partRes = partRes;
        this.idxRes = idxRes;
        this.integrityCheckFailures = integrityCheckFailures;
        this.checkSizeRes = checkSizeRes;
    }

    public VisorValidateIndexesJobResult() {
    }

    @Override
    public byte getProtocolVersion() {
        return 4;
    }

    public Map<PartitionKey, ValidateIndexesPartitionResult> partitionResult() {
        return this.partRes;
    }

    public Map<String, ValidateIndexesPartitionResult> indexResult() {
        return this.idxRes == null ? Collections.emptyMap() : this.idxRes;
    }

    public Collection<IndexIntegrityCheckIssue> integrityCheckFailures() {
        return this.integrityCheckFailures == null ? Collections.emptyList() : this.integrityCheckFailures;
    }

    public Map<String, ValidateIndexesCheckSizeResult> checkSizeResult() {
        return this.checkSizeRes == null ? Collections.emptyMap() : this.checkSizeRes;
    }

    public boolean hasIssues() {
        return this.integrityCheckFailures != null && !this.integrityCheckFailures.isEmpty() || this.partRes != null && this.partRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty()) || this.idxRes != null && this.idxRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty()) || this.checkSizeRes != null && this.checkSizeRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesCheckSizeResult)e.getValue()).issues().isEmpty());
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        IgniteUtils.writeMap(out, this.partRes);
        IgniteUtils.writeMap(out, this.idxRes);
        IgniteUtils.writeCollection(out, this.integrityCheckFailures);
        IgniteUtils.writeMap(out, this.checkSizeRes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.partRes = IgniteUtils.readMap(in);
        if (protoVer >= 2) {
            this.idxRes = IgniteUtils.readMap(in);
        }
        if (protoVer >= 3) {
            this.integrityCheckFailures = IgniteUtils.readCollection(in);
        }
        if (protoVer >= 4) {
            this.checkSizeRes = IgniteUtils.readMap(in);
        }
    }

    public String toString() {
        return S.toString(VisorValidateIndexesJobResult.class, this);
    }
}

