/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class VisorDrTopologyTaskResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private byte dataCenterId;
    private int serverNodesCnt;
    private int clientNodesCnt;
    private List<T3<UUID, String, String>> senderHubs;
    private List<T3<UUID, String, String>> receiverHubs;
    private List<T2<UUID, String>> dataNodes;
    private List<T3<UUID, String, String>> otherNodes;

    public VisorDrTopologyTaskResult() {
    }

    public VisorDrTopologyTaskResult(byte dataCenterId, int serverNodesCnt, int clientNodesCnt, List<T3<UUID, String, String>> senderHubs, List<T3<UUID, String, String>> receiverHubs, List<T2<UUID, String>> dataNodes, List<T3<UUID, String, String>> otherNodes) {
        this.dataCenterId = dataCenterId;
        this.serverNodesCnt = serverNodesCnt;
        this.clientNodesCnt = clientNodesCnt;
        this.senderHubs = senderHubs;
        this.receiverHubs = receiverHubs;
        this.dataNodes = dataNodes;
        this.otherNodes = otherNodes;
    }

    public byte getDataCenterId() {
        return this.dataCenterId;
    }

    public int getServerNodesCount() {
        return this.serverNodesCnt;
    }

    public int getClientNodesCount() {
        return this.clientNodesCnt;
    }

    public List<T3<UUID, String, String>> getSenderHubs() {
        return this.senderHubs;
    }

    public List<T3<UUID, String, String>> getReceiverHubs() {
        return this.receiverHubs;
    }

    public List<T2<UUID, String>> getDataNodes() {
        return this.dataNodes;
    }

    public List<T3<UUID, String, String>> getOtherNodes() {
        return this.otherNodes;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.dataCenterId);
        out.writeInt(this.serverNodesCnt);
        out.writeInt(this.clientNodesCnt);
        U.writeCollection(out, this.senderHubs);
        U.writeCollection(out, this.receiverHubs);
        U.writeCollection(out, this.dataNodes);
        U.writeCollection(out, this.otherNodes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataCenterId = in.readByte();
        this.serverNodesCnt = in.readInt();
        this.clientNodesCnt = in.readInt();
        this.senderHubs = U.readList(in);
        this.receiverHubs = U.readList(in);
        this.dataNodes = U.readList(in);
        this.otherNodes = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorDrTopologyTaskResult.class, this);
    }
}

