/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.datastructures.QueueItemKey;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

class GridCacheQueueItemKey
implements Externalizable,
QueueItemKey {
    private static final long serialVersionUID = 0L;
    private IgniteUuid queueId;
    private String queueName;
    private long idx;

    public GridCacheQueueItemKey() {
    }

    GridCacheQueueItemKey(IgniteUuid queueId, String queueName, long idx) {
        this.queueId = queueId;
        this.queueName = queueName;
        this.idx = idx;
    }

    public Long index() {
        return this.idx;
    }

    public IgniteUuid queueId() {
        return this.queueId;
    }

    public String queueName() {
        return this.queueName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.queueId);
        U.writeString(out, this.queueName);
        out.writeLong(this.idx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.queueId = U.readGridUuid(in);
        this.queueName = U.readString(in);
        this.idx = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCacheQueueItemKey itemKey = (GridCacheQueueItemKey)o;
        return this.idx == itemKey.idx && this.queueId.equals(itemKey.queueId);
    }

    public int hashCode() {
        int res = this.queueId.hashCode();
        res = 31 * res + (int)(this.idx ^ this.idx >>> 32);
        return res;
    }

    public String toString() {
        return S.toString(GridCacheQueueItemKey.class, this);
    }
}

