/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PartitionReconciliationValueMeta
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private byte[] binaryView;
    private String strView;
    private GridCacheVersion ver;

    public PartitionReconciliationValueMeta() {
    }

    public PartitionReconciliationValueMeta(byte[] binaryView, String strView, GridCacheVersion ver) {
        this.binaryView = binaryView;
        this.strView = strView;
        this.ver = ver;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.binaryView);
        U.writeString(out, this.strView);
        out.writeObject(this.ver);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.binaryView = U.readByteArray(in);
        this.strView = U.readString(in);
        this.ver = (GridCacheVersion)in.readObject();
    }

    public String stringView(boolean verbose) {
        return verbose ? this.strView + " hex=[" + U.byteArray2HexString(this.binaryView) + "]" + (this.ver != null ? " ver=[topVer=" + this.ver.topologyVersion() + ", order=" + this.ver.order() + ", nodeOrder=" + this.ver.nodeOrder() + ']' : "") : "*****" + (this.ver != null ? " ver=[topVer=" + this.ver.topologyVersion() + ", order=" + this.ver.order() + ", nodeOrder=" + this.ver.nodeOrder() : "") + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReconciliationValueMeta meta = (PartitionReconciliationValueMeta)o;
        if (!Arrays.equals(this.binaryView, meta.binaryView)) {
            return false;
        }
        if (!Objects.equals(this.strView, meta.strView)) {
            return false;
        }
        return Objects.equals(this.ver, meta.ver);
    }
}

