/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.NearTxQueryEnlistResultHandler;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridNearTxQueryEnlistFuture
extends GridNearTxQueryAbstractEnlistFuture {
    private final int[] cacheIds;
    private final int[] parts;
    private final String schema;
    private final String qry;
    private final Object[] params;
    private final int flags;
    private final int pageSize;

    protected GridNearTxQueryEnlistFuture(GridCacheContext<?, ?> cctx, GridNearTxLocal tx, int[] cacheIds, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, long timeout) {
        super(cctx, tx, timeout);
        this.cacheIds = cacheIds;
        this.parts = parts;
        this.schema = schema;
        this.qry = qry;
        this.params = params;
        this.flags = flags;
        this.pageSize = pageSize;
    }

    @Override
    protected void map(boolean topLocked) {
        block11: {
            try {
                HashMap<ClusterNode, IntArrayHolder> map;
                boolean locallyMapped = false;
                AffinityAssignment assignment = this.cctx.affinity().assignment(this.topVer);
                if (this.parts != null) {
                    map = U.newHashMap(this.parts.length);
                    for (int i = 0; i < this.parts.length; ++i) {
                        ClusterNode pNode = assignment.get(this.parts[i]).get(0);
                        map.computeIfAbsent(pNode, n -> new IntArrayHolder()).add(this.parts[i]);
                        this.updateMappings(pNode);
                        if (locallyMapped || !pNode.isLocal()) continue;
                        locallyMapped = true;
                    }
                } else {
                    Set<ClusterNode> nodes = assignment.primaryPartitionNodes();
                    map = U.newHashMap(nodes.size());
                    for (ClusterNode pNode : nodes) {
                        map.put(pNode, null);
                        this.updateMappings(pNode);
                        if (locallyMapped || !pNode.isLocal()) continue;
                        locallyMapped = true;
                    }
                }
                if (map.isEmpty()) {
                    throw new ClusterTopologyServerNotFoundException("Failed to find data nodes for cache (all partition nodes left the grid). [fut=" + this.toString() + ']');
                }
                int idx = 0;
                boolean first = true;
                boolean clientFirst = false;
                GridDhtTxAbstractEnlistFuture localFut = null;
                for (Map.Entry entry : map.entrySet()) {
                    ClusterNode node = (ClusterNode)entry.getKey();
                    IntArrayHolder parts = (IntArrayHolder)entry.getValue();
                    final MiniFuture mini = new MiniFuture(node);
                    this.add(mini);
                    if (node.isLocal()) {
                        localFut = new GridDhtTxQueryEnlistFuture(this.cctx.localNode().id(), this.lockVer, this.mvccSnapshot, this.threadId, this.futId, -(++idx), this.tx, this.cacheIds, parts == null ? null : parts.array(), this.schema, this.qry, this.params, this.flags, this.pageSize, this.remainingTime(), this.cctx);
                        this.updateLocalFuture(localFut);
                        localFut.listen(new CI1<IgniteInternalFuture<Long>>(){

                            @Override
                            public void apply(IgniteInternalFuture<Long> fut) {
                                assert (fut.error() != null || fut.result() != null) : fut;
                                try {
                                    GridNearTxQueryEnlistFuture.this.clearLocalFuture((GridDhtTxQueryEnlistFuture)fut);
                                    GridNearTxQueryEnlistResponse res = fut.error() == null ? (GridNearTxQueryEnlistResponse)NearTxQueryEnlistResultHandler.createResponse(fut) : null;
                                    mini.onResult(res, fut.error());
                                }
                                catch (IgniteCheckedException e) {
                                    mini.onResult(null, e);
                                }
                                finally {
                                    CU.unwindEvicts(GridNearTxQueryEnlistFuture.this.cctx);
                                }
                            }
                        });
                        continue;
                    }
                    if (first) {
                        clientFirst = this.cctx.localNode().isClient() && !topLocked && !this.tx.hasRemoteLocks();
                        first = false;
                    }
                    GridNearTxQueryEnlistRequest req = new GridNearTxQueryEnlistRequest(this.cctx.cacheId(), this.threadId, this.futId, ++idx, this.tx.subjectId(), this.topVer, this.lockVer, this.mvccSnapshot, this.cacheIds, parts == null ? null : parts.array(), this.schema, this.qry, this.params, this.flags, this.pageSize, this.remainingTime(), this.tx.remainingTime(), this.tx.taskNameHash(), clientFirst);
                    this.sendRequest(req, node.id());
                }
                this.markInitialized();
                if (localFut != null) {
                    localFut.init();
                }
            }
            catch (Throwable e) {
                this.onDone(e);
                if (!(e instanceof Error)) break block11;
                throw (Error)e;
            }
        }
    }

    private void sendRequest(GridCacheMessage req, UUID nodeId) throws IgniteCheckedException {
        this.cctx.io().send(nodeId, req, (byte)10);
    }

    @Override
    public synchronized boolean onNodeLeft(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f = (MiniFuture)fut;
            if (!f.node.id().equals(nodeId)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found mini-future for left node [nodeId=" + nodeId + ", mini=" + f + ", fut=" + this + ']');
            }
            return f.onResult(null, this.newTopologyException(nodeId));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Future does not have mapping for left node (ignoring) [nodeId=" + nodeId + ", fut=" + this + ']');
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        this.compoundsReadLock();
        try {
            IgniteInternalFuture fut = this.future(Math.abs(miniId) - 1);
            MiniFuture miniFuture = !fut.isDone() ? (MiniFuture)fut : null;
            return miniFuture;
        }
        finally {
            this.compoundsReadUnlock();
        }
    }

    private ClusterTopologyCheckedException newTopologyException(UUID nodeId) {
        ClusterTopologyCheckedException topEx = new ClusterTopologyCheckedException("Failed to enlist keys (primary node left grid, retry transaction if possible) [node=" + nodeId + ']');
        topEx.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(this.topVer));
        return topEx;
    }

    public void onResult(UUID nodeId, GridNearTxQueryEnlistResponse res) {
        MiniFuture mini = this.miniFuture(res.miniId());
        if (mini != null) {
            mini.onResult(res, null);
        }
    }

    @Override
    public Set<UUID> pendingResponseNodes() {
        if (this.initialized() && !this.isDone()) {
            return this.futures().stream().map(MiniFuture.class::cast).filter(mini -> !mini.isDone()).map(mini -> ((MiniFuture)mini).node.id()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxQueryEnlistFuture.class, this, super.toString());
    }

    private static class IntArrayHolder {
        private int[] array;
        private int size;

        private IntArrayHolder() {
        }

        void add(int i) {
            if (this.array == null) {
                this.array = new int[4];
            }
            if (this.array.length == this.size) {
                this.array = Arrays.copyOf(this.array, this.size << 1);
            }
            this.array[this.size++] = i;
        }

        public int[] array() {
            if (this.array == null) {
                return null;
            }
            if (this.size == this.array.length) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.size);
        }
    }

    private class MiniFuture
    extends GridFutureAdapter<Long> {
        private boolean completed;
        @GridToStringExclude
        private final ClusterNode node;

        private MiniFuture(ClusterNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onResult(GridNearTxQueryEnlistResponse res, Throwable err) {
            assert (res != null || err != null) : this;
            if (err == null && res.error() != null) {
                err = res.error();
            }
            MiniFuture miniFuture = this;
            synchronized (miniFuture) {
                if (this.completed) {
                    return false;
                }
                this.completed = true;
            }
            if (res != null && res.removeMapping()) {
                GridDistributedTxMapping m = GridNearTxQueryEnlistFuture.this.tx.mappings().get(this.node.id());
                assert (m != null && m.empty());
                GridNearTxQueryEnlistFuture.this.tx.removeMapping(this.node.id());
                if (this.node.isLocal()) {
                    GridNearTxQueryEnlistFuture.this.tx.colocatedLocallyMapped(false);
                }
            } else if (res != null) {
                GridNearTxQueryEnlistFuture.this.tx.mappings().get(this.node.id()).addBackups(res.newDhtNodes());
                if (res.result() > 0L && !this.node.isLocal()) {
                    GridNearTxQueryEnlistFuture.this.tx.hasRemoteLocks(true);
                }
            }
            return err != null ? this.onDone(err) : this.onDone(res.result(), res.error());
        }
    }
}

