/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridLocalConfigManager {
    private final boolean startClientCaches = IgniteSystemProperties.getBoolean("IGNITE_START_CACHES_ON_JOIN", false);
    private final Deque<String> stopSeq = new LinkedList<String>();
    private final IgniteLogger log;
    private Set<String> localCachesOnStart;
    private final GridCacheProcessor cacheProcessor;
    private final GridKernalContext ctx;

    public GridLocalConfigManager(GridCacheProcessor cacheProcessor, GridKernalContext kernalCtx) {
        this.cacheProcessor = cacheProcessor;
        this.ctx = kernalCtx;
        this.log = this.ctx.log(this.getClass());
    }

    public void saveCacheConfiguration(StoredCacheData storedCacheData, boolean overwrite) throws IgniteCheckedException {
        assert (storedCacheData != null);
        GridCacheSharedContext sharedContext = this.cacheProcessor.context();
        if (sharedContext.pageStore() != null && !sharedContext.kernalContext().clientNode() && GridCacheUtils.isPersistentCache(storedCacheData.config(), sharedContext.gridConfig().getDataStorageConfiguration())) {
            sharedContext.pageStore().storeCacheData(storedCacheData, overwrite);
        }
    }

    public Collection<String> stopSequence() {
        return this.stopSeq;
    }

    public Set<String> localCachesOnStart() {
        return this.localCachesOnStart;
    }

    public CacheJoinNodeDiscoveryData restoreCacheConfigurations() throws IgniteCheckedException {
        if (this.ctx.isDaemon()) {
            return null;
        }
        HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo> caches = new HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo>();
        HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo> templates = new HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo>();
        this.restoreCaches(caches, templates, this.ctx.config(), this.ctx.cache().context().pageStore());
        CacheJoinNodeDiscoveryData discoData = new CacheJoinNodeDiscoveryData(IgniteUuid.randomUuid(), caches, templates, this.startAllCachesOnClientStart());
        this.localCachesOnStart = new HashSet<String>(discoData.caches().keySet());
        return discoData;
    }

    private boolean startAllCachesOnClientStart() {
        return this.startClientCaches && this.ctx.clientNode();
    }

    private void restoreCaches(Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> templates, IgniteConfiguration config, IgnitePageStoreManager pageStoreManager) throws IgniteCheckedException {
        Map<String, StoredCacheData> storedCaches;
        assert (!config.isDaemon()) : "Trying to restore cache configurations on daemon node.";
        CacheConfiguration[] cfgs = config.getCacheConfiguration();
        for (int i = 0; i < cfgs.length; ++i) {
            CacheConfiguration cfg;
            cfgs[i] = cfg = new CacheConfiguration(cfgs[i]);
            this.addCacheFromConfiguration(cfg, false, caches, templates);
        }
        if (CU.isPersistenceEnabled(config) && pageStoreManager != null && !F.isEmpty(storedCaches = pageStoreManager.readCacheConfigurations())) {
            ArrayList<String> skippedConfigs = new ArrayList<String>();
            for (StoredCacheData storedCacheData : storedCaches.values()) {
                if (storedCacheData.hasOldCacheConfigurationFormat()) {
                    storedCacheData = new StoredCacheData(storedCacheData);
                    T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.cacheProcessor.splitter().split(storedCacheData.config());
                    storedCacheData.config((CacheConfiguration)((Object)splitCfg.get1()));
                    storedCacheData.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
                    this.saveCacheConfiguration(storedCacheData, true);
                }
                String cacheName = storedCacheData.config().getName();
                CacheType type = CacheType.cacheType(cacheName);
                if (!caches.containsKey(cacheName)) {
                    this.addStoredCache(caches, storedCacheData, cacheName, type, true, false);
                    continue;
                }
                CacheConfiguration<?, ?> cfg = caches.get(cacheName).cacheData().config();
                CacheConfiguration<?, ?> cfgFromStore = storedCacheData.config();
                this.validateCacheConfigurationOnRestore(cfg, cfgFromStore);
                this.addStoredCache(caches, storedCacheData, cacheName, type, true, this.cacheProcessor.keepStaticCacheConfiguration());
                if (this.cacheProcessor.keepStaticCacheConfiguration() || type != CacheType.USER) continue;
                skippedConfigs.add(cacheName);
            }
            if (!F.isEmpty(skippedConfigs)) {
                U.warn(this.log, "Static configuration for the following caches will be ignored because a persistent cache with the same name already exist (see https://www.gridgain.com/docs/latest/developers-guide/configuring-caches/configuration-overview for more information): " + skippedConfigs);
            }
        }
    }

    private void addStoredCache(Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, StoredCacheData cacheData, String cacheName, CacheType cacheType, boolean persistedBefore, boolean isStaticallyConfigured) {
        if (!caches.containsKey(cacheName)) {
            if (!cacheType.userCache()) {
                this.stopSeq.addLast(cacheName);
            } else {
                this.stopSeq.addFirst(cacheName);
            }
        }
        caches.put(cacheName, new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, cacheType, cacheData.sql(), persistedBefore ? 1L : 0L, isStaticallyConfigured));
    }

    private void addCacheFromConfiguration(CacheConfiguration<?, ?> cfg, boolean sql, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> templates) throws IgniteCheckedException {
        String cacheName = cfg.getName();
        CU.validateCacheName(cacheName);
        ArrayList ccfgs = new ArrayList(caches.size());
        for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : caches.values()) {
            ccfgs.add(cacheInfo.cacheData().config());
        }
        String err = GridLocalConfigManager.validateIncomingConfiguration(ccfgs, cfg);
        if (err != null) {
            throw new IgniteException(err);
        }
        this.cacheProcessor.cloneCheckSerializable(cfg);
        this.cacheProcessor.initialize(cfg, this.ctx.cacheObjects().contextForCache(cfg));
        StoredCacheData cacheData = new StoredCacheData(cfg);
        cacheData.sql(sql);
        T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.cacheProcessor.splitter().split(cfg);
        cacheData.config((CacheConfiguration)((Object)splitCfg.get1()));
        cacheData.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
        cfg = (CacheConfiguration)((Object)splitCfg.get1());
        if (GridCacheUtils.isCacheTemplateName(cacheName)) {
            templates.put(cacheName, new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, CacheType.USER, false, 0L, true));
        } else {
            if (caches.containsKey(cacheName)) {
                throw new IgniteCheckedException("Duplicate cache name found (check configuration and assign unique name to each cache): " + cacheName);
            }
            CacheType cacheType = CacheType.cacheType(cacheName);
            if (cacheType != CacheType.USER && cfg.getDataRegionName() == null) {
                cfg.setDataRegionName(this.cacheProcessor.context().database().systemDateRegionName());
            }
            this.addStoredCache(caches, cacheData, cacheName, cacheType, false, true);
        }
    }

    @Nullable
    public static String validateIncomingConfiguration(Collection<CacheConfiguration<?, ?>> cacheConfigs, CacheConfiguration<?, ?> cfg) {
        HashMap<String, String> idxNamesPerCache = new HashMap<String, String>();
        String schemaName = QueryUtils.normalizeSchemaName(cfg.getName(), cfg.getSqlSchema());
        for (CacheConfiguration<?, ?> conf0 : cacheConfigs) {
            Collection<QueryEntity> entrs = conf0.getQueryEntities();
            String cacheName = conf0.getName();
            String cacheSchemaName = QueryUtils.normalizeSchemaName(conf0.getName(), conf0.getSqlSchema());
            if (!Objects.equals(cacheSchemaName, schemaName) || CU.isSystemCache(cacheName) || Objects.equals(cacheSchemaName, schemaName) && Objects.equals(cfg.getName(), cacheName)) continue;
            for (QueryEntity ent : entrs) {
                Collection<QueryIndex> idxs = ent.getIndexes();
                for (QueryIndex idx : idxs) {
                    idxNamesPerCache.put(idx.getName(), cacheName);
                }
            }
        }
        if (idxNamesPerCache.isEmpty()) {
            return null;
        }
        Collection<QueryEntity> entrs = cfg.getQueryEntities();
        for (QueryEntity ent : entrs) {
            Collection<QueryIndex> idxs = ent.getIndexes();
            for (QueryIndex idx : idxs) {
                String normalizedIdxName = QueryUtils.normalizeObjectName(idx.getName(), false);
                String cacheName = (String)idxNamesPerCache.get(normalizedIdxName);
                if (cacheName == null) continue;
                return "Duplicate index name for [cache=" + cfg.getName() + ", idxName=" + idx.getName() + "], an equal index name is already configured for [cache=" + cacheName + ']';
            }
        }
        return null;
    }

    private void validateCacheConfigurationOnRestore(CacheConfiguration cfg, CacheConfiguration cfgFromStore) throws IgniteCheckedException {
        assert (cfg != null && cfgFromStore != null);
        if ((cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT || cfgFromStore.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) && cfg.getAtomicityMode() != cfgFromStore.getAtomicityMode()) {
            throw new IgniteCheckedException("Cannot start cache. Statically configured atomicity mode differs from previously stored configuration. Please check your configuration: [cacheName=" + cfg.getName() + ", configuredAtomicityMode=" + (Object)((Object)cfg.getAtomicityMode()) + ", storedAtomicityMode=" + (Object)((Object)cfgFromStore.getAtomicityMode()) + "]");
        }
        boolean staticCfgVal = cfg.isEncryptionEnabled();
        boolean storedVal = cfgFromStore.isEncryptionEnabled();
        if (storedVal != staticCfgVal) {
            throw new IgniteCheckedException("Encrypted flag value differs. Static config value is '" + staticCfgVal + "' and value stored on the disk is '" + storedVal + "'");
        }
    }
}

