/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

class ClientClusterNodeImpl
implements ClusterNode {
    private final UUID id;
    private final Object consistentId;
    private final Map<String, Object> attrs;
    private final Collection<String> addresses;
    private final Collection<String> hostNames;
    private final long order;
    private final IgniteProductVersion ver;
    private final boolean isLoc;
    private final boolean isDaemon;
    private final boolean isClient;

    ClientClusterNodeImpl(UUID id, Map<String, Object> attrs, Collection<String> addresses, Collection<String> hostNames, long order, boolean isLoc, boolean isDaemon, boolean isClient, Object consistentId, IgniteProductVersion ver) {
        this.id = id;
        this.consistentId = consistentId;
        this.attrs = Collections.unmodifiableMap(attrs);
        this.addresses = Collections.unmodifiableCollection(addresses);
        this.hostNames = Collections.unmodifiableCollection(hostNames);
        this.order = order;
        this.ver = ver;
        this.isLoc = isLoc;
        this.isDaemon = isDaemon;
        this.isClient = isClient;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Object consistentId() {
        return this.consistentId;
    }

    @Override
    @Nullable
    public <T> T attribute(String name) {
        return (T)this.attrs.get(name);
    }

    @Override
    public ClusterMetrics metrics() {
        throw new UnsupportedOperationException("Metrics are not supported for thin client implementation of ClusterNode");
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attrs;
    }

    @Override
    public Collection<String> addresses() {
        return this.addresses;
    }

    @Override
    public Collection<String> hostNames() {
        return this.hostNames;
    }

    @Override
    public long order() {
        return this.order;
    }

    @Override
    public IgniteProductVersion version() {
        return this.ver;
    }

    @Override
    public boolean isLocal() {
        return this.isLoc;
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    public boolean equals(Object o) {
        return F.eqNodes(this, o);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return S.toString(ClientClusterNodeImpl.class, this);
    }
}

