/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;

public class BinaryTreeMap
implements Binarylizable,
Serializable {
    private static final long serialVersionUID = 0L;
    private TreeMap map;

    public BinaryTreeMap() {
    }

    public BinaryTreeMap(TreeMap map) {
        this.map = map;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeObject(this.map.comparator());
        int size = this.map.size();
        rawWriter.writeInt(size);
        for (Map.Entry entry : this.map.entrySet()) {
            rawWriter.writeObject(entry.getKey());
            rawWriter.writeObject(entry.getValue());
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        Comparator comp = (Comparator)rawReader.readObject();
        this.map = comp == null ? new TreeMap() : new TreeMap(comp);
        int size = rawReader.readInt();
        for (int i = 0; i < size; ++i) {
            this.map.put(rawReader.readObject(), rawReader.readObject());
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.map;
    }
}

