/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.apache.ignite.internal.IgniteProperties;
import org.apache.ignite.lang.IgniteProductVersion;

public class IgniteVersionUtils {
    public static final String VER_STR = IgniteProperties.get("ignite.version").replace(".a", "-a").replace(".b", "-b").replace(".final", "-final");
    public static final IgniteProductVersion VER;
    private static final DateTimeFormatter BUILD_TSTAMP_DATE_FORMATTER;
    public static final String BUILD_TSTAMP_STR;
    public static final long BUILD_TSTAMP;
    private static final String BUILD_TSTAMP_FROM_PROPERTY;
    public static final String REV_HASH_STR;
    public static final Date RELEASE_DATE;
    public static final String ACK_VER_STR;
    public static final String COPYRIGHT;

    public static String formatBuildTimeStamp(long ts) {
        return BUILD_TSTAMP_DATE_FORMATTER.format(Instant.ofEpochMilli(ts));
    }

    private IgniteVersionUtils() {
    }

    static {
        BUILD_TSTAMP_FROM_PROPERTY = IgniteProperties.get("ignite.build");
        BUILD_TSTAMP = !BUILD_TSTAMP_FROM_PROPERTY.isEmpty() && Long.parseLong(BUILD_TSTAMP_FROM_PROPERTY) != 0L ? Long.parseLong(BUILD_TSTAMP_FROM_PROPERTY) : System.currentTimeMillis() / 1000L;
        BUILD_TSTAMP_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("UTC"));
        BUILD_TSTAMP_STR = IgniteVersionUtils.formatBuildTimeStamp(BUILD_TSTAMP * 1000L);
        COPYRIGHT = BUILD_TSTAMP_STR.substring(0, 4) + " Copyright(C) GridGain Systems, Inc. and Contributors";
        REV_HASH_STR = IgniteProperties.get("ignite.revision");
        String releaseDateStr = IgniteProperties.get("ignite.rel.date");
        DateTimeFormatter releaseDateFormatter = DateTimeFormatter.ofPattern("ddMMyyyy", Locale.US);
        Instant releaseInstant = LocalDate.parse(releaseDateStr, releaseDateFormatter).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        RELEASE_DATE = Date.from(releaseInstant);
        String rev = REV_HASH_STR.length() > 8 ? REV_HASH_STR.substring(0, 8) : REV_HASH_STR;
        ACK_VER_STR = VER_STR + '#' + BUILD_TSTAMP_STR + "-sha1:" + rev;
        VER = IgniteProductVersion.fromString(VER_STR + '-' + BUILD_TSTAMP + '-' + REV_HASH_STR);
    }
}

