/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query.exceptions;

import java.sql.SQLException;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;

public class SqlCacheException
extends CacheException {
    private static final long serialVersionUID = 0L;
    private final String sqlState;
    private final int errCode;

    public SqlCacheException(String message, int errCode, Throwable cause) {
        super(message, cause);
        this.errCode = errCode;
        this.sqlState = IgniteQueryErrorCode.codeToSqlState(errCode);
    }

    public int statusCode() {
        return this.errCode;
    }

    public String sqlState() {
        return this.sqlState;
    }

    public SQLException toJdbcException() {
        return new SQLException(this.getMessage(), this.sqlState, this.errCode, (Throwable)((Object)this));
    }
}

