/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheException;
import javax.cache.configuration.OptionalFeature;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheManager;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CachingProvider
implements javax.cache.spi.CachingProvider {
    private static final URI DEFAULT_URI;
    public static final Properties DFLT_PROPS;
    private final Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.cache.CacheManager getCacheManager(@Nullable URI uri, ClassLoader clsLdr, Properties props) throws CacheException {
        GridFutureAdapter<CacheManager> fut;
        Map<URI, GridFutureAdapter<CacheManager>> uriMap;
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        if (clsLdr == null) {
            clsLdr = this.getDefaultClassLoader();
        }
        boolean needStartMgr = false;
        Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map = this.cacheManagers;
        synchronized (map) {
            uriMap = this.cacheManagers.get(clsLdr);
            if (uriMap == null) {
                uriMap = new HashMap<URI, GridFutureAdapter<CacheManager>>();
                this.cacheManagers.put(clsLdr, uriMap);
            }
            if ((fut = uriMap.get(uri)) == null) {
                needStartMgr = true;
                fut = new GridFutureAdapter();
                uriMap.put(uri, fut);
            }
        }
        if (needStartMgr) {
            try {
                CacheManager mgr = new CacheManager(uri, this, clsLdr, props);
                fut.onDone(mgr);
                return mgr;
            }
            catch (Throwable e) {
                Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map2 = this.cacheManagers;
                synchronized (map2) {
                    uriMap.remove(uri);
                }
                fut.onDone(e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw CU.convertToCacheException(U.cast(e));
            }
        }
        try {
            return fut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return DEFAULT_URI;
    }

    public Properties getDefaultProperties() {
        return DFLT_PROPS;
    }

    public javax.cache.CacheManager getCacheManager(URI uri, ClassLoader clsLdr) {
        return this.getCacheManager(uri, clsLdr, this.getDefaultProperties());
    }

    public javax.cache.CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.cache.CacheManager findManager(Ignite ignite) {
        Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map = this.cacheManagers;
        synchronized (map) {
            for (Map<URI, GridFutureAdapter<CacheManager>> map2 : this.cacheManagers.values()) {
                for (GridFutureAdapter<CacheManager> fut : map2.values()) {
                    if (!fut.isDone()) continue;
                    assert (!fut.isFailed());
                    try {
                        CacheManager mgr = fut.get();
                        if (mgr.unwrap(Ignite.class) != ignite) continue;
                        return mgr;
                    }
                    catch (IgniteCheckedException e) {
                        throw CU.convertToCacheException(e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<GridFutureAdapter<CacheManager>> futs = new ArrayList<GridFutureAdapter<CacheManager>>();
        Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map = this.cacheManagers;
        synchronized (map) {
            for (Map<URI, GridFutureAdapter<CacheManager>> uriMap : this.cacheManagers.values()) {
                futs.addAll(uriMap.values());
            }
            this.cacheManagers.clear();
        }
        this.closeManagers(futs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader clsLdr) {
        Map<URI, GridFutureAdapter<CacheManager>> uriMap;
        Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map = this.cacheManagers;
        synchronized (map) {
            uriMap = this.cacheManagers.remove(clsLdr);
        }
        if (uriMap == null) {
            return;
        }
        this.closeManagers(uriMap.values());
    }

    private void closeManagers(Collection<GridFutureAdapter<CacheManager>> futs) {
        for (GridFutureAdapter<CacheManager> fut : futs) {
            try {
                CacheManager mgr = fut.get();
                mgr.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClosedManager(CacheManager mgr) {
        Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map = this.cacheManagers;
        synchronized (map) {
            Map<URI, GridFutureAdapter<CacheManager>> uriMap = this.cacheManagers.get(mgr.getClassLoader());
            GridFutureAdapter<CacheManager> fut = uriMap.get(mgr.getURI());
            if (fut != null && fut.isDone() && !fut.isFailed()) {
                try {
                    CacheManager cachedManager = fut.get();
                    if (cachedManager == mgr) {
                        uriMap.remove(mgr.getURI());
                    }
                }
                catch (IgniteCheckedException e) {
                    throw CU.convertToCacheException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader clsLdr) {
        GridFutureAdapter<CacheManager> fut;
        Map<ClassLoader, Map<URI, GridFutureAdapter<CacheManager>>> map = this.cacheManagers;
        synchronized (map) {
            Map<URI, GridFutureAdapter<CacheManager>> uriMap = this.cacheManagers.get(clsLdr);
            if (uriMap == null) {
                return;
            }
            fut = uriMap.remove(uri);
        }
        if (fut != null) {
            CacheManager mgr;
            try {
                mgr = fut.get();
            }
            catch (Exception ignored) {
                return;
            }
            mgr.close();
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return false;
    }

    static {
        URI uri = null;
        try {
            URL dfltCfgURL = U.resolveIgniteUrl("config/default-config.xml");
            if (dfltCfgURL != null) {
                uri = dfltCfgURL.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uri == null) {
            uri = URI.create("ignite://default");
        }
        DEFAULT_URI = uri;
        DFLT_PROPS = new Properties();
    }
}

