/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.EOFException;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneWalRecordsIterator;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandaloneWalRecordsIteratorIgnoreError
extends StandaloneWalRecordsIterator {
    public StandaloneWalRecordsIteratorIgnoreError(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull FileIOFactory ioFactory, @NotNull List<FileDescriptor> walFiles, IgniteBiPredicate<WALRecord.RecordType, WALPointer> readTypeFilter, FileWALPointer lowBound, FileWALPointer highBound, boolean keepBinary, int initialReadBufferSize, boolean strictBoundsCheck) throws IgniteCheckedException {
        super(log, sharedCtx, ioFactory, walFiles, readTypeFilter, lowBound, highBound, keepBinary, initialReadBufferSize, strictBoundsCheck);
    }

    protected IgniteCheckedException handleRecordException(@NotNull Exception e, @Nullable FileWALPointer ptr) {
        return null;
    }

    protected IgniteBiTuple<WALPointer, WALRecord> advanceRecord(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle hnd) {
        if (hnd == null) {
            return null;
        }
        IgniteBiTuple result = null;
        while (result == null) {
            FileWALPointer actualFilePtr = new FileWALPointer(hnd.idx(), (int)hnd.in().position(), 0);
            try {
                WALRecord rec = hnd.ser().readRecord(hnd.in(), (WALPointer)actualFilePtr);
                actualFilePtr.length(rec.size());
                result = new IgniteBiTuple((Object)actualFilePtr, (Object)this.postProcessRecord(rec));
            }
            catch (EOFException | SegmentEofException eof) {
                this.log.error("Critical exception has happened during WAL was scanned", eof);
                break;
            }
            catch (Exception ignore) {
                this.log.error("Critical exception has happened during WAL was scanned", (Throwable)ignore);
                try {
                    FileInput in = hnd.in();
                    in.seek((long)actualFilePtr.fileOffset());
                    int recordType = in.readUnsignedByte() - 1;
                    long idx = in.readLong();
                    int offset = in.readInt();
                    int len = in.readInt();
                    in.seek((long)(offset + len));
                    this.log.error("Error read record [recordType=" + recordType + ", idx=" + idx + ", offset=" + offset + ", len=" + len + "]", (Throwable)ignore);
                }
                catch (Exception e) {
                    this.log.error("Couldn't miss read error", (Throwable)e);
                    break;
                }
            }
        }
        return result;
    }
}

