/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.jetbrains.annotations.Nullable;

public class IgniteIndexReaderFilePageStoreFactoryImpl
implements IgniteIndexReaderFilePageStoreFactory {
    private final File dir;
    private final FileVersionCheckingFactory storeFactory;
    private final LongAdderMetric allocationTracker = new LongAdderMetric("n", "d");
    private final int pageSize;
    private final int partCnt;

    public IgniteIndexReaderFilePageStoreFactoryImpl(File dir, int pageSize, int partCnt, final int filePageStoreVer) {
        this.dir = dir;
        this.pageSize = pageSize;
        this.partCnt = partCnt;
        this.storeFactory = new FileVersionCheckingFactory((FileIOFactory)new AsyncFileIOFactory(), (FileIOFactory)new AsyncFileIOFactory(), new DataStorageConfiguration().setPageSize(pageSize)){

            public int latestVersion() {
                return filePageStoreVer;
            }
        };
    }

    @Override
    @Nullable
    public FilePageStore createFilePageStore(int partId, byte type, Collection<Throwable> errors) throws IgniteCheckedException {
        File file = this.getFile(this.dir, partId, null);
        return !file.exists() ? null : (FilePageStore)this.storeFactory.createPageStore(type, file, arg_0 -> ((LongAdderMetric)this.allocationTracker).add(arg_0));
    }

    @Override
    public ByteBuffer headerBuffer(byte type) {
        int ver = this.storeFactory.latestVersion();
        FilePageStore store = this.storeFactory.createPageStore(type, null, ver, arg_0 -> ((LongAdderMetric)this.allocationTracker).add(arg_0));
        return store.header(type, this.storeFactory.headerSize(ver));
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public int partitionCount() {
        return this.partCnt;
    }
}

