/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.visor.dr.VisorDrStateTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrStateTaskResult;

public class DrStateCommand
extends DrAbstractRemoteSubCommand<VisorDrStateTaskArgs, VisorDrStateTaskResult, DrStateArguments> {
    public static final String VERBOSE_PARAM = "--verbose";

    @Override
    protected String visorTaskName() {
        return "org.gridgain.grid.internal.visor.dr.console.VisorDrStateTask";
    }

    @Override
    protected DrStateArguments parseArguments0(CommandArgIterator argIter) {
        boolean verbose = false;
        if (VERBOSE_PARAM.equalsIgnoreCase(argIter.peekNextArg())) {
            argIter.nextArg("--verbose is expected");
            verbose = true;
        }
        return new DrStateArguments(verbose);
    }

    @Override
    protected void printResult(VisorDrStateTaskResult res, Logger log) {
        this.printUnrecognizedNodesMessage(log, false);
        log.info("Data Center ID: " + res.getDataCenterId());
        log.info("--------------------------------------------------------------------------------");
        if (res.getDataCenterId() == 0) {
            log.info("Data Replication state: is not configured.");
            return;
        }
        for (String msg : res.getResultMessages()) {
            log.info(msg);
        }
    }

    @Override
    public String name() {
        return DrSubCommandsList.STATE.text();
    }

    public static class DrStateArguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrStateTaskArgs> {
        public final boolean verbose;

        public DrStateArguments(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public VisorDrStateTaskArgs toVisorArgs() {
            return new VisorDrStateTaskArgs(this.verbose);
        }
    }
}

