/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrCacheCommand;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskResult;

public class DrResumeCommand
extends DrAbstractRemoteSubCommand<VisorDrCacheTaskArgs, VisorDrCacheTaskResult, DrCacheCommand.DrCacheArguments> {
    @Override
    protected String visorTaskName() {
        throw new UnsupportedOperationException("visorTaskName");
    }

    @Override
    public DrCacheCommand.DrCacheArguments parseArguments0(CommandArgIterator argIter) {
        return new DrCacheCommand.DrCacheArguments(".*", Pattern.compile(".*"), false, false, DrCacheCommand.CacheFilter.ALL, DrCacheCommand.SenderGroup.ALL, null, DrCacheCommand.Action.START, argIter.nextByteArg("remoteDataCenterId"), false);
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: this command will resume data center replication for all caches.";
    }

    @Override
    protected VisorDrCacheTaskResult execute0(GridClientConfiguration clientCfg, GridClient client) throws Exception {
        return DrCacheCommand.execute0(client, (DrCacheCommand.DrCacheArguments)this.arg());
    }

    @Override
    protected void printResult(VisorDrCacheTaskResult res, Logger log) {
        this.printUnrecognizedNodesMessage(log, false);
        log.info("Data Center ID: " + res.getDataCenterId());
        log.info("--------------------------------------------------------------------------------");
        if (res.getDataCenterId() == 0) {
            log.info("Data Replication state: is not configured.");
            return;
        }
        if (((DrCacheCommand.DrCacheArguments)this.arg()).getActionCoordinator() == null) {
            log.info("Cannot find sender hub node to execute action.");
        }
        for (String msg : res.getResultMessages()) {
            log.info(msg);
        }
    }

    @Override
    public String name() {
        return DrSubCommandsList.RESUME.text();
    }
}

