/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.ResetLostPartitionsCommandArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionGroup;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionNode;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionPartition;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTask;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskResult;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTask;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskArg;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskResult;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;

public class ResetLostPartitions
extends AbstractCommand<Set<String>> {
    private static String CACHES = "cacheName1,...,cacheNameN";
    private Set<String> caches;

    @Override
    public void printUsage(Logger logger) {
        String description = "Reset the state of lost partitions for the specified or all affected caches.";
        CacheCommands.usageCache(logger, CacheSubcommands.RESET_LOST_PARTITIONS, description, null, CommandLogger.or(CACHES, ResetLostPartitionsCommandArg.ALL_CACHES_MODE));
    }

    @Override
    public Set<String> arg() {
        return this.caches;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        if (this.caches == null) {
            this.getAffectedCaches(clientCfg, logger);
        }
        CacheResetLostPartitionsTaskArg taskArg = new CacheResetLostPartitionsTaskArg(this.caches);
        try (GridClient client = Command.startClient(clientCfg);){
            CacheResetLostPartitionsTaskResult res = (CacheResetLostPartitionsTaskResult)TaskExecutor.executeTaskByNameOnNode(client, CacheResetLostPartitionsTask.class.getName(), taskArg, null, clientCfg);
            res.print(System.out);
            CacheResetLostPartitionsTaskResult cacheResetLostPartitionsTaskResult = res;
            return cacheResetLostPartitionsTaskResult;
        }
    }

    private void getAffectedCaches(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        logger.info("ALL mode is activated.");
        logger.info("Looking for the caches with LOST partitions first...");
        this.caches = new HashSet<String>();
        CacheDistributionTaskArg taskArg = new CacheDistributionTaskArg(null, null);
        try (GridClient client = Command.startClient(clientCfg);){
            CacheDistributionTaskResult res = (CacheDistributionTaskResult)TaskExecutor.executeTaskByNameOnNode(client, CacheDistributionTask.class.getName(), taskArg, TaskExecutor.BROADCAST_UUID, clientCfg);
            for (CacheDistributionNode node : res.jobResults()) {
                block10: for (CacheDistributionGroup group : node.getGroups()) {
                    for (CacheDistributionPartition partition : group.getPartitions()) {
                        if (partition.getState() != GridDhtPartitionState.LOST) continue;
                        this.caches.addAll(group.cacheNames());
                        continue block10;
                    }
                }
            }
        }
        if (!this.caches.isEmpty()) {
            logger.info("The following caches have LOST partitions: " + CommandLogger.join(",", this.caches) + ".");
        } else {
            logger.info("No caches with LOST partition has been found found.");
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Expected either [" + ResetLostPartitionsCommandArg.ALL_CACHES_MODE + "] or [" + CACHES + "]");
        }
        String nextArg = argIter.nextArg("");
        ResetLostPartitionsCommandArg arg = CommandArgUtils.of(nextArg, ResetLostPartitionsCommandArg.class);
        if (arg == ResetLostPartitionsCommandArg.ALL_CACHES_MODE) {
            this.caches = null;
        } else {
            this.caches = new HashSet<String>();
            for (String cacheName : nextArg.split(",")) {
                this.caches.add(cacheName.trim());
            }
        }
    }

    @Override
    public String name() {
        return CacheSubcommands.RESET_LOST_PARTITIONS.text().toUpperCase();
    }
}

