/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.NotNull;

public class CommandArgIterator {
    private final Iterator<String> argsIt;
    private String peekedArg;
    private final Set<String> commonArgumentsAndHighLevelCommandSet;

    public CommandArgIterator(Iterator<String> argsIt, Set<String> commonArgumentsAndHighLevelCommandSet) {
        this.argsIt = argsIt;
        this.commonArgumentsAndHighLevelCommandSet = commonArgumentsAndHighLevelCommandSet;
    }

    public boolean hasNextArg() {
        return this.peekedArg != null || this.argsIt.hasNext();
    }

    public boolean hasNextSubArg() {
        return this.hasNextArg() && !this.isKnownCommandOrOption(this.peekNextArg());
    }

    public String nextArg(String err) {
        if (this.peekedArg != null) {
            String res = this.peekedArg;
            this.peekedArg = null;
            return res;
        }
        if (this.argsIt.hasNext()) {
            return this.argsIt.next();
        }
        throw new IllegalArgumentException(err);
    }

    @NotNull
    public String nextArgValue(String argName) {
        return this.nextToken(CommandArgIterator.msgExpectedArgValueButNothing(argName), input -> CommandArgIterator.msgExpectedArgValueButGot(argName, input));
    }

    @NotNull
    public String nextToken(String errOnNoData, Function<String, String> unexpectedDataErrMapper) {
        String next = this.nextArg(errOnNoData);
        if (this.isKnownCommandOrOption(next)) {
            throw new IllegalArgumentException(unexpectedDataErrMapper.apply(next));
        }
        return next;
    }

    @NotNull
    public <E extends Enum<E>> E nextCmdArgOrFail(Class<E> type, String argName) {
        String val = this.nextArgValue(argName);
        return (E)((Enum)CommandArgUtils.failIfNull(CommandArgUtils.ofArg(type, val), CommandArgIterator.msgExpectedArgValueButGot(argName, val)));
    }

    @NotNull
    public <E extends Enum<E>> E nextEnumOrFail(Class<E> type, String argName) {
        String val = this.nextArgValue(argName);
        return (E)((Enum)CommandArgUtils.failIfNull(CommandArgUtils.ofEnum(type, val), CommandArgIterator.msgExpectedArgValueButGot(argName, val)));
    }

    public String peekNextArg() {
        if (this.peekedArg == null && this.argsIt.hasNext()) {
            this.peekedArg = this.argsIt.next();
        }
        return this.peekedArg;
    }

    public long nextNonNegativeLongArg(String argName) {
        long val = this.nextLongArg(argName);
        if (val < 0L) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + val);
        }
        return val;
    }

    public int nextNonNegativeIntArg(String argName) {
        int val = this.nextIntArg(argName);
        if (val < 0) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + val);
        }
        return val;
    }

    public long nextLongArg(String argName) {
        String str = this.nextArg("Expecting " + argName);
        try {
            return str.startsWith("0x") ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + str);
        }
    }

    public int nextIntArg(String argName) {
        String str = this.nextArg("Expecting " + argName);
        try {
            return str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + str);
        }
    }

    public byte nextByteArg(String argName) {
        String str = this.nextArg("Expecting " + argName);
        try {
            byte val = Byte.parseByte(str);
            if (val < 0) {
                throw new IllegalArgumentException("Invalid value for " + argName + ": " + val);
            }
            return val;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + str);
        }
    }

    public Set<String> nextStringSet(String expectedValDescr) {
        return this.nextStringSet0(expectedValDescr, false);
    }

    public Set<String> nextNonEmptyStringSet(String expectedValDescr) {
        return this.nextStringSet0(expectedValDescr, true);
    }

    public Set<String> nextStringSet0(String expectedValDescr, boolean requireNonEmpty) {
        String nextArg = this.peekNextArg();
        if (CommandArgIterator.isCommandOrOption(nextArg)) {
            if (requireNonEmpty) {
                throw new IllegalArgumentException(CommandArgIterator.msgExpectedButGot(expectedValDescr, nextArg));
            }
            return Collections.emptySet();
        }
        nextArg = this.nextToken(CommandArgIterator.msgExpected(expectedValDescr), input -> CommandArgIterator.msgExpectedButGot(expectedValDescr, input));
        return this.parseStringSet(nextArg);
    }

    @NotNull
    public Set<String> parseStringSet(String string) {
        HashSet<String> namesSet = new HashSet<String>();
        for (String name : string.split(",")) {
            if (F.isEmpty((String)name)) {
                throw new IllegalArgumentException("Non-empty string expected.");
            }
            namesSet.add(name.trim());
        }
        return namesSet;
    }

    @NotNull
    public Set<String> nextCachesSet0(String cachesArgName, boolean groups) {
        return this.nextStringSet0("set of cache" + (groups ? "s" : " groups") + " for '" + cachesArgName + "' parameter", true);
    }

    @NotNull
    public Set<String> nextCachesSet(String cachesArgName) {
        return this.nextCachesSet0(cachesArgName, false);
    }

    @NotNull
    public Set<String> nextCacheGroupsSet(String cachesGroupsArgName) {
        return this.nextCachesSet0(cachesGroupsArgName, true);
    }

    public UUID nextUuidArg(String argName) {
        String str = this.nextArg("Expecting " + argName);
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException("Invalid value for " + argName + " (must be UUID): " + str);
        }
    }

    public static boolean isCommandOrOption(String raw) {
        return raw != null && raw.contains("--");
    }

    private boolean isKnownCommandOrOption(String val) {
        return CommandList.of(val) != null || this.commonArgumentsAndHighLevelCommandSet.contains(val) || "--yes".equals(val);
    }

    private static String msgExpected(String val) {
        return "Expected " + val;
    }

    private static String msgExpectedButNothing(String expectedDataDescription) {
        return CommandArgIterator.msgExpected(expectedDataDescription) + " but no data provided";
    }

    private static String msgExpectedArgValueButNothing(String argName) {
        return CommandArgIterator.msgExpectedButNothing("value for '" + argName + "'");
    }

    private static String msgExpectedButGot(String expectedDataDescription, String unexpectedInput) {
        return CommandArgIterator.msgExpected(expectedDataDescription) + " but got '" + unexpectedInput + "'";
    }

    private static String msgExpectedArgValueButGot(String argName, String unexpectedInput) {
        return CommandArgIterator.msgExpectedButGot("value for '" + argName + "'", unexpectedInput);
    }
}

