/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.baseline.BaselineArguments;
import org.apache.ignite.internal.commandline.baseline.BaselineSubcommands;
import org.apache.ignite.internal.commandline.util.TopologyUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.baseline.VisorBaselineNode;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTask;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskArg;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskResult;

public class ClusterStateChangeCommand
extends AbstractCommand<ClusterState> {
    public static final String FORCE_COMMAND = "--force";
    private ClusterState state;
    private String clusterName;
    private boolean forceDeactivation;
    private boolean partialActivationCheckComplete = false;
    private String partialActivationMsg = null;

    @Override
    public void printUsage(Logger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(ClusterState.ACTIVE.toString(), "Activate cluster. Cache updates are allowed.");
        params.put(ClusterState.INACTIVE.toString(), "Deactivate cluster.");
        params.put(ClusterState.ACTIVE_READ_ONLY.toString(), "Activate cluster. Cache updates are denied.");
        Command.usage(log, "Change cluster state:", CommandList.SET_STATE, params, CommandLogger.or(ClusterState.values()), CommandLogger.optional(FORCE_COMMAND), CommandLogger.optional("--yes"));
    }

    @Override
    public void prepareConfirmation(GridClientConfiguration clientCfg) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            GridClientClusterState clientState = client.state();
            if (!clientState.state().equals((Object)ClusterState.INACTIVE)) {
                this.clusterName = clientState.clusterName();
            }
            if (this.state == ClusterState.ACTIVE) {
                this.partialActivationMsg = this.partialActivationCheck(client, clientCfg);
            }
        }
    }

    @Override
    public String confirmationPrompt() {
        String prompt = "Warning: the command will change state of cluster with name \"" + this.clusterName + "\" to " + this.state + ".";
        if (this.partialActivationMsg != null) {
            prompt = this.partialActivationMsg + "\n" + prompt;
        }
        return prompt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Set serverNodes = client.compute().nodes().stream().filter(n -> !n.isClient() && !n.isDaemon()).collect(Collectors.toSet());
            Set supportedServerNodes = serverNodes.stream().filter(n -> n.supports(IgniteFeatures.CLUSTER_READ_ONLY_MODE)).collect(Collectors.toSet());
            Set notSupportedSafeDeactivation = supportedServerNodes.stream().filter(n -> !n.supports(IgniteFeatures.SAFE_CLUSTER_DEACTIVATION)).collect(Collectors.toSet());
            if (!supportedServerNodes.equals(serverNodes) && this.state == ClusterState.ACTIVE_READ_ONLY) {
                throw new IgniteException("Not all nodes in cluster supports cluster state " + this.state);
            }
            if (!notSupportedSafeDeactivation.isEmpty() && this.state == ClusterState.INACTIVE && !this.forceDeactivation) {
                throw new GridClientException("Deactivation stopped. Found a nodes that do not support the correctness checking of this operation: " + notSupportedSafeDeactivation + ". Deactivation clears in-memory caches (without persistence) including the system caches. To deactivate cluster pass '--force' flag.");
            }
            if (F.isEmpty(supportedServerNodes)) {
                client.state().active(ClusterState.active((ClusterState)this.state));
            } else if (notSupportedSafeDeactivation.isEmpty()) {
                client.state().state(this.state, this.forceDeactivation);
            } else {
                client.state().state(this.state);
            }
            if (this.state == ClusterState.ACTIVE && !this.partialActivationCheckComplete) {
                this.partialActivationMsg = this.partialActivationCheck(client, clientCfg);
            }
            if (this.partialActivationMsg != null) {
                log.warning(this.partialActivationMsg);
            }
            log.info("Cluster state changed to " + this.state);
            Object var8_10 = null;
            return var8_10;
        }
        catch (Throwable e) {
            log.info("Failed to change cluster state to " + this.state);
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String arg;
        String s = argIter.nextArg("New cluster state not found.");
        try {
            this.state = ClusterState.valueOf((String)s.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't parse new cluster state. State: " + s, e);
        }
        this.forceDeactivation = false;
        if (argIter.hasNextArg() && FORCE_COMMAND.equalsIgnoreCase(arg = argIter.peekNextArg())) {
            this.forceDeactivation = true;
            argIter.nextArg("");
        }
    }

    private String partialActivationCheck(GridClient client, GridClientConfiguration clientCfg) throws GridClientException {
        BaselineArguments args = new BaselineArguments.Builder(BaselineSubcommands.COLLECT).build();
        HashSet<String> offlineNodes = new HashSet<String>();
        this.partialActivationCheckComplete = true;
        VisorBaselineTaskResult res = (VisorBaselineTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorBaselineTask.class.getName(), new VisorBaselineTaskArg(args.getCmd().visorBaselineOperation(), args.getTopVer(), args.getConsistentIds()), TopologyUtils.coordinatorId(client.compute()), clientCfg);
        Map baseline = res.getBaseline();
        if (baseline == null) {
            return null;
        }
        for (VisorBaselineNode node : baseline.values()) {
            String constId = node.getConsistentId();
            VisorBaselineNode srvNode = (VisorBaselineNode)res.getServers().get(constId);
            if (srvNode != null) continue;
            offlineNodes.add(constId);
        }
        if (!offlineNodes.isEmpty()) {
            return "Partial activation detected. Baseline has " + offlineNodes.size() + " offline node(s).\nOffline node(s) = " + offlineNodes + "\nThis may lead to partition loss. Please ensure that this is intended.";
        }
        return null;
    }

    @Override
    public ClusterState arg() {
        return this.state;
    }

    @Override
    public String name() {
        return CommandList.SET_STATE.toCommandName();
    }
}

