/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Collection;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTask;
import org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTaskResult;

public class CheckpointCommand
extends AbstractCommand<Void> {
    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Start checkpointing process:", CommandList.CHECKPOINT, new String[0]);
    }

    @Override
    public String name() {
        return CommandList.CHECKPOINT.toCommandName();
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            GridClientCompute compute = client.compute();
            Collection nodes = compute.nodes(n -> n.connectable() && !n.isClient());
            if (F.isEmpty((Collection)nodes)) {
                throw new GridClientDisconnectedException("Connectable nodes not found", null);
            }
            VisorCheckpointTaskResult res = (VisorCheckpointTaskResult)compute.projection(nodes).execute(VisorCheckpointTask.class.getName(), (Object)new VisorTaskArgument((Collection)nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList()), (Object)this.arg(), false));
            if (res.isSuccess()) {
                log.info("Checkpointing completed successfully on " + res.numberOfSuccessNodes() + " nodes.");
            } else {
                log.info("Checkpointing completed with errors. Number of failed nodes: " + res.numberOfFailedNodes() + ".");
            }
        }
        catch (Throwable e) {
            log.severe("Failed to execute checkpointing command='" + this.name() + "'");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    @Override
    public Void arg() {
        return null;
    }
}

