/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate.mappings;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.oracle.goldengate.mappings.TableInfo;
import org.gridgain.oracle.goldengate.mappings.TableInfoProvider;

public class ClasspathTableInfoProvider
implements TableInfoProvider {
    private final Map<String, TableInfo> tblInfoMap = new HashMap<String, TableInfo>();
    private Logger startupLog = LogManager.getLogger((String)"startupLog");

    public ClasspathTableInfoProvider() {
        Pattern ptrn = Pattern.compile("^(.+)\\.(.+)=(.+)$");
        String mappingFileName = System.getProperty("mapping.file.name");
        if (mappingFileName == null) {
            this.startupLog.info("Property mapping.file.name hasn't been provided");
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(mappingFileName);){
            Scanner scanner = new Scanner(inputStream);
            block21: while (scanner.hasNextLine()) {
                String mapping = scanner.nextLine();
                Matcher matcher = ptrn.matcher(mapping);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Wrong format of line " + mapping);
                }
                String tblName = matcher.group(1);
                String propName = matcher.group(2);
                String propVal = matcher.group(3);
                TableInfo tblInfo = this.tblInfoMap.computeIfAbsent(tblName.toUpperCase(), TableInfo::new);
                switch (propName) {
                    case "cacheName": {
                        tblInfo.setCacheName(propVal);
                        continue block21;
                    }
                    case "keyType": {
                        tblInfo.setKeyType(propVal);
                        continue block21;
                    }
                    case "valueType": {
                        tblInfo.setValType(propVal);
                        continue block21;
                    }
                }
                throw new IllegalArgumentException("Unknown property name");
            }
        }
        catch (Exception e) {
            this.startupLog.error("Error reading file " + mappingFileName + " from classpath", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    @Override
    public TableInfo getTableInfo(String tblName) {
        return Optional.ofNullable(this.tblInfoMap.get(tblName.toUpperCase())).orElseGet(() -> new TableInfo(tblName));
    }

    @Override
    public Set<String> getConfiguredTables() {
        return this.tblInfoMap.keySet();
    }
}

