/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate.handlers;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.function.Function;
import org.gridgain.oracle.goldengate.handlers.TypeHandler;

public abstract class AbstractDateHandler<T extends Date>
implements TypeHandler<T> {
    private final Function<LocalDateTime, T> constructor;

    AbstractDateHandler(Function<LocalDateTime, T> constructor) {
        this.constructor = constructor;
    }

    @Override
    public T handle(String val) {
        if (val == null || "NULL".equalsIgnoreCase(val)) {
            return null;
        }
        if (!val.contains(".")) {
            val = val + ".000000000";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn");
        LocalDateTime locUTC = LocalDateTime.parse(val, dateTimeFormatter).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        return (T)((Date)this.constructor.apply(locUTC));
    }
}

