/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.ignite.IgniteException;
import org.gridgain.oracle.goldengate.handlers.BigDecimalHandler;
import org.gridgain.oracle.goldengate.handlers.BooleanHandler;
import org.gridgain.oracle.goldengate.handlers.ByteHandler;
import org.gridgain.oracle.goldengate.handlers.CharHandler;
import org.gridgain.oracle.goldengate.handlers.DateHandler;
import org.gridgain.oracle.goldengate.handlers.DoubleHandler;
import org.gridgain.oracle.goldengate.handlers.FloatHandler;
import org.gridgain.oracle.goldengate.handlers.IntegerHandler;
import org.gridgain.oracle.goldengate.handlers.LongHandler;
import org.gridgain.oracle.goldengate.handlers.ShortHandler;
import org.gridgain.oracle.goldengate.handlers.StringHandler;
import org.gridgain.oracle.goldengate.handlers.TimestampHandler;
import org.gridgain.oracle.goldengate.handlers.TypeHandler;

public final class TypeHandlerRegistry {
    private final Map<String, TypeHandler<?>> typeHndMap = new HashMap();

    public TypeHandlerRegistry() {
        this.register(String.class, new StringHandler());
        this.register(Integer.class, new IntegerHandler());
        this.register(Long.class, new LongHandler());
        this.register(Double.class, new DoubleHandler());
        this.register(Character.class, new CharHandler());
        this.register(BigDecimal.class, new BigDecimalHandler());
        this.register(Byte.class, new ByteHandler());
        this.register(Short.class, new ShortHandler());
        this.register(Float.class, new FloatHandler());
        this.register(Boolean.class, new BooleanHandler());
        this.register(Timestamp.class, new TimestampHandler());
        this.register(Date.class, new DateHandler());
    }

    public TypeHandler getTypeHandler(String typeName) {
        return Optional.ofNullable(this.typeHndMap.get(typeName)).orElseThrow(() -> new IgniteException("Can't find handler for " + typeName + " type"));
    }

    private <T> void register(Class<T> clazz, TypeHandler<? extends T> typeHandler) {
        this.register(clazz.getName(), typeHandler);
    }

    private void register(String typeName, TypeHandler<?> typeHnd) {
        this.typeHndMap.put(typeName, typeHnd);
    }
}

