/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.cache.processor.EntryProcessor;
import oracle.goldengate.datasource.DsColumn;
import oracle.goldengate.datasource.DsOperation;
import oracle.goldengate.datasource.meta.ColumnMetaData;
import oracle.goldengate.datasource.meta.TableMetaData;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.oracle.goldengate.FieldUpdater;
import org.gridgain.oracle.goldengate.TypeHandlerRegistry;
import org.gridgain.oracle.goldengate.handlers.TypeHandler;
import org.gridgain.oracle.goldengate.mappings.TableInfo;

public class TableHandler {
    private Logger procLog = LogManager.getLogger((String)"processLog");
    private static final String GENERATED_KEY = "KEY";
    private static final TypeHandlerRegistry TYPE_HANDLER_REGISTRY = new TypeHandlerRegistry();
    private final Ignite ignite;
    private final IgniteCache<Object, BinaryObject> cache;
    private final String tblName;
    private final String keyType;
    private final String valType;
    final Map<String, TypeHandler<?>> colHndMap = new HashMap();
    final boolean primitiveKey;

    public TableHandler(Ignite ignite, IgniteCache<Object, BinaryObject> cache, TableInfo tblInfo, LinkedHashMap<String, String> fields) {
        this.ignite = ignite;
        this.cache = cache;
        this.tblName = tblInfo.tableName();
        this.keyType = tblInfo.keyType();
        this.valType = tblInfo.valType();
        this.primitiveKey = this.isPrimitiveKey(this.keyType);
        for (Map.Entry<String, String> fieldAndType : fields.entrySet()) {
            this.registerColumn(fieldAndType.getKey(), fieldAndType.getValue());
        }
    }

    private void registerColumn(String colName, String typeName) {
        this.colHndMap.put(colName.toUpperCase(), TYPE_HANDLER_REGISTRY.getTypeHandler(typeName));
    }

    public void handleInsert(TableMetaData tblMeta, DsOperation dsOp, boolean prKeyIsPresent) {
        Object key;
        if (prKeyIsPresent) {
            key = this.prepareKeyForInsertOrDelete(tblMeta, dsOp, true);
        } else {
            BinaryObjectBuilder bKey = this.ignite.binary().builder(this.keyType);
            bKey.setField(GENERATED_KEY, (Object)UUID.randomUUID());
            key = bKey.build();
        }
        BinaryObject val = this.buildBinary(dsOp, this.valType, colMeta -> dsOp.getColumn(colMeta.getIndex()).isMissing() || colMeta.isKeyCol() && prKeyIsPresent, () -> ((TableMetaData)tblMeta).getColumnMetaData(), true);
        this.cache.put(key, (Object)val);
    }

    public void handleUpdate(TableMetaData tblMeta, DsOperation dsOp, boolean prKeyIsPresent) {
        HashMap<String, IgniteBiTuple<Object, Class>> updates = new HashMap<String, IgniteBiTuple<Object, Class>>();
        for (int i = 0; i < tblMeta.getNumColumns(); ++i) {
            DsColumn col;
            ColumnMetaData colMeta = tblMeta.getColumnMetaData(i);
            if (colMeta.isKeyCol() && prKeyIsPresent || (col = dsOp.getColumn(colMeta.getIndex())).isMissing() || !col.isChanged()) continue;
            updates.put(colMeta.getColumnName(), this.getObjectAndClass(colMeta, dsOp, true));
        }
        if (updates.isEmpty()) {
            return;
        }
        Set<Object> keys = this.prepareKeysForUpdate(tblMeta, dsOp, prKeyIsPresent);
        this.cache.invokeAll(keys, (EntryProcessor)new FieldUpdater(), new Object[]{updates});
    }

    public void handleDelete(TableMetaData tblMeta, DsOperation dsOp, boolean prKeyIsPresent) {
        Set<Object> keys;
        if (prKeyIsPresent) {
            keys = new HashSet<Object>();
            keys.add(this.prepareKeyForInsertOrDelete(tblMeta, dsOp, false));
        } else {
            keys = this.selectKeysIfPkIsNotAvailable(tblMeta, dsOp);
        }
        for (Object key : keys) {
            this.cache.remove(key);
        }
    }

    IgniteBiTuple<Object, Class> getObjectAndClass(ColumnMetaData colMeta, DsOperation dsOp, boolean after) {
        String colName = colMeta.getColumnName();
        TypeHandler<?> typeHnd = this.colHndMap.get(colName.toUpperCase());
        if (typeHnd == null) {
            throw new IgniteException("Can't find a handler for " + colName + " column");
        }
        String strVal = this.getValue(dsOp, colMeta.getIndex(), after);
        Object colVal = typeHnd.handle(strVal);
        return new IgniteBiTuple(colVal, typeHnd.getType());
    }

    private Object prepareKeyForInsertOrDelete(TableMetaData tblMeta, DsOperation dsOp, boolean after) {
        Object key;
        if (tblMeta.getNumKeyColumns() == 1) {
            ColumnMetaData colMeta2 = (ColumnMetaData)tblMeta.getKeyColumns().get(0);
            if (this.primitiveKey) {
                key = this.getObjectAndClass(colMeta2, dsOp, after).getKey();
            } else {
                IgniteBiTuple<Object, Class> objAndCls = this.getObjectAndClass(colMeta2, dsOp, after);
                BinaryObjectBuilder bKey = this.ignite.binary().builder(this.keyType);
                bKey.setField(colMeta2.getColumnName(), objAndCls.getKey(), (Class)objAndCls.getValue());
                key = bKey.build();
            }
        } else {
            key = this.buildBinary(dsOp, this.keyType, colMeta -> dsOp.getColumn(colMeta.getIndex()).isMissing(), () -> ((TableMetaData)tblMeta).getKeyColumns(), after);
        }
        return key;
    }

    private Set<Object> prepareKeysForUpdate(TableMetaData tblMeta, DsOperation dsOp, boolean prKeyIsPresent) {
        HashSet<Object> keys;
        boolean needAfterVal = true;
        if (prKeyIsPresent) {
            keys = new HashSet();
            if (tblMeta.getNumKeyColumns() == 1) {
                ColumnMetaData colMeta2 = (ColumnMetaData)tblMeta.getKeyColumns().get(0);
                if (this.primitiveKey) {
                    keys.add(this.getObjectAndClass(colMeta2, dsOp, true).getKey());
                } else {
                    IgniteBiTuple<Object, Class> objAndCls = this.getObjectAndClass(colMeta2, dsOp, true);
                    BinaryObjectBuilder bKey = this.ignite.binary().builder(this.keyType);
                    bKey.setField(colMeta2.getColumnName(), objAndCls.getKey(), (Class)objAndCls.getValue());
                    keys.add(bKey.build());
                }
            } else {
                BinaryObject bKey = this.buildBinary(dsOp, this.keyType, colMeta -> dsOp.getColumn(colMeta.getIndex()).isMissing(), () -> ((TableMetaData)tblMeta).getKeyColumns(), true);
                keys.add(bKey);
            }
        } else {
            keys = this.selectKeysIfPkIsNotAvailable(tblMeta, dsOp);
        }
        return keys;
    }

    private Set<Object> selectKeysIfPkIsNotAvailable(TableMetaData tblMeta, DsOperation dsOp) {
        HashSet<Object> keys = new HashSet<Object>();
        StringBuilder selectSql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        selectSql.append("SELECT ").append(GENERATED_KEY).append(" FROM ").append(this.tblName);
        selectSql.append(" WHERE ");
        for (int i = 0; i < tblMeta.getNumKeyColumns(); ++i) {
            ColumnMetaData colMeta = (ColumnMetaData)tblMeta.getKeyColumns().get(i);
            String colName = colMeta.getColumnName();
            selectSql.append(colName).append(" = ? AND ");
            args.add(this.getObjectAndClass(colMeta, dsOp, false).getKey());
        }
        selectSql.setLength(selectSql.length() - 5);
        this.procLog.debug("Select IDs Statement :: " + selectSql);
        List res = this.cache.query(new SqlFieldsQuery(selectSql.toString()).setArgs(args.toArray())).getAll();
        for (List row : res) {
            BinaryObjectBuilder key = this.ignite.binary().builder(this.keyType);
            key.setField(GENERATED_KEY, row.get(0));
            keys.add(key.build());
        }
        return keys;
    }

    private BinaryObject buildBinary(DsOperation dsOp, String type, Predicate<ColumnMetaData> skipColPred, Supplier<List<ColumnMetaData>> colSupplier, boolean after) {
        BinaryObjectBuilder bldr = this.ignite.binary().builder(type);
        for (ColumnMetaData colMeta : colSupplier.get()) {
            if (skipColPred.test(colMeta)) continue;
            IgniteBiTuple<Object, Class> objAndCls = this.getObjectAndClass(colMeta, dsOp, after);
            bldr.setField(colMeta.getColumnName(), objAndCls.getKey(), (Class)objAndCls.getValue());
        }
        return bldr.build();
    }

    private String getValue(DsOperation dsOp, int colIdx, boolean after) {
        DsColumn dsCol = dsOp.getColumn(colIdx);
        return after ? dsCol.getAfterValue() : dsCol.getBeforeValue();
    }

    private boolean isPrimitiveKey(String type) {
        return Stream.of(Double.class, Integer.class, Long.class, Short.class, Character.class, Byte.class, Float.class, Boolean.class, String.class, BigDecimal.class).map(Class::getName).anyMatch(type::equals);
    }
}

