/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.oracle.goldengate.TableHandler;
import org.gridgain.oracle.goldengate.mappings.TableInfo;
import org.gridgain.oracle.goldengate.mappings.TableInfoProvider;
import org.gridgain.oracle.goldengate.util.GoldenGateUtils;

public class SchemaLoader {
    private final Ignite ignite;
    private final TableInfoProvider tblInfoProvider;
    private final Map<String, IgniteCache<Object, BinaryObject>> existingCaches;

    public SchemaLoader(Ignite ignite, TableInfoProvider tblInfoProvider) {
        this.ignite = ignite;
        this.tblInfoProvider = tblInfoProvider;
        this.existingCaches = ignite.cacheNames().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((Ignite)ignite).cache(arg_0)));
    }

    public TableHandler getHandlerForTable(String tblName) {
        TableInfo tblInfo = this.tblInfoProvider.getTableInfo(tblName);
        String cacheName = tblInfo.cacheName();
        IgniteCache<Object, BinaryObject> cache = this.cacheForTable(cacheName);
        if (cache == null) {
            throw new IgniteException("Replication for the table " + tblName + " isn't configured properly");
        }
        QueryEntity entity = GoldenGateUtils.getQueryEntity(this.ignite, cacheName);
        return new TableHandler(this.ignite, cache, tblInfo, entity.getFields());
    }

    public Set<IgniteBiTuple<String, TableHandler>> loadSchemaForTables() {
        return this.tblInfoProvider.getConfiguredTables().stream().map(tblName -> new IgniteBiTuple(tblName, (Object)this.getHandlerForTable((String)tblName))).collect(Collectors.toSet());
    }

    private IgniteCache<Object, BinaryObject> cacheForTable(String cacheName) {
        IgniteCache cache = this.existingCaches.computeIfAbsent(cacheName, name -> {
            try {
                return Executors.newSingleThreadExecutor().submit(() -> this.ignite.cache(name)).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IgniteException((Throwable)e);
            }
            return null;
        });
        return cache != null ? cache.withKeepBinary() : null;
    }
}

