/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate;

import oracle.goldengate.datasource.AbstractHandler;
import oracle.goldengate.datasource.DsConfiguration;
import oracle.goldengate.datasource.DsEvent;
import oracle.goldengate.datasource.DsOperation;
import oracle.goldengate.datasource.DsTransaction;
import oracle.goldengate.datasource.GGDataSource;
import oracle.goldengate.datasource.meta.DsMetaData;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.resources.SpringApplicationContextResource;
import org.gridgain.oracle.goldengate.DataSourceOperationHandler;
import org.gridgain.oracle.goldengate.OperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridGainHandler
extends AbstractHandler {
    public static final Logger log = LoggerFactory.getLogger(GridGainHandler.class);
    private IgniteKernal ignite;
    private String cfgPath;
    private String operationHndBeanName;
    @SpringApplicationContextResource
    private Object appCtx;
    private long opCntr;
    private long txCntr;
    private DataSourceOperationHandler hnd;

    public void init(DsConfiguration conf, DsMetaData metaData) {
        if (this.cfgPath == null) {
            log.error("Failed to start GridGain Handler: gg.handler." + this.getName() + ".configurationPath property should be set.");
            throw new IgniteException("Failed to start GridGain Handler: gg.handler." + this.getName() + ".configurationPath property should be set.");
        }
        if (this.operationHndBeanName == null) {
            log.error("Failed to start GridGain Handler: gg.handler." + this.getName() + ".operationHandlerBeanName property should be set.");
            throw new IgniteException("Failed to start GridGain Handler: gg.handler." + this.getName() + ".operationHandlerBeanName property should be set.");
        }
        log.info("Initializing GridGain Handler with the following configuration [txMode=" + this.getMode() + ", cfgPath=" + this.cfgPath + ", operationHandlerBeanName=" + this.operationHndBeanName + "].");
        super.init(conf, metaData);
        try {
            Ignition.setClientMode((boolean)true);
            this.ignite = (IgniteKernal)Ignition.start((String)this.cfgPath);
            this.ignite.context().resource().inject(null, GridGainHandler.class, (Object)this);
            if (this.appCtx == null) {
                throw new IgniteException("Failed to inject spring application context.");
            }
            IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
            this.hnd = (DataSourceOperationHandler)spring.loadBeanFromAppContext(this.appCtx, this.operationHndBeanName);
            if (this.hnd == null) {
                throw new IgniteException("Failed to find bean [beanName=" + this.operationHndBeanName + ", cfgPath=" + this.cfgPath + "].");
            }
            this.hnd.init((Ignite)this.ignite);
        }
        catch (IgniteException e) {
            log.error("Failed to start GridGain node: " + e.getMessage(), (Throwable)e);
            if (this.ignite != null) {
                this.ignite.close();
            }
            throw new IgniteException("Failed to start GridGain node.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to initialize GridGain handler: " + e.getMessage(), (Throwable)e);
            if (this.ignite != null) {
                this.ignite.close();
            }
            throw new IgniteException("Failed to initialize GridGain handler.", (Throwable)e);
        }
    }

    public GGDataSource.Status operationAdded(DsEvent e, DsTransaction tx, DsOperation dsOp) {
        GGDataSource.Status status = super.operationAdded(e, tx, dsOp);
        if (this.isOperationMode()) {
            this.hnd.handleOperation(dsOp, new OperationContext(e, this.getMetaData(), this.getConfig()));
            ++this.opCntr;
        }
        return status;
    }

    public GGDataSource.Status transactionCommit(DsEvent e, DsTransaction tx) {
        GGDataSource.Status status = super.transactionCommit(e, tx);
        if (this.getMode().isTransactionMode()) {
            this.hnd.handleTransaction(tx, new OperationContext(e, this.getMetaData(), this.getConfig()));
            ++this.txCntr;
        }
        return status;
    }

    public void destroy() {
        if (this.ignite != null) {
            this.ignite.close();
            this.ignite = null;
        }
        super.destroy();
    }

    public String reportStatus() {
        return "GridGainHandler report [operations=" + this.opCntr + ", transactions=" + this.txCntr + "]";
    }

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public String getOperationHandlerBeanName() {
        return this.operationHndBeanName;
    }

    public void setOperationHandlerBeanName(String operationHndBeanName) {
        this.operationHndBeanName = operationHndBeanName;
    }
}

