/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.oracle.goldengate;

import oracle.goldengate.datasource.DsOperation;
import oracle.goldengate.datasource.DsTransaction;
import oracle.goldengate.datasource.meta.TableMetaData;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.Transaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.oracle.goldengate.DataSourceOperationHandler;
import org.gridgain.oracle.goldengate.OperationContext;
import org.gridgain.oracle.goldengate.SchemaLoader;
import org.gridgain.oracle.goldengate.TableHandler;
import org.gridgain.oracle.goldengate.TableHandlerRegistry;
import org.gridgain.oracle.goldengate.mappings.ClasspathTableInfoProvider;

public class GenericKVHandler
implements DataSourceOperationHandler {
    private Ignite ignite;
    private Logger procLog = LogManager.getLogger((String)"processLog");
    private Logger transactionLog = LogManager.getLogger((String)"transactionLog");
    private Logger startupLog = LogManager.getLogger((String)"startupLog");
    private final TableHandlerRegistry tblHndRegistry = new TableHandlerRegistry();
    private SchemaLoader ldr;

    @Override
    public void init(Ignite ignite) {
        this.startupLog.debug("init (+) Entered init ");
        this.ignite = ignite;
        ClasspathTableInfoProvider mappings = new ClasspathTableInfoProvider();
        this.ldr = new SchemaLoader(ignite, mappings);
        for (IgniteBiTuple<String, TableHandler> tblAndHnd : this.ldr.loadSchemaForTables()) {
            this.tblHndRegistry.register((String)tblAndHnd.getKey(), (TableHandler)tblAndHnd.getValue());
        }
        this.startupLog.debug("init (-) Exit init ");
    }

    @Override
    public void handleOperation(DsOperation operation, OperationContext ctx) {
        this.handle(operation, ctx);
    }

    @Override
    public void handleTransaction(DsTransaction transaction, OperationContext ctx) {
        this.transactionLog.debug("handleTransaction (+) Entered Transaction ");
        try (Transaction igniteTx = this.ignite.transactions().txStart();){
            for (DsOperation op : transaction.getOperations()) {
                this.transactionLog.debug("handleTransaction (=)  Table Name ::" + op.getTableName() + " Operation type ::" + op.getOperationType());
                this.handle(op, ctx);
            }
            igniteTx.commit();
        }
        this.transactionLog.debug("handleTransaction (-) Exit Transaction ");
    }

    private void handle(DsOperation dsOp, OperationContext ctx) {
        TableHandler tblHnd;
        String tblName = dsOp.getTableName().getShortName().toUpperCase();
        this.procLog.debug("handle (+) Table Name ::" + tblName);
        if (!this.tblHndRegistry.isRegistered(tblName)) {
            tblHnd = this.ldr.getHandlerForTable(tblName);
            this.tblHndRegistry.register(tblName, tblHnd);
        } else {
            tblHnd = this.tblHndRegistry.getTableHandler(tblName);
        }
        TableMetaData tblMeta = ctx.getMetaData().getTableMetaData(dsOp.getTableName());
        boolean primaryKeyPresent = this.isPrimaryKeyPresent(tblMeta);
        DsOperation.OpType opType = dsOp.getOperationType();
        switch (opType) {
            case DO_INSERT: {
                this.procLog.debug("handle (=) Entered Insert Statement");
                tblHnd.handleInsert(tblMeta, dsOp, primaryKeyPresent);
                break;
            }
            case DO_UPDATE: 
            case DO_UPDATE_FIELDCOMP: 
            case DO_UPDATE_FIELDCOMP_PK: 
            case DO_UNIFIED_UPDATE_VAL: 
            case DO_UNIFIED_PK_UPDATE_VAL: {
                this.procLog.debug("handle (=) Entered Update Statement");
                tblHnd.handleUpdate(tblMeta, dsOp, primaryKeyPresent);
                break;
            }
            case DO_DELETE: {
                this.procLog.debug("handle (=) Entered Delete Statement");
                tblHnd.handleDelete(tblMeta, dsOp, primaryKeyPresent);
                break;
            }
            default: {
                this.procLog.error("Unknown operation: " + opType);
            }
        }
    }

    private boolean isPrimaryKeyPresent(TableMetaData tblMeta) {
        int cnt = 0;
        for (int i = 0; i < tblMeta.getNumColumns(); ++i) {
            if (tblMeta.getColumnMetaData(i).getNativeDataType() == 112) continue;
            ++cnt;
        }
        return cnt != tblMeta.getNumKeyColumns();
    }
}

