/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata22.repository.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.springdata.proxy.IgniteCacheProxy;
import org.apache.ignite.springdata.proxy.IgniteClientProxy;
import org.apache.ignite.springdata.proxy.IgniteProxy;
import org.apache.ignite.springdata.proxy.IgniteProxyImpl;
import org.apache.ignite.springdata22.repository.IgniteRepository;
import org.apache.ignite.springdata22.repository.config.DynamicQueryConfig;
import org.apache.ignite.springdata22.repository.config.Query;
import org.apache.ignite.springdata22.repository.config.RepositoryConfig;
import org.apache.ignite.springdata22.repository.query.IgniteQuery;
import org.apache.ignite.springdata22.repository.query.IgniteQueryGenerator;
import org.apache.ignite.springdata22.repository.query.IgniteRepositoryQuery;
import org.apache.ignite.springdata22.repository.support.IgniteRepositoryImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IgniteRepositoryFactory
extends RepositoryFactorySupport {
    private final ApplicationContext ctx;
    private final DefaultListableBeanFactory beanFactory;
    private final StandardBeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private final BeanExpressionContext beanExpressionContext;
    private final Map<Class<?>, String> repoToCache = new HashMap();
    private final Map<Class<?>, IgniteProxy> repoToIgnite = new HashMap();

    public IgniteRepositoryFactory(ApplicationContext ctx) {
        this.ctx = ctx;
        this.beanFactory = new DefaultListableBeanFactory((BeanFactory)ctx.getAutowireCapableBeanFactory());
        this.beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null);
    }

    private IgniteProxy igniteForRepoConfig(RepositoryConfig config) {
        try {
            Object igniteInstanceBean = this.ctx.getBean(this.evaluateExpression(config.igniteInstance()));
            if (igniteInstanceBean instanceof Ignite) {
                return new IgniteProxyImpl((Ignite)igniteInstanceBean);
            }
            if (igniteInstanceBean instanceof IgniteClient) {
                return new IgniteClientProxy((IgniteClient)igniteInstanceBean);
            }
            throw new IllegalStateException("Invalid repository configuration. The Spring Bean corresponding to the \"igniteInstance\" property of repository configuration must be one of the following types: " + Ignite.class.getName() + ", " + IgniteClient.class.getName());
        }
        catch (BeansException ex) {
            try {
                Object igniteCfgBean = this.ctx.getBean(this.evaluateExpression(config.igniteCfg()));
                if (igniteCfgBean instanceof IgniteConfiguration) {
                    try {
                        return new IgniteProxyImpl(Ignition.ignite((String)((IgniteConfiguration)igniteCfgBean).getIgniteInstanceName()));
                    }
                    catch (Exception exception) {
                        return new IgniteProxyImpl(Ignition.start((IgniteConfiguration)((IgniteConfiguration)igniteCfgBean)));
                    }
                }
                if (igniteCfgBean instanceof ClientConfiguration) {
                    return new IgniteClientProxy(Ignition.startClient((ClientConfiguration)((ClientConfiguration)igniteCfgBean)));
                }
                throw new IllegalStateException("Invalid repository configuration. The Spring Bean corresponding to the \"igniteCfg\" property of repository configuration must be one of the following types: [" + IgniteConfiguration.class.getName() + ", " + ClientConfiguration.class.getName() + ']');
            }
            catch (BeansException ex2) {
                try {
                    String igniteSpringCfgPath = this.evaluateExpression(config.igniteSpringCfgPath());
                    String path = (String)this.ctx.getBean(igniteSpringCfgPath);
                    return new IgniteProxyImpl(Ignition.start((String)path));
                }
                catch (BeansException ex3) {
                    throw new IgniteException("Failed to initialize Ignite repository factory. No beans required for repository configuration were found. Check \"igniteInstance\", \"igniteCfg\", \"igniteSpringCfgPath\" parameters of " + RepositoryConfig.class.getName() + "class.");
                }
            }
        }
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new AbstractEntityInformation<T, ID>(domainClass){

            public ID getId(T entity) {
                return null;
            }

            public Class<ID> getIdType() {
                return null;
            }
        };
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return IgniteRepositoryImpl.class;
    }

    protected synchronized RepositoryMetadata getRepositoryMetadata(Class<?> repoItf) {
        Assert.notNull(repoItf, (String)"Repository interface must be set.");
        Assert.isAssignable(IgniteRepository.class, repoItf, (String)"Repository must implement IgniteRepository interface.");
        RepositoryConfig annotation = repoItf.getAnnotation(RepositoryConfig.class);
        Assert.notNull((Object)annotation, (String)"Set a name of an Apache Ignite cache using @RepositoryConfig annotation to map this repository to the underlying cache.");
        Assert.hasText((String)annotation.cacheName(), (String)"Set a name of an Apache Ignite cache using @RepositoryConfig annotation to map this repository to the underlying cache.");
        String cacheName = this.evaluateExpression(annotation.cacheName());
        this.repoToCache.put(repoItf, cacheName);
        this.repoToIgnite.put(repoItf, this.igniteForRepoConfig(annotation));
        return super.getRepositoryMetadata(repoItf);
    }

    private String evaluateExpression(String spelExpression) {
        return (String)this.resolver.evaluate(spelExpression, this.beanExpressionContext);
    }

    private IgniteCacheProxy<?, ?> getRepositoryCache(Class<?> repoIf) {
        IgniteCacheProxy c;
        IgniteProxy ignite = this.repoToIgnite.get(repoIf);
        RepositoryConfig config = repoIf.getAnnotation(RepositoryConfig.class);
        String cacheName = this.repoToCache.get(repoIf);
        IgniteCacheProxy igniteCacheProxy = c = config.autoCreateCache() ? ignite.getOrCreateCache(cacheName) : ignite.cache(cacheName);
        if (c == null) {
            throw new IllegalStateException("Cache '" + cacheName + "' not found for repository interface " + repoIf.getName() + ". Please, add a cache configuration to ignite configuration or pass autoCreateCache=true to org.apache.ignite.springdata22.repository.config.RepositoryConfig annotation.");
        }
        return c;
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        IgniteProxy ignite = this.repoToIgnite.get(metadata.getRepositoryInterface());
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{ignite, this.getRepositoryCache(metadata.getRepositoryInterface())});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of((mtd, metadata, factory, namedQueries) -> {
            Query annotation = mtd.getAnnotation(Query.class);
            if (annotation != null && (StringUtils.hasText((String)annotation.value()) || annotation.textQuery() || annotation.dynamicQuery())) {
                IgniteQuery query;
                boolean annotatedIgniteQuery;
                String qryStr = annotation.value();
                boolean bl = annotatedIgniteQuery = !annotation.dynamicQuery() && (StringUtils.hasText((String)qryStr) || annotation.textQuery());
                IgniteQuery igniteQuery = annotatedIgniteQuery ? new IgniteQuery(qryStr, !annotation.textQuery() && (IgniteRepositoryFactory.isFieldQuery(qryStr) || annotation.forceFieldsQuery()), annotation.textQuery(), false, IgniteQueryGenerator.getOptions(mtd)) : (query = null);
                if (key != QueryLookupStrategy.Key.CREATE) {
                    return new IgniteRepositoryQuery(metadata, query, mtd, factory, this.getRepositoryCache(metadata.getRepositoryInterface()), annotatedIgniteQuery ? DynamicQueryConfig.fromQueryAnnotation(annotation) : null, evaluationContextProvider);
                }
            }
            if (key == QueryLookupStrategy.Key.USE_DECLARED_QUERY) {
                throw new IllegalStateException("To use QueryLookupStrategy.Key.USE_DECLARED_QUERY, pass a query string via org.apache.ignite.springdata22.repository.config.Query annotation.");
            }
            return new IgniteRepositoryQuery(metadata, IgniteQueryGenerator.generateSql(mtd, metadata), mtd, factory, this.getRepositoryCache(metadata.getRepositoryInterface()), DynamicQueryConfig.fromQueryAnnotation(annotation), evaluationContextProvider);
        });
    }

    public static boolean isFieldQuery(String qry) {
        String qryUpperCase = qry.toUpperCase();
        return IgniteRepositoryFactory.isStatement(qryUpperCase) && !qryUpperCase.matches("^SELECT\\s+(?:\\w+\\.)?+\\*.*");
    }

    private static boolean isStatement(String qryUpperCase) {
        return qryUpperCase.matches("^\\s*SELECT\\b.*") || qryUpperCase.matches("^\\s*UPDATE\\b.*") || qryUpperCase.matches("^\\s*DELETE\\b.*") || qryUpperCase.matches("^\\s*MERGE\\b.*") || qryUpperCase.matches("^\\s*INSERT\\b.*");
    }
}

