/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata22.repository.query;

import java.lang.reflect.Method;
import org.apache.ignite.springdata22.repository.query.IgniteQuery;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class IgniteQueryGenerator {
    private IgniteQueryGenerator() {
    }

    @NotNull
    public static IgniteQuery generateSql(Method mtd, RepositoryMetadata metadata) {
        PartTree parts;
        try {
            parts = new PartTree(mtd.getName(), metadata.getDomainType());
        }
        catch (Exception e) {
            parts = new PartTree(mtd.getName(), metadata.getIdType());
        }
        boolean isCountOrFieldQuery = parts.isCountProjection();
        StringBuilder sql = new StringBuilder();
        if (parts.isDelete()) {
            sql.append("DELETE ");
            isCountOrFieldQuery = true;
        } else {
            sql.append("SELECT ");
            if (parts.isDistinct()) {
                throw new UnsupportedOperationException("DISTINCT clause in not supported.");
            }
            if (isCountOrFieldQuery) {
                sql.append("COUNT(1) ");
            } else {
                sql.append("* ");
            }
        }
        sql.append("FROM ").append(metadata.getDomainType().getSimpleName());
        if (parts.iterator().hasNext()) {
            sql.append(" WHERE ");
            for (PartTree.OrPart orPart : parts) {
                sql.append("(");
                for (Part part : orPart) {
                    IgniteQueryGenerator.handleQueryPart(sql, part, metadata.getDomainType());
                    sql.append(" AND ");
                }
                sql.delete(sql.length() - 5, sql.length());
                sql.append(") OR ");
            }
            sql.delete(sql.length() - 4, sql.length());
        }
        IgniteQueryGenerator.addSorting(sql, parts.getSort());
        if (parts.isLimiting()) {
            sql.append(" LIMIT ");
            sql.append(parts.getMaxResults());
        }
        return new IgniteQuery(sql.toString(), isCountOrFieldQuery, false, true, IgniteQueryGenerator.getOptions(mtd));
    }

    public static StringBuilder addSorting(StringBuilder sql, Sort sort) {
        if (sort != null && sort != Sort.unsorted()) {
            sql.append(" ORDER BY ");
            for (Sort.Order order : sort) {
                sql.append(order.getProperty()).append(" ").append(order.getDirection());
                if (order.getNullHandling() != Sort.NullHandling.NATIVE) {
                    sql.append(" ").append("NULL ");
                    switch (order.getNullHandling()) {
                        case NULLS_FIRST: {
                            sql.append("FIRST");
                            break;
                        }
                        case NULLS_LAST: {
                            sql.append("LAST");
                            break;
                        }
                    }
                }
                sql.append(", ");
            }
            sql.delete(sql.length() - 2, sql.length());
        }
        return sql;
    }

    public static StringBuilder addPaging(StringBuilder sql, Pageable pageable) {
        IgniteQueryGenerator.addSorting(sql, pageable.getSort());
        sql.append(" LIMIT ").append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
        return sql;
    }

    public static IgniteQuery.Option getOptions(Method mtd) {
        IgniteQuery.Option option = IgniteQuery.Option.NONE;
        Class<?>[] types = mtd.getParameterTypes();
        if (types.length > 0) {
            Class<?> type = types[types.length - 1];
            if (Sort.class.isAssignableFrom(type)) {
                option = IgniteQuery.Option.SORTING;
            } else if (Pageable.class.isAssignableFrom(type)) {
                option = IgniteQuery.Option.PAGINATION;
            }
        }
        for (int i = 0; i < types.length - 1; ++i) {
            Class<?> tp = types[i];
            if (tp == Sort.class || tp == Pageable.class) {
                throw new AssertionError((Object)"Sort and Pageable parameters are allowed only in the last position");
            }
        }
        return option;
    }

    private static String getColumnName(Part part, Class<?> domainType) {
        PropertyPath prperty = part.getProperty();
        if (prperty.getType() != domainType) {
            return domainType.getSimpleName() + "." + prperty.getSegment();
        }
        return part.toString();
    }

    private static void handleQueryPart(StringBuilder sql, Part part, Class<?> domainType) {
        sql.append("(");
        sql.append(IgniteQueryGenerator.getColumnName(part, domainType));
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                sql.append("=?");
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                sql.append("<>?");
                break;
            }
            case GREATER_THAN: {
                sql.append(">?");
                break;
            }
            case GREATER_THAN_EQUAL: {
                sql.append(">=?");
                break;
            }
            case LESS_THAN: {
                sql.append("<?");
                break;
            }
            case LESS_THAN_EQUAL: {
                sql.append("<=?");
                break;
            }
            case IS_NOT_NULL: {
                sql.append(" IS NOT NULL");
                break;
            }
            case IS_NULL: {
                sql.append(" IS NULL");
                break;
            }
            case BETWEEN: {
                sql.append(" BETWEEN ? AND ?");
                break;
            }
            case FALSE: {
                sql.append(" = FALSE");
                break;
            }
            case TRUE: {
                sql.append(" = TRUE");
                break;
            }
            case LIKE: 
            case CONTAINING: {
                sql.append(" LIKE '%' || ? || '%'");
                break;
            }
            case NOT_CONTAINING: 
            case NOT_LIKE: {
                sql.append(" NOT LIKE '%' || ? || '%'");
                break;
            }
            case STARTING_WITH: {
                sql.append(" LIKE  ? || '%'");
                break;
            }
            case ENDING_WITH: {
                sql.append(" LIKE '%' || ?");
                break;
            }
            case IN: {
                sql.append(" IN ?");
                break;
            }
            case NOT_IN: {
                sql.append(" NOT IN ?");
                break;
            }
            case REGEX: {
                sql.append(" REGEXP ?");
                break;
            }
            default: {
                throw new UnsupportedOperationException(part.getType() + " is not supported!");
            }
        }
        sql.append(")");
    }
}

