/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata22.repository.query;

import java.util.regex.Pattern;
import org.apache.ignite.springdata22.repository.query.DeclaredQuery;
import org.apache.ignite.springdata22.repository.query.StringQuery;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class ExpressionBasedStringQuery
extends StringQuery {
    private static final String EXPRESSION_PARAMETER = "?#{";
    private static final String QUOTED_EXPRESSION_PARAMETER = "?__HASH__{";
    private static final Pattern EXPRESSION_PARAMETER_QUOTING = Pattern.compile(Pattern.quote("?#{"));
    private static final Pattern EXPRESSION_PARAMETER_UNQUOTING = Pattern.compile(Pattern.quote("?__HASH__{"));
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_NAME_VARIABLE = "#entityName";
    private static final String ENTITY_NAME_VARIABLE_EXPRESSION = "#{#entityName}";

    public ExpressionBasedStringQuery(String qry, RepositoryMetadata metadata, SpelExpressionParser parser) {
        super(ExpressionBasedStringQuery.renderQueryIfExpressionOrReturnQuery(qry, metadata, parser));
    }

    static ExpressionBasedStringQuery from(DeclaredQuery qry, RepositoryMetadata metadata, SpelExpressionParser parser) {
        return new ExpressionBasedStringQuery(qry.getQueryString(), metadata, parser);
    }

    private static String renderQueryIfExpressionOrReturnQuery(String qry, RepositoryMetadata metadata, SpelExpressionParser parser) {
        Assert.notNull((Object)qry, (String)"query must not be null!");
        Assert.notNull((Object)metadata, (String)"metadata must not be null!");
        Assert.notNull((Object)parser, (String)"parser must not be null!");
        if (!ExpressionBasedStringQuery.containsExpression(qry)) {
            return qry;
        }
        StandardEvaluationContext evalCtx = new StandardEvaluationContext();
        evalCtx.setVariable(ENTITY_NAME, (Object)metadata.getDomainType().getSimpleName());
        qry = ExpressionBasedStringQuery.potentiallyQuoteExpressionsParameter(qry);
        Expression expr = parser.parseExpression(qry, ParserContext.TEMPLATE_EXPRESSION);
        String result = (String)expr.getValue((EvaluationContext)evalCtx, String.class);
        if (result == null) {
            return qry;
        }
        return ExpressionBasedStringQuery.potentiallyUnquoteParameterExpressions(result);
    }

    private static String potentiallyUnquoteParameterExpressions(String result) {
        return EXPRESSION_PARAMETER_UNQUOTING.matcher(result).replaceAll(EXPRESSION_PARAMETER);
    }

    private static String potentiallyQuoteExpressionsParameter(String qry) {
        return EXPRESSION_PARAMETER_QUOTING.matcher(qry).replaceAll(QUOTED_EXPRESSION_PARAMETER);
    }

    private static boolean containsExpression(String qry) {
        return qry.contains(ENTITY_NAME_VARIABLE_EXPRESSION);
    }
}

