/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.hibernate;

import java.util.Properties;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.hibernate.CacheHibernateBlobStore;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.SpringApplicationContextResource;
import org.hibernate.SessionFactory;

public class CacheHibernateBlobStoreFactory<K, V>
implements Factory<CacheHibernateBlobStore<K, V>> {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private transient SessionFactory sesFactory;
    private String sesFactoryBean;
    private String hibernateCfgPath;
    @GridToStringExclude
    private Properties hibernateProps;
    @SpringApplicationContextResource
    private Object appContext;

    public CacheHibernateBlobStore<K, V> create() {
        CacheHibernateBlobStore store = new CacheHibernateBlobStore();
        store.setHibernateConfigurationPath(this.hibernateCfgPath);
        store.setHibernateProperties(this.hibernateProps);
        if (this.sesFactory != null) {
            store.setSessionFactory(this.sesFactory);
        } else if (this.sesFactoryBean != null) {
            if (this.appContext == null) {
                throw new IgniteException("Spring application context resource is not injected.");
            }
            try {
                IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
                SessionFactory sesFac = (SessionFactory)spring.loadBeanFromAppContext(this.appContext, this.sesFactoryBean);
                store.setSessionFactory(sesFac);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to load bean in application context [beanName=" + this.sesFactoryBean + ", igniteConfig=" + this.appContext + ']');
            }
        }
        return store;
    }

    public CacheHibernateBlobStoreFactory<K, V> setSessionFactory(SessionFactory sesFactory) {
        this.sesFactory = sesFactory;
        return this;
    }

    public CacheHibernateBlobStoreFactory<K, V> setSessionFactoryBean(String sesFactory) {
        this.sesFactoryBean = sesFactory;
        return this;
    }

    public CacheHibernateBlobStoreFactory<K, V> setHibernateConfigurationPath(String hibernateCfgPath) {
        this.hibernateCfgPath = hibernateCfgPath;
        return this;
    }

    public CacheHibernateBlobStoreFactory<K, V> setHibernateProperties(Properties hibernateProps) {
        this.hibernateProps = hibernateProps;
        return this;
    }

    public String toString() {
        return S.toString(CacheHibernateBlobStoreFactory.class, (Object)this);
    }
}

