/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateRegion;
import org.apache.ignite.cache.hibernate.HibernateRegionFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.AccessType;

public class HibernateTransactionalDataRegion
extends HibernateRegion
implements TransactionalDataRegion {
    private final CacheDataDescription dataDesc;

    HibernateTransactionalDataRegion(HibernateRegionFactory factory, String name, Ignite ignite, HibernateCacheProxy cache, CacheDataDescription dataDesc) {
        super(factory, name, ignite, cache);
        this.dataDesc = dataDesc;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.dataDesc;
    }

    HibernateAccessStrategyAdapter createAccessStrategy(AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                return this.factory.accessStrategyFactory().createReadOnlyStrategy(this.cache);
            }
            case NONSTRICT_READ_WRITE: {
                return this.factory.accessStrategyFactory().createNonStrictReadWriteStrategy(this.cache);
            }
            case READ_WRITE: {
                return this.factory.accessStrategyFactory().createReadWriteStrategy(this.cache);
            }
            case TRANSACTIONAL: {
                return this.factory.accessStrategyFactory().createTransactionalStrategy(this.cache);
            }
        }
        throw new IllegalArgumentException("Unknown Hibernate access type: " + accessType);
    }
}

