/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.hibernate.HibernateAbstractRegionAccessStrategy;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateRegionFactory;
import org.apache.ignite.cache.hibernate.HibernateTransactionalDataRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class HibernateNaturalIdRegion
extends HibernateTransactionalDataRegion
implements NaturalIdRegion {
    public HibernateNaturalIdRegion(HibernateRegionFactory factory, String name, Ignite ignite, HibernateCacheProxy cache, CacheDataDescription dataDesc) {
        super(factory, name, ignite, cache, dataDesc);
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        return new AccessStrategy(this.createAccessStrategy(accessType));
    }

    private class AccessStrategy
    extends HibernateAbstractRegionAccessStrategy
    implements NaturalIdRegionAccessStrategy {
        private AccessStrategy(HibernateAccessStrategyAdapter stgy) {
            super(stgy);
        }

        public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor ses) {
            return DefaultCacheKeysFactory.staticCreateNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)ses);
        }

        public Object[] getNaturalIdValues(Object cacheKey) {
            return DefaultCacheKeysFactory.staticGetNaturalIdValues((Object)cacheKey);
        }

        public NaturalIdRegion getRegion() {
            return HibernateNaturalIdRegion.this;
        }

        public boolean insert(SessionImplementor ses, Object key, Object val) throws CacheException {
            return this.stgy.insert(key, val);
        }

        public boolean afterInsert(SessionImplementor ses, Object key, Object val) throws CacheException {
            return this.stgy.afterInsert(key, val);
        }

        public boolean update(SessionImplementor ses, Object key, Object val) throws CacheException {
            return this.stgy.update(key, val);
        }

        public boolean afterUpdate(SessionImplementor ses, Object key, Object val, SoftLock lock) throws CacheException {
            return this.stgy.afterUpdate(key, val);
        }
    }
}

