/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryServerOnlyCustomMessage;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanTags;
import org.apache.ignite.internal.processors.tracing.messages.SpanContainer;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessage;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessagesTable;
import org.apache.ignite.internal.util.GridBoundedLinkedHashSet;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutHelper;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoveryNotification;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.IgniteDiscoveryThread;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoveryImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.DiscoveryDataPacket;
import org.apache.ignite.spi.discovery.tcp.internal.FutureTask;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNodesRing;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoverySpiState;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAuthFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCheckFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientAckResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientMetricsUpdateMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientPingRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientPingResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientReconnectMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryConnectionCheckMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCustomEventMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDiscardMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDummyWakeupMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDuplicateIdMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryHandshakeRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryHandshakeResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryJoinRequestMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryLoopbackProblemMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryMetricsUpdateMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddFinishedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeLeftMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryPingRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryPingResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRedirectToClient;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRequiredFeatureSupport;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRingLatencyCheckMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryServerOnlyCustomEventMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryStatusCheckMessage;
import org.apache.ignite.spi.tracing.SpanStatus;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServerImpl
extends TcpDiscoveryImpl {
    private static final int ENSURED_MSG_HIST_SIZE = IgniteSystemProperties.getInteger("IGNITE_DISCOVERY_CLIENT_RECONNECT_HISTORY_SIZE", 512);
    private static final TcpDiscoveryAbstractMessage WAKEUP = new TcpDiscoveryDummyWakeupMessage();
    private static final int CON_CHECK_INTERVAL = 500;
    private IgniteThreadPoolExecutor utilityPool;
    @GridToStringExclude
    private final TcpDiscoveryNodesRing ring = new TcpDiscoveryNodesRing();
    private final SortedMap<Long, Collection<ClusterNode>> topHist = new TreeMap<Long, Collection<ClusterNode>>();
    private final Collection<SocketReader> readers = new LinkedList<SocketReader>();
    private TcpServer tcpSrvr;
    private RingMessageWorker msgWorker;
    private Thread msgWorkerThread;
    private final ConcurrentMap<UUID, ClientMessageWorker> clientMsgWorkers = new ConcurrentHashMap<UUID, ClientMessageWorker>();
    private IpFinderCleaner ipFinderCleaner;
    private StatisticsPrinter statsPrinter;
    private final Map<TcpDiscoveryNode, UUID> failedNodes = new HashMap<TcpDiscoveryNode, UUID>();
    private final Collection<UUID> failedNodesMsgSent = new HashSet<UUID>();
    private final Collection<TcpDiscoveryNode> leavingNodes = new HashSet<TcpDiscoveryNode>();
    private Set<UUID> joiningNodes = new HashSet<UUID>();
    private Queue<TcpDiscoveryCustomEventMessage> pendingCustomMsgs = new ArrayDeque<TcpDiscoveryCustomEventMessage>();
    private final EnsuredMessageHistory msgHist = new EnsuredMessageHistory();
    private boolean ipFinderHasLocAddr;
    private final Collection<SocketAddress> noResAddrs = new GridConcurrentHashSet<SocketAddress>();
    private final Collection<SocketAddress> fromAddrs = new GridConcurrentHashSet<SocketAddress>();
    private final GridTuple<TcpDiscoveryAbstractMessage> joinRes = new GridTuple();
    private final Object mux = new Object();
    private TcpDiscoverySpiState spiState = TcpDiscoverySpiState.DISCONNECTED;
    private volatile long lastRingMsgReceivedTime;
    private volatile boolean nodeCompactRepresentationSupported = true;
    private final ConcurrentMap<InetSocketAddress, GridPingFutureAdapter<IgniteBiTuple<UUID, Boolean>>> pingMap = new ConcurrentHashMap<InetSocketAddress, GridPingFutureAdapter<IgniteBiTuple<UUID, Boolean>>>();
    private static final int JOINED_NODE_IDS_HISTORY_SIZE = IgniteSystemProperties.getInteger("IGNITE_NODE_IDS_HISTORY_SIZE", 50);
    private final GridBoundedLinkedHashSet<UUID> nodesIdsHist = new GridBoundedLinkedHashSet(JOINED_NODE_IDS_HISTORY_SIZE);

    ServerImpl(TcpDiscoverySpi adapter) {
        super(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSpiState() {
        Object object = this.mux;
        synchronized (object) {
            return this.spiState.name();
        }
    }

    @Override
    public int getMessageWorkerQueueSize() {
        return this.msgWorker.queueSize();
    }

    @Override
    @Nullable
    public UUID getCoordinator() {
        TcpDiscoveryNode crd = this.resolveCoordinator();
        return crd != null ? crd.id() : null;
    }

    @Override
    @Nullable
    public ClusterNode getNode(UUID nodeId) {
        assert (nodeId != null);
        UUID locNodeId0 = this.getLocalNodeId();
        if (locNodeId0 != null && locNodeId0.equals(nodeId)) {
            return this.locNode;
        }
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node != null && !node.visible()) {
            return null;
        }
        return node;
    }

    @Override
    public Collection<ClusterNode> getRemoteNodes() {
        return ServerImpl.upcast(this.ring.visibleRemoteNodes());
    }

    private GridKernalContext gridKernalContext() {
        return this.spi.ignite() instanceof IgniteEx ? ((IgniteEx)this.spi.ignite()).context() : null;
    }

    @Override
    public boolean allNodesSupport(IgniteFeatures feature, IgnitePredicate<ClusterNode> nodesPred) {
        return IgniteFeatures.allNodesSupports(this.gridKernalContext(), F.view(ServerImpl.upcast(this.ring.allNodes()), nodesPred), feature);
    }

    @Override
    public int boundPort() throws IgniteSpiException {
        if (this.tcpSrvr == null) {
            this.tcpSrvr = new TcpServer(this.log);
        }
        return this.tcpSrvr.port;
    }

    @Override
    public long connectionCheckInterval() {
        return 500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        Object object = this.mux;
        synchronized (object) {
            this.spiState = TcpDiscoverySpiState.DISCONNECTED;
        }
        this.lastRingMsgReceivedTime = 0L;
        this.utilityPool = new IgniteThreadPoolExecutor("disco-pool", this.spi.ignite().name(), 0, 1, 2000L, new LinkedBlockingQueue<Runnable>());
        if (this.debugMode) {
            if (!this.log.isInfoEnabled()) {
                throw new IgniteSpiException("Info log level should be enabled for TCP discovery to work in debug mode.");
            }
            this.debugLogQ = new ConcurrentLinkedDeque();
            U.quietAndWarn(this.log, "TCP discovery SPI is configured in debug mode.");
        }
        this.fromAddrs.clear();
        this.noResAddrs.clear();
        this.msgWorker = new RingMessageWorker(this.log);
        this.msgWorkerThread = new MessageWorkerDiscoveryThread(this.msgWorker, this.log);
        this.msgWorkerThread.start();
        if (this.tcpSrvr == null) {
            this.tcpSrvr = new TcpServer(this.log);
        }
        this.spi.initLocalNode(this.tcpSrvr.port, true);
        this.locNode = this.spi.locNode;
        new TcpServerThread(this.tcpSrvr, this.log).start();
        this.ring.localNode(this.locNode);
        if (this.spi.ipFinder.isShared()) {
            this.registerLocalNodeAddress();
        } else {
            if (F.isEmpty(this.spi.ipFinder.getRegisteredAddresses())) {
                throw new IgniteSpiException("Non-shared IP finder must have IP addresses specified in TcpDiscoveryIpFinder.getRegisteredAddresses() configuration property (specify list of IP addresses in configuration).");
            }
            this.ipFinderHasLocAddr = this.spi.ipFinderHasLocalAddress();
        }
        if (this.spi.getStatisticsPrintFrequency() > 0L && this.log.isInfoEnabled()) {
            this.statsPrinter = new StatisticsPrinter();
            this.statsPrinter.start();
        }
        this.joinTopology();
        if (this.locNode.order() == 1L) {
            U.enhanceThreadName(this.msgWorkerThread, "crd");
        }
        if (this.spi.ipFinder.isShared()) {
            this.ipFinderCleaner = new IpFinderCleaner();
            this.ipFinderCleaner.start();
        }
        this.spi.printStartInfo();
    }

    @Override
    public void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        spiCtx.registerPort(this.tcpSrvr.port, IgnitePortProtocol.TCP);
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.spiStop0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spiStop0(boolean disconnect) throws IgniteSpiException {
        DiscoverySpiListener lsnr;
        List tmp;
        Object rootSpan;
        if (this.log.isDebugEnabled()) {
            if (disconnect) {
                this.log.debug("Disconnecting SPI.");
            } else {
                this.log.debug("Preparing to start local node stop procedure.");
            }
        }
        if (disconnect) {
            Object object = this.mux;
            synchronized (object) {
                this.spiState = TcpDiscoverySpiState.DISCONNECTING;
            }
        }
        if (this.msgWorker != null && this.msgWorker.runner() != null && this.msgWorker.runner().isAlive() && !disconnect) {
            TcpDiscoveryNodeLeftMessage nodeLeftMsg = new TcpDiscoveryNodeLeftMessage(this.locNode.id());
            rootSpan = this.tracing.create(TraceableMessagesTable.traceName(nodeLeftMsg.getClass())).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> this.locNode.id().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> this.locNode.consistentId().toString()).addLog(() -> "Created");
            nodeLeftMsg.spanContainer().serializedSpanBytes(this.tracing.serialize((Span)rootSpan));
            this.msgWorker.addMessage(nodeLeftMsg);
            rootSpan.addLog(() -> "Sent").end();
            Object object = this.mux;
            synchronized (object) {
                long timeout = this.spi.netTimeout;
                long thresholdNanos = System.nanoTime() + U.millisToNanos(timeout);
                while (this.spiState != TcpDiscoverySpiState.LEFT && timeout > 0L) {
                    try {
                        this.mux.wait(timeout);
                        timeout = U.nanosToMillis(thresholdNanos - System.nanoTime());
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (this.spiState == TcpDiscoverySpiState.LEFT) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Verification for local node leave has been received from coordinator (continuing stop procedure).");
                    }
                } else if (this.log.isInfoEnabled()) {
                    this.log.info("No verification for local node leave has been received from coordinator (will stop node anyway).");
                }
            }
        }
        if (this.tcpSrvr != null) {
            this.tcpSrvr.stop();
        }
        this.tcpSrvr = null;
        rootSpan = this.mux;
        synchronized (rootSpan) {
            tmp = U.arrayList(this.readers);
        }
        U.interrupt(tmp);
        U.joinThreads(tmp, this.log);
        U.interrupt(this.ipFinderCleaner);
        U.join(this.ipFinderCleaner, this.log);
        U.cancel(this.msgWorker);
        U.join(this.msgWorker, this.log);
        for (ClientMessageWorker clientWorker : this.clientMsgWorkers.values()) {
            if (clientWorker == null) continue;
            U.interrupt(clientWorker.runner());
            U.join(clientWorker.runner(), this.log);
        }
        this.clientMsgWorkers.clear();
        IgniteUtils.shutdownNow(ServerImpl.class, this.utilityPool, this.log);
        U.interrupt(this.statsPrinter);
        U.join(this.statsPrinter, this.log);
        Collection<TcpDiscoveryNode> nodes = null;
        if (!disconnect) {
            this.spi.printStopInfo();
        } else {
            this.spi.getSpiContext().deregisterPorts();
            nodes = this.ring.visibleNodes();
        }
        long topVer = this.ring.topologyVersion();
        this.ring.clear();
        if (nodes != null && (lsnr = this.spi.lsnr) != null) {
            HashSet<TcpDiscoveryNode> processed = new HashSet<TcpDiscoveryNode>(nodes.size());
            for (TcpDiscoveryNode n : nodes) {
                if (n.isLocal()) continue;
                assert (n.visible());
                processed.add(n);
                List<ClusterNode> top = U.arrayList(nodes, F.notIn(processed));
                Map<Long, Collection<ClusterNode>> hist = this.updateTopologyHistory(++topVer, Collections.unmodifiableList(top));
                lsnr.onDiscovery(new DiscoveryNotification(12, topVer, n, top, hist, null, null)).get();
            }
        }
        this.printStatistics();
        this.spi.stats.clear();
        Object object = this.mux;
        synchronized (object) {
            this.leavingNodes.clear();
            this.failedNodes.clear();
            this.spiState = TcpDiscoverySpiState.DISCONNECTED;
        }
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        assert (nodeId != null);
        if (nodeId == this.getLocalNodeId()) {
            return true;
        }
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node == null) {
            return false;
        }
        if (!this.nodeAlive(nodeId)) {
            return false;
        }
        long start = U.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info("Pinging node: " + nodeId);
        }
        boolean res = this.pingNode(node);
        long end = System.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished node ping [nodeId=" + nodeId + ", res=" + res + ", time=" + (end - start) + "ms]");
        }
        if (!res && node.clientRouterNodeId() == null && this.nodeAlive(nodeId)) {
            LT.warn(this.log, "Failed to ping node (status check will be initiated): " + nodeId);
            this.msgWorker.addMessage(this.createTcpDiscoveryStatusCheckMessage(this.locNode, this.locNode.id(), node.id()));
        }
        return res;
    }

    @Nullable
    private TcpDiscoveryStatusCheckMessage createTcpDiscoveryStatusCheckMessage(@Nullable TcpDiscoveryNode creatorNode, UUID creatorNodeId, UUID failedNodeId) {
        TcpDiscoveryStatusCheckMessage msg;
        if (this.nodeCompactRepresentationSupported) {
            TcpDiscoveryNode crd = this.resolveCoordinator();
            if (creatorNode == null) {
                msg = new TcpDiscoveryStatusCheckMessage(creatorNodeId, null, failedNodeId);
            } else {
                boolean sameMacs = creatorNode != null && crd != null && U.sameMacs(creatorNode, crd);
                msg = new TcpDiscoveryStatusCheckMessage(creatorNode.id(), this.spi.getNodeAddresses(creatorNode, sameMacs), failedNodeId);
            }
        } else if (creatorNode == null) {
            TcpDiscoveryNode node = this.ring.node(creatorNodeId);
            if (node == null) {
                return null;
            }
            msg = new TcpDiscoveryStatusCheckMessage(node, failedNodeId);
        } else {
            msg = new TcpDiscoveryStatusCheckMessage(creatorNode, failedNodeId);
        }
        return msg;
    }

    private TcpDiscoveryDuplicateIdMessage createTcpDiscoveryDuplicateIdMessage(UUID creatorNodeId, TcpDiscoveryNode node) {
        TcpDiscoveryDuplicateIdMessage msg = this.nodeCompactRepresentationSupported ? new TcpDiscoveryDuplicateIdMessage(creatorNodeId, node.id()) : new TcpDiscoveryDuplicateIdMessage(creatorNodeId, node);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clientWorkersCount() {
        Object object = this.mux;
        synchronized (object) {
            return this.clientMsgWorkers.size();
        }
    }

    private boolean pingNode(TcpDiscoveryNode node) {
        assert (node != null);
        if (node.id().equals(this.getLocalNodeId())) {
            return true;
        }
        UUID clientNodeId = null;
        if (node.clientRouterNodeId() != null) {
            clientNodeId = node.id();
            if ((node = this.ring.node(node.clientRouterNodeId())) == null || !this.nodeAlive(node.id())) {
                return false;
            }
        }
        for (InetSocketAddress addr : this.spi.getNodeAddresses(node, U.sameMacs(this.locNode, node))) {
            try {
                boolean res;
                IgniteBiTuple<UUID, Boolean> t = this.pingNode(addr, node.id(), clientNodeId);
                if (t == null) {
                    return false;
                }
                boolean bl = res = node.id().equals(t.get1()) && (clientNodeId == null || t.get2() != false);
                if (res) {
                    node.lastSuccessfulAddress(addr);
                }
                return res;
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to ping node [node=" + node + ", err=" + e.getMessage() + ']');
                }
                this.onException("Failed to ping node [node=" + node + ", err=" + e.getMessage() + ']', e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private IgniteBiTuple<UUID, Boolean> pingNode(InetSocketAddress addr, @Nullable UUID nodeId, @Nullable UUID clientNodeId) throws IgniteCheckedException {
        assert (addr != null);
        UUID locNodeId = this.getLocalNodeId();
        IgniteSpiOperationTimeoutHelper timeoutHelper = new IgniteSpiOperationTimeoutHelper(this.spi, clientNodeId == null);
        if (F.contains(this.spi.locNodeAddrs, addr)) {
            boolean clientPingRes;
            if (clientNodeId == null) {
                return F.t(this.getLocalNodeId(), false);
            }
            ClientMessageWorker clientWorker = (ClientMessageWorker)this.clientMsgWorkers.get(clientNodeId);
            if (clientWorker == null) {
                return F.t(this.getLocalNodeId(), false);
            }
            try {
                clientPingRes = clientWorker.ping(timeoutHelper);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedCheckedException(e);
            }
            return F.t(this.getLocalNodeId(), clientPingRes);
        }
        InetSocketAddress addrKey = addr;
        GridPingFutureAdapter<IgniteBiTuple> fut = new GridPingFutureAdapter<IgniteBiTuple>(nodeId);
        GridPingFutureAdapter oldFut = this.pingMap.putIfAbsent(addrKey, fut);
        if (oldFut != null) {
            return (IgniteBiTuple)oldFut.get();
        }
        ArrayList<Throwable> errs = null;
        try {
            Socket sock = null;
            int reconCnt = 0;
            boolean openedSock = false;
            while (true) {
                IgniteBiTuple<UUID, Boolean> igniteBiTuple;
                TcpDiscoveryPingResponse res;
                block32: {
                    block33: {
                        if (addr.isUnresolved()) {
                            addr = new InetSocketAddress(InetAddress.getByName(addr.getHostName()), addr.getPort());
                        }
                        long tsNanos = System.nanoTime();
                        sock = this.spi.createSocket();
                        ((GridPingFutureAdapter)fut).sock = sock;
                        sock = this.spi.openSocket(sock, addr, timeoutHelper);
                        openedSock = true;
                        this.spi.writeToSocket(sock, new TcpDiscoveryPingRequest(locNodeId, clientNodeId), timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                        res = (TcpDiscoveryPingResponse)this.spi.readMessage(sock, null, timeoutHelper.nextTimeoutChunk(this.spi.getAckTimeout()));
                        if (!locNodeId.equals(res.creatorNodeId())) break block32;
                        if (!this.log.isDebugEnabled()) break block33;
                        this.log.debug("Ping response from local node: " + res);
                    }
                    U.closeQuiet(sock);
                    break;
                }
                try {
                    IgniteBiTuple<UUID, Boolean> t = F.t(res.creatorNodeId(), res.clientExists());
                    fut.onDone(t);
                    igniteBiTuple = t;
                }
                catch (IOException | IgniteCheckedException e) {
                    block35: {
                        if (nodeId == null || this.nodeAlive(nodeId)) break block35;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to ping the node (has left or leaving topology): [nodeId=" + nodeId + ']');
                        }
                        fut.onDone((IgniteBiTuple)null);
                        IgniteBiTuple<UUID, Boolean> igniteBiTuple2 = null;
                        U.closeQuiet(sock);
                        if (!fut.isDone()) {
                            fut.onDone(U.exceptionWithSuppressed("Failed to ping node by address: " + addr, errs));
                        }
                        boolean b = this.pingMap.remove(addrKey, fut);
                        assert (b);
                        return igniteBiTuple2;
                    }
                    try {
                        block39: {
                            block40: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if (errs == null) {
                                                errs = new ArrayList<Throwable>();
                                            }
                                            errs.add(e);
                                            if (openedSock || ++reconCnt != 2) break block36;
                                            {
                                                catch (Throwable throwable) {
                                                    U.closeQuiet(sock);
                                                    throw throwable;
                                                }
                                            }
                                            U.closeQuiet(sock);
                                            break;
                                        }
                                        if (!timeoutHelper.checkFailureTimeoutReached(e)) break block37;
                                        U.closeQuiet(sock);
                                        break;
                                    }
                                    if (this.spi.failureDetectionTimeoutEnabled() || reconCnt != this.spi.getReconnectCount()) break block38;
                                    U.closeQuiet(sock);
                                    break;
                                }
                                if (!this.spi.isNodeStopping0()) break block39;
                                if (!this.log.isDebugEnabled()) break block40;
                                this.log.debug("Stop pinging node, because node is stopping: [rmtNodeId=" + nodeId + ']');
                            }
                            U.closeQuiet(sock);
                            break;
                        }
                        U.closeQuiet(sock);
                        U.sleep(200L);
                        continue;
                    }
                    catch (Throwable t) {
                        fut.onDone(t);
                        if (t instanceof Error) {
                            throw t;
                        }
                        throw U.cast(t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                U.closeQuiet(sock);
                return igniteBiTuple;
                break;
            }
        }
        finally {
            if (!fut.isDone()) {
                fut.onDone(U.exceptionWithSuppressed("Failed to ping node by address: " + addr, errs));
            }
            boolean b = this.pingMap.remove(addrKey, fut);
            assert (b);
        }
        return (IgniteBiTuple)fut.get();
    }

    private void interruptPing(TcpDiscoveryNode node) {
        for (InetSocketAddress addr : this.spi.getNodeAddresses(node)) {
            GridPingFutureAdapter fut = (GridPingFutureAdapter)this.pingMap.get(addr);
            if (fut == null || fut.sock == null || fut.nodeId != null && !fut.nodeId.equals(node.id())) continue;
            U.closeQuiet(fut.sock);
        }
    }

    @Override
    public void disconnect() throws IgniteSpiException {
        this.spiStop0(true);
    }

    @Override
    public void sendCustomEvent(DiscoverySpiCustomMessage evt) {
        try {
            TcpDiscoveryCustomEventMessage msg = ((CustomMessageWrapper)evt).delegate() instanceof DiscoveryServerOnlyCustomMessage ? new TcpDiscoveryServerOnlyCustomEventMessage(this.getLocalNodeId(), evt, U.marshal(this.spi.marshaller(), (Object)evt)) : new TcpDiscoveryCustomEventMessage(this.getLocalNodeId(), evt, U.marshal(this.spi.marshaller(), (Object)evt));
            Span rootSpan = this.tracing.create(TraceableMessagesTable.traceName(msg.getClass())).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> this.getLocalNodeId().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> this.locNode.consistentId().toString()).addTag("message.class", () -> ((CustomMessageWrapper)evt).delegate().getClass().getSimpleName()).addLog(() -> "Created");
            msg.spanContainer().serializedSpanBytes(this.tracing.serialize(rootSpan));
            this.msgWorker.addMessage(msg);
            rootSpan.addLog(() -> "Sent").end();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal custom event: " + evt, e);
        }
    }

    @Override
    public void failNode(UUID nodeId, @Nullable String warning) {
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node != null) {
            TcpDiscoveryNodeFailedMessage msg = new TcpDiscoveryNodeFailedMessage(this.getLocalNodeId(), node.id(), node.internalOrder());
            msg.warning(warning);
            msg.force(true);
            this.msgWorker.addMessage(msg);
        }
    }

    @Override
    protected void onMessageExchanged() {
        if (this.spi.failureDetectionTimeoutEnabled() && this.locNode != null) {
            this.locNode.lastExchangeTime(U.currentTimeMillis(), System.nanoTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeAlive(UUID nodeId) {
        boolean nodeAlive;
        TcpDiscoveryNode node = this.ring.node(nodeId);
        boolean bl = nodeAlive = node != null && node.visible();
        if (nodeAlive) {
            Object object = this.mux;
            synchronized (object) {
                nodeAlive = !F.transform(this.failedNodes.keySet(), F.node2id()).contains(nodeId) && !F.transform(this.leavingNodes, F.node2id()).contains(nodeId);
            }
        }
        return nodeAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinTopology() throws IgniteSpiException {
        Object object = this.mux;
        synchronized (object) {
            assert (this.spiState == TcpDiscoverySpiState.CONNECTING || this.spiState == TcpDiscoverySpiState.DISCONNECTED);
            this.spiState = TcpDiscoverySpiState.CONNECTING;
        }
        SecurityCredentials locCred = (SecurityCredentials)this.locNode.getAttributes().get("org.apache.ignite.security.cred");
        boolean auth = false;
        if (this.spi.nodeAuth != null && this.spi.nodeAuth.isGlobalNodeAuthentication()) {
            this.localAuthentication(locCred);
            auth = true;
        }
        this.marshalCredentials(this.locNode, locCred);
        DiscoveryDataPacket discoveryData = this.spi.collectExchangeData(new DiscoveryDataPacket(this.getLocalNodeId()));
        final TcpDiscoveryJoinRequestMessage joinReqMsg = new TcpDiscoveryJoinRequestMessage(this.locNode, discoveryData);
        joinReqMsg.spanContainer().span(this.tracing.create(TraceableMessagesTable.traceName(joinReqMsg.getClass())).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> this.locNode.id().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> this.locNode.consistentId().toString()).addLog(() -> "Created"));
        this.tracing.messages().beforeSend(joinReqMsg);
        while (true) {
            if (!this.sendJoinRequestMessage(joinReqMsg)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Join request message has not been sent (local node is the first in the topology).");
                }
                if (!auth && this.spi.nodeAuth != null) {
                    this.localAuthentication(locCred);
                }
                FutureTask<Void> fut = this.msgWorker.addTask(new FutureTask<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Void body() {
                        ServerImpl.this.pendingCustomMsgs.clear();
                        ServerImpl.this.msgWorker.pendingMsgs.reset(null, null, null);
                        ServerImpl.this.msgWorker.next = null;
                        ServerImpl.this.failedNodes.clear();
                        ServerImpl.this.leavingNodes.clear();
                        ServerImpl.this.failedNodesMsgSent.clear();
                        ServerImpl.this.locNode.attributes().remove("org.apache.ignite.security.cred");
                        ServerImpl.this.locNode.order(1L);
                        ServerImpl.this.locNode.internalOrder(1L);
                        ServerImpl.this.spi.gridStartTime = U.currentTimeMillis();
                        ServerImpl.this.locNode.visible(true);
                        ServerImpl.this.ring.clear();
                        ServerImpl.this.ring.topologyVersion(1L);
                        Object object = ServerImpl.this.mux;
                        synchronized (object) {
                            ServerImpl.this.topHist.clear();
                            ServerImpl.this.spiState = TcpDiscoverySpiState.CONNECTED;
                            ServerImpl.this.mux.notifyAll();
                        }
                        ServerImpl.this.notifyDiscovery(10, 1L, ServerImpl.this.locNode, joinReqMsg.spanContainer());
                        return null;
                    }
                });
                try {
                    fut.get();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteSpiException(e);
                }
                this.msgWorker.nullifyDiscoData();
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Join request message has been sent (waiting for coordinator response).");
            }
            Object object2 = this.mux;
            synchronized (object2) {
                long timeout = this.spi.netTimeout;
                long thresholdNanos = System.nanoTime() + U.millisToNanos(timeout);
                while (this.spiState == TcpDiscoverySpiState.CONNECTING && timeout > 0L) {
                    try {
                        this.mux.wait(timeout);
                        timeout = U.nanosToMillis(thresholdNanos - System.nanoTime());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IgniteSpiException("Thread has been interrupted.", e);
                    }
                }
                if (this.spiState == TcpDiscoverySpiState.CONNECTED) {
                    break;
                }
                if (this.spiState == TcpDiscoverySpiState.DUPLICATE_ID) {
                    throw this.spi.duplicateIdError((TcpDiscoveryDuplicateIdMessage)this.joinRes.get());
                }
                if (this.spiState == TcpDiscoverySpiState.AUTH_FAILED) {
                    throw this.spi.authenticationFailedError((TcpDiscoveryAuthFailedMessage)this.joinRes.get());
                }
                if (this.spiState == TcpDiscoverySpiState.CHECK_FAILED) {
                    TcpDiscoveryCheckFailedMessage checkFailedMsg = (TcpDiscoveryCheckFailedMessage)this.joinRes.get();
                    if (!IgniteSystemProperties.getBoolean("IGNITE_DISABLE_MAINTENANCE_CLEAR_FOLDER_TASK") && checkFailedMsg.error().contains("Joining node has caches with data which are not presented on cluster")) {
                        this.scheduleMaintenanceTaskToClearCacheFolders(checkFailedMsg);
                    }
                    throw this.spi.checkFailedError(checkFailedMsg);
                }
                if (this.spiState == TcpDiscoverySpiState.RING_FAILED) {
                    throw new IgniteSpiException("Unable to connect to next nodes in a ring, it seems local node is experiencing connectivity issues or the rest of the cluster is undergoing massive restarts. Failing local node join to avoid case when one node fails a big part of cluster. To disable this behavior set TcpDiscoverySpi.setConnectionRecoveryTimeout() to 0. [connRecoveryTimeout=" + this.spi.connRecoveryTimeout + ", effectiveConnRecoveryTimeout=" + this.spi.getEffectiveConnectionRecoveryTimeout() + ']');
                }
                if (this.spiState == TcpDiscoverySpiState.LOOPBACK_PROBLEM) {
                    TcpDiscoveryLoopbackProblemMessage msg = (TcpDiscoveryLoopbackProblemMessage)this.joinRes.get();
                    boolean locHostLoopback = this.spi.locHost.isLoopbackAddress();
                    String firstNode = locHostLoopback ? "local" : "remote";
                    String secondNode = locHostLoopback ? "remote" : "local";
                    throw new IgniteSpiException("Failed to add node to topology because " + firstNode + " node is configured to use loopback address, but " + secondNode + " node is not (consider changing 'localAddress' configuration parameter) [locNodeAddrs=" + U.addressesAsString(this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(msg.addresses(), msg.hostNames()) + ", creatorNodeId=" + msg.creatorNodeId() + ']');
                }
                LT.warn(this.log, "Node has not been connected to topology and will repeat join process. Check remote nodes logs for possible error messages. Note that large topology may require significant time to start. Increase 'TcpDiscoverySpi.networkTimeout' configuration property if getting this message on the starting nodes [networkTimeout=" + this.spi.netTimeout + ']');
            }
        }
        assert (this.locNode.order() != 0L);
        assert (this.locNode.internalOrder() != 0L);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Discovery SPI has been connected to topology with order: " + this.locNode.internalOrder());
        }
        joinReqMsg.spanContainer().span().addTag(SpanTags.tag("node", "order"), () -> String.valueOf(this.locNode.order())).addLog(() -> "Joined to ring").end();
    }

    private void scheduleMaintenanceTaskToClearCacheFolders(TcpDiscoveryCheckFailedMessage checkFailedMsg) {
        try {
            ArrayList<CacheConfiguration> cacheCfgs = new ArrayList<CacheConfiguration>();
            GridCacheSharedContext sharedCacheContext = this.gridKernalContext().cache().context();
            for (String cacheName : checkFailedMsg.error().replaceFirst("^.*\\[", "").replaceFirst("\\].*", "").split(", ")) {
                CacheConfiguration cc = sharedCacheContext.cacheContext(CU.cacheId(cacheName)).config();
                cacheCfgs.add(cc);
            }
            FilePageStoreManager pageStore = (FilePageStoreManager)sharedCacheContext.pageStore();
            String params = cacheCfgs.stream().map(ccfg -> pageStore.cacheWorkDir((CacheConfiguration)((Object)ccfg)).getName()).collect(Collectors.joining(File.separator));
            this.log.warning("The node won't join the cluster, because it has several caches, that were removed from the cluster. The node is going to enter maintenance mode after restart and will clear files of stale caches automatically. The node is restarting in maintenance mode and starting clearing automatically. When the task is finished, node has to be restarted once again to leave maintenance mode and join the cluster back.");
            this.gridKernalContext().maintenanceRegistry().registerMaintenanceTask(new MaintenanceTask("clearFolderAction", "The node has several caches that are already removed from the cluster", params));
        }
        catch (Throwable e) {
            this.log.warning("Could not create a maintenance task to remove stale caches data. The cache folders should be removed manually before trying to join the cluster again", e);
        }
    }

    private void localAuthentication(SecurityCredentials locCred) {
        assert (this.spi.nodeAuth != null);
        assert (locCred != null);
        try {
            SecurityContext subj = this.spi.nodeAuth.authenticateNode(this.locNode, locCred);
            if (subj == null) {
                throw new IgniteSpiException("Authentication failed for local node: " + this.locNode.id());
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>(this.locNode.attributes());
            attrs.put("org.apache.ignite.security.subject.v2", U.marshal(this.spi.marshaller(), (Object)subj));
            attrs.put("org.apache.ignite.security.subject", this.marshalWithSecurityVersion(subj, 1));
            this.locNode.setAttributes(attrs);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw new IgniteSpiException("Failed to authenticate local node (will shutdown local node).", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] marshalWithSecurityVersion(Object obj, int ver) throws IgniteCheckedException {
        try {
            SecurityUtils.serializeVersion(ver);
            byte[] byArray = U.marshal(this.spi.marshaller(), obj);
            return byArray;
        }
        finally {
            SecurityUtils.restoreDefaultSerializeVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendJoinRequestMessage(TcpDiscoveryJoinRequestMessage joinMsg) throws IgniteSpiException {
        long joinStartNanos = 0L;
        while (true) {
            Collection<InetSocketAddress> addrs;
            if (F.isEmpty(addrs = this.spi.resolvedAddresses())) {
                return false;
            }
            boolean retry = false;
            boolean joinImpossible = false;
            ArrayList<IgniteSpiException> errs = new ArrayList<IgniteSpiException>();
            for (InetSocketAddress inetSocketAddress : addrs) {
                try {
                    Integer res;
                    IgniteSpiOperationTimeoutHelper timeoutHelper = new IgniteSpiOperationTimeoutHelper(this.spi, true);
                    try {
                        SecurityUtils.serializeVersion(1);
                        res = this.sendMessageDirectly(joinMsg, inetSocketAddress, timeoutHelper);
                    }
                    finally {
                        SecurityUtils.restoreDefaultSerializeVersion();
                    }
                    assert (res != null);
                    this.noResAddrs.remove(inetSocketAddress);
                    if (res != 200 && res != 100) {
                        joinStartNanos = 0L;
                    }
                    switch (res) {
                        case 200: {
                            retry = true;
                            break;
                        }
                        case 1: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Join request message has been sent to address [addr=" + inetSocketAddress + ", req=" + joinMsg + ']');
                            }
                            return true;
                        }
                        case 255: {
                            joinImpossible = true;
                            break;
                        }
                        default: {
                            if (res == 100) {
                                if (!this.fromAddrs.contains(inetSocketAddress)) {
                                    retry = true;
                                }
                                break;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Unexpected response to join request: " + res);
                            }
                            retry = true;
                            break;
                        }
                    }
                }
                catch (IgniteSpiException e) {
                    errs.add(e);
                    if (this.log.isDebugEnabled()) {
                        IOException ioe = X.cause(e, IOException.class);
                        this.log.debug("Failed to send join request message [addr=" + inetSocketAddress + ", msg=" + (ioe != null ? ioe.getMessage() : e.getMessage()) + ']');
                        this.onException("Failed to send join request message [addr=" + inetSocketAddress + ", msg=" + (ioe != null ? ioe.getMessage() : e.getMessage()) + ']', ioe);
                    }
                    this.noResAddrs.add(inetSocketAddress);
                }
                if (!joinImpossible) continue;
                throw new IgniteSpiException("Impossible to continue join, check if local discovery and communication ports are not blocked with firewall [addr=" + inetSocketAddress + ", req=" + joinMsg + ", discoLocalPort=" + this.spi.getLocalPort() + ", discoLocalPortRange=" + this.spi.getLocalPortRange() + ']');
            }
            if (retry) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Concurrent discovery SPI start has been detected (local node should wait).");
                }
                try {
                    U.sleep(this.spi.getReconnectDelay());
                }
                catch (IgniteInterruptedCheckedException e) {
                    throw new IgniteSpiException("Thread has been interrupted.", e);
                }
            }
            if (this.spi.ipFinder.isShared() || this.ipFinderHasLocAddr) break;
            IgniteCheckedException e = null;
            if (!errs.isEmpty()) {
                e = new IgniteCheckedException("Multiple connection attempts failed.");
                for (Exception err : errs) {
                    e.addSuppressed(err);
                }
            }
            if (X.hasCause((Throwable)e, ConnectException.class)) {
                LT.warn(this.log, "Failed to connect to any address from IP finder (make sure IP finder addresses are correct and firewalls are disabled on all host machines): " + ServerImpl.toOrderedList(addrs), true);
            }
            if (this.spi.joinTimeout > 0L) {
                if (joinStartNanos == 0L) {
                    joinStartNanos = System.nanoTime();
                } else if (U.millisSinceNanos(joinStartNanos) > this.spi.joinTimeout) {
                    throw new IgniteSpiException("Failed to connect to any address from IP finder within join timeout (make sure IP finder addresses are correct, and operating system firewalls are disabled on all host machines, or consider increasing 'joinTimeout' configuration property): " + addrs, e);
                }
            }
            try {
                U.sleep(this.spi.getReconnectDelay());
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                throw new IgniteSpiException("Thread has been interrupted.", igniteInterruptedCheckedException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private Integer sendMessageDirectly(TcpDiscoveryAbstractMessage msg, InetSocketAddress addr, IgniteSpiOperationTimeoutHelper timeoutHelper) throws IgniteSpiException {
        boolean joinReqSent;
        assert (msg != null);
        assert (addr != null);
        ArrayList<Throwable> errs = null;
        long ackTimeout0 = this.spi.getAckTimeout();
        int connectAttempts = 1;
        int sslConnectAttempts = 3;
        UUID locNodeId = this.getLocalNodeId();
        int reconCnt = 0;
        while (true) {
            Integer n;
            TcpDiscoveryHandshakeResponse res;
            long tsNanos;
            Socket sock;
            boolean openSock;
            block32: {
                block33: {
                    block31: {
                        joinReqSent = false;
                        openSock = false;
                        sock = null;
                        tsNanos = System.nanoTime();
                        sock = this.spi.openSocket(addr, timeoutHelper);
                        openSock = true;
                        TcpDiscoveryHandshakeRequest req = new TcpDiscoveryHandshakeRequest(locNodeId);
                        this.spi.writeToSocket(sock, req, timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                        res = (TcpDiscoveryHandshakeResponse)this.spi.readMessage(sock, null, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                        if (!(msg instanceof TcpDiscoveryJoinRequestMessage)) break block31;
                        boolean ignore = false;
                        if (!res.isDiscoveryDataPacketCompression()) {
                            ((TcpDiscoveryJoinRequestMessage)msg).gridDiscoveryData().unzipZippedData(this.log);
                        }
                        Object object = this.mux;
                        synchronized (object) {
                            for (TcpDiscoveryNode failedNode : this.failedNodes.keySet()) {
                                if (!failedNode.id().equals(res.creatorNodeId())) continue;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Ignore response from node from failed list: " + res);
                                }
                                ignore = true;
                                break;
                            }
                        }
                        if (!ignore) break block31;
                        U.closeQuiet(sock);
                        break;
                    }
                    if (!locNodeId.equals(res.creatorNodeId())) break block32;
                    if (!this.log.isDebugEnabled()) break block33;
                    this.log.debug("Handshake response from local node: " + res);
                }
                U.closeQuiet(sock);
                break;
            }
            try {
                tsNanos = System.nanoTime();
                this.spi.writeToSocket(sock, msg, timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                long tsNanos0 = System.nanoTime();
                if (this.debugMode) {
                    this.debugLog(msg, "Message has been sent directly to address [msg=" + msg + ", addr=" + addr + ", rmtNodeId=" + res.creatorNodeId() + ']');
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message has been sent directly to address [msg=" + msg + ", addr=" + addr + ", rmtNodeId=" + res.creatorNodeId() + ']');
                }
                joinReqSent = msg instanceof TcpDiscoveryJoinRequestMessage;
                int receipt = this.spi.readReceipt(sock, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                this.spi.stats.onMessageSent(msg, U.nanosToMillis(tsNanos0 - tsNanos));
                n = receipt;
            }
            catch (ClassCastException e) {
                if (this.log.isDebugEnabled()) {
                    U.error(this.log, "Class cast exception on direct send: " + addr, e);
                }
                this.onException("Class cast exception on direct send: " + addr, e);
                if (errs == null) {
                    errs = new ArrayList<Throwable>();
                }
                errs.add(e);
                U.closeQuiet(sock);
                continue;
            }
            catch (IOException | IgniteCheckedException e2) {
                block43: {
                    block41: {
                        block42: {
                            block40: {
                                block39: {
                                    block36: {
                                        block38: {
                                            block37: {
                                                block34: {
                                                    block35: {
                                                        if (this.log.isDebugEnabled()) {
                                                            this.log.error("Exception on direct send: " + e2.getMessage(), e2);
                                                        }
                                                        this.onException("Exception on direct send: " + e2.getMessage(), e2);
                                                        if (errs == null) {
                                                            errs = new ArrayList();
                                                        }
                                                        errs.add(e2);
                                                        if (!X.hasCause((Throwable)e2, SSLException.class)) break block34;
                                                        if (--sslConnectAttempts != 0) break block35;
                                                        throw new IgniteException("Unable to establish secure connection. Was remote cluster configured with SSL? [rmtAddr=" + addr + ", errMsg=\"" + e2.getMessage() + "\"]", e2);
                                                        {
                                                            catch (Throwable throwable) {
                                                                U.closeQuiet(sock);
                                                                throw throwable;
                                                            }
                                                        }
                                                    }
                                                    U.closeQuiet(sock);
                                                    continue;
                                                }
                                                if (!X.hasCause((Throwable)e2, StreamCorruptedException.class)) break block36;
                                                if (connectAttempts >= 2) break block37;
                                                ++connectAttempts;
                                                U.closeQuiet(sock);
                                                continue;
                                            }
                                            if (!this.log.isDebugEnabled()) break block38;
                                            this.log.debug("Connect failed with StreamCorruptedException, skip address: " + addr);
                                        }
                                        U.closeQuiet(sock);
                                        break;
                                    }
                                    if (!timeoutHelper.checkFailureTimeoutReached(e2)) break block39;
                                    U.closeQuiet(sock);
                                    break;
                                }
                                if (this.spi.failureDetectionTimeoutEnabled() || ++reconCnt != this.spi.getReconnectCount()) break block40;
                                U.closeQuiet(sock);
                                break;
                            }
                            if (openSock) break block41;
                            if (connectAttempts >= 2) break block42;
                            ++connectAttempts;
                            U.closeQuiet(sock);
                            continue;
                        }
                        U.closeQuiet(sock);
                        break;
                    }
                    if (this.spi.failureDetectionTimeoutEnabled() || !(e2 instanceof SocketTimeoutException) && !X.hasCause((Throwable)e2, SocketTimeoutException.class) || this.checkAckTimeout(ackTimeout0 *= 2L)) break block43;
                    U.closeQuiet(sock);
                    break;
                }
                U.closeQuiet(sock);
                continue;
            }
            U.closeQuiet(sock);
            return n;
            break;
        }
        if (joinReqSent) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Join request has been sent, but receipt has not been read (returning RES_WAIT).");
            }
            return 1;
        }
        throw new IgniteSpiException("Failed to send message to address [addr=" + addr + ", msg=" + msg + ']', U.exceptionWithSuppressed("Failed to send message to address [addr=" + addr + ", msg=" + msg + ']', errs));
    }

    private void marshalCredentials(TcpDiscoveryNode node, SecurityCredentials cred) throws IgniteSpiException {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
            attrs.put("org.apache.ignite.security.cred", this.spi.marshaller().marshal(cred));
            node.setAttributes(attrs);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal node security credentials: " + node.id(), e);
        }
    }

    private SecurityCredentials unmarshalCredentials(TcpDiscoveryNode node) throws IgniteSpiException {
        try {
            byte[] credBytes = (byte[])node.getAttributes().get("org.apache.ignite.security.cred");
            if (credBytes == null) {
                return null;
            }
            return (SecurityCredentials)U.unmarshal(this.spi.marshaller(), credBytes, null);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to unmarshal node security credentials: " + node.id(), e);
        }
    }

    private void notifyDiscovery(int type, long topVer, TcpDiscoveryNode node) {
        this.notifyDiscovery(type, topVer, node, null);
    }

    private boolean notifyDiscovery(int type, long topVer, TcpDiscoveryNode node, SpanContainer spanContainer) {
        TcpDiscoveryImpl.DebugLogger log;
        assert (type > 0);
        assert (node != null);
        DiscoverySpiListener lsnr = this.spi.lsnr;
        TcpDiscoverySpiState spiState = this.spiStateCopy();
        TcpDiscoveryImpl.DebugLogger debugLogger = log = type == 13 ? this.traceLog : this.debugLog;
        if (lsnr != null && node.visible() && (spiState == TcpDiscoverySpiState.CONNECTED || spiState == TcpDiscoverySpiState.DISCONNECTING)) {
            if (log.isDebugEnabled()) {
                log.debug("Discovery notification [node=" + node + ", spiState=" + (Object)((Object)spiState) + ", type=" + U.gridEventName(type) + ", topVer=" + topVer + ']');
            }
            Collection<ClusterNode> top = ServerImpl.upcast(this.ring.visibleNodes());
            Map<Long, Collection<ClusterNode>> hist = this.updateTopologyHistory(topVer, top);
            lsnr.onDiscovery(new DiscoveryNotification(type, topVer, node, top, hist, null, spanContainer));
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Skipped discovery notification [node=" + node + ", spiState=" + (Object)((Object)spiState) + ", type=" + U.gridEventName(type) + ", topVer=" + topVer + ']');
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<Long, Collection<ClusterNode>> updateTopologyHistory(long topVer, Collection<ClusterNode> top) {
        Object object = this.mux;
        synchronized (object) {
            if (this.topHist.containsKey(topVer)) {
                return null;
            }
            this.topHist.put(topVer, top);
            while (this.topHist.size() > this.spi.topHistSize) {
                this.topHist.remove(this.topHist.firstKey());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added topology snapshot to history, topVer=" + topVer + ", historySize=" + this.topHist.size());
            }
            return new TreeMap<Long, Collection<ClusterNode>>(this.topHist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalNodeCoordinator() {
        Object object = this.mux;
        synchronized (object) {
            boolean crd;
            boolean bl = crd = this.spiState == TcpDiscoverySpiState.CONNECTED && this.locNode.equals(this.resolveCoordinator());
            if (crd) {
                this.spi.stats.onBecomingCoordinator();
            }
            return crd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpDiscoverySpiState spiStateCopy() {
        TcpDiscoverySpiState state;
        Object object = this.mux;
        synchronized (object) {
            state = this.spiState;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TcpDiscoveryNode resolveCoordinator() {
        Object object = this.mux;
        synchronized (object) {
            Collection<TcpDiscoveryNode> excluded = F.concat(false, this.failedNodes.keySet(), this.leavingNodes);
            return this.ring.coordinator(excluded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStatistics() {
        if (this.log.isInfoEnabled() && this.spi.statsPrintFreq > 0L) {
            int pendingCustomMsgsSize;
            int joiningNodesSize;
            int leavingNodesSize;
            int failedNodesSize;
            Object object = this.mux;
            synchronized (object) {
                failedNodesSize = this.failedNodes.size();
                leavingNodesSize = this.leavingNodes.size();
                joiningNodesSize = this.joiningNodes.size();
                pendingCustomMsgsSize = this.pendingCustomMsgs.size();
            }
            Runtime runtime = Runtime.getRuntime();
            TcpDiscoveryNode coord = this.resolveCoordinator();
            if (this.log.isInfoEnabled()) {
                this.log.info("Discovery SPI statistics [statistics=" + this.spi.stats + ", spiState=" + (Object)((Object)this.spiStateCopy()) + ", coord=" + coord + ", next=" + (this.msgWorker != null ? this.msgWorker.next : "N/A") + ", intOrder=" + (this.locNode != null ? Long.valueOf(this.locNode.internalOrder()) : "N/A") + ", topSize=" + this.ring.allNodes().size() + ", leavingNodesSize=" + leavingNodesSize + ", failedNodesSize=" + failedNodesSize + ", joiningNodesSize=" + joiningNodesSize + ", pendingCustomMsgs=" + pendingCustomMsgsSize + ", msgWorker.queue.size=" + (this.msgWorker != null ? Integer.valueOf(this.msgWorker.queueSize()) : "N/A") + ", clients=" + this.ring.clientNodes().size() + ", clientWorkers=" + this.clientMsgWorkers.size() + ", lastUpdate=" + (this.locNode != null ? U.format(this.locNode.lastUpdateTime()) : "N/A") + ", heapFree=" + runtime.freeMemory() / 0x100000L + "M, heapTotal=" + runtime.maxMemory() / 0x100000L + "M]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNodeAddedMessage(TcpDiscoveryAbstractMessage msg, UUID destNodeId, @Nullable Collection<PendingMessage> msgs, @Nullable IgniteUuid discardCustomMsgId) {
        TcpDiscoveryNodeAddedMessage nodeAddedMsg;
        TcpDiscoveryNode node;
        assert (destNodeId != null);
        if (msg instanceof TcpDiscoveryNodeAddedMessage && (node = (nodeAddedMsg = (TcpDiscoveryNodeAddedMessage)msg).node()).id().equals(destNodeId)) {
            TreeMap<Long, Collection<ClusterNode>> treeMap;
            Collection<TcpDiscoveryNode> allNodes = this.ring.allNodes();
            ArrayList<TcpDiscoveryNode> topToSnd = new ArrayList<TcpDiscoveryNode>(allNodes.size());
            for (TcpDiscoveryNode tcpDiscoveryNode : allNodes) {
                assert (tcpDiscoveryNode.internalOrder() != 0L) : tcpDiscoveryNode;
                if (tcpDiscoveryNode.internalOrder() >= nodeAddedMsg.node().internalOrder()) continue;
                topToSnd.add(tcpDiscoveryNode);
            }
            nodeAddedMsg.topology(topToSnd);
            ArrayList<TcpDiscoveryAbstractMessage> msgs0 = null;
            if (msgs != null) {
                msgs0 = new ArrayList<TcpDiscoveryAbstractMessage>(msgs.size());
                for (PendingMessage pendingMsg : msgs) {
                    if (pendingMsg.msg == null) continue;
                    msgs0.add(pendingMsg.msg);
                }
            }
            nodeAddedMsg.messages(msgs0, null, discardCustomMsgId);
            Object object = this.mux;
            synchronized (object) {
                treeMap = new TreeMap<Long, Collection<ClusterNode>>(this.topHist);
            }
            nodeAddedMsg.topologyHistory(treeMap);
        }
    }

    private boolean clientSupportsDiscoveryMessage(TcpDiscoveryAbstractMessage msg, @NotNull UUID clientNodeId) {
        if (!(msg instanceof TcpDiscoveryCustomEventMessage)) {
            return true;
        }
        if (msg instanceof TcpDiscoveryServerOnlyCustomEventMessage) {
            return false;
        }
        TcpDiscoveryNode node = this.ring.node(clientNodeId);
        if (node == null) {
            return true;
        }
        return this.clientSupportsDiscoveryMessage(msg, node);
    }

    private boolean clientSupportsDiscoveryMessage(TcpDiscoveryAbstractMessage msg, @NotNull ClusterNode node) {
        Class<?> msgClass;
        if (!(msg instanceof TcpDiscoveryCustomEventMessage)) {
            return true;
        }
        if (msg instanceof TcpDiscoveryServerOnlyCustomEventMessage) {
            return false;
        }
        try {
            msgClass = ((TcpDiscoveryCustomEventMessage)msg).messageClass();
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to detect class of DiscoveryCustomMessage: " + e.getMessage());
            return true;
        }
        TcpDiscoveryRequiredFeatureSupport featAnnot = U.getDeclaredAnnotation(msgClass, TcpDiscoveryRequiredFeatureSupport.class);
        if (featAnnot != null) {
            byte[] featuresBytes;
            IgniteFeatures reqFeature = featAnnot.feature();
            if (node != null && !IgniteFeatures.nodeSupports(featuresBytes = (byte[])node.attribute("org.apache.ignite.features"), reqFeature)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Client node " + node.id() + " doesn't support feature " + (Object)((Object)reqFeature) + ", sending message " + msgClass + " to the client is skipped.");
                }
                return false;
            }
        }
        return true;
    }

    private void clearNodeAddedMessage(TcpDiscoveryAbstractMessage msg) {
        if (msg instanceof TcpDiscoveryNodeAddedMessage) {
            TcpDiscoveryNodeAddedMessage nodeAddedMsg = (TcpDiscoveryNodeAddedMessage)msg;
            nodeAddedMsg.topology(null);
            nodeAddedMsg.topologyHistory(null);
            nodeAddedMsg.messages(null, null, null);
            nodeAddedMsg.clearUnmarshalledDiscoveryData();
        }
    }

    @Override
    public void checkRingLatency(int maxHops) {
        TcpDiscoveryRingLatencyCheckMessage msg = new TcpDiscoveryRingLatencyCheckMessage(this.getLocalNodeId(), maxHops);
        if (this.log.isInfoEnabled()) {
            this.log.info("Latency check initiated: " + msg.id());
        }
        this.msgWorker.addMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void simulateNodeFailure() {
        List tmp;
        U.warn(this.log, "Simulating node failure: " + this.getLocalNodeId());
        if (this.tcpSrvr != null) {
            this.tcpSrvr.stop();
            this.tcpSrvr = null;
        }
        U.interrupt(this.ipFinderCleaner);
        U.join(this.ipFinderCleaner, this.log);
        Iterator iterator = this.mux;
        synchronized (iterator) {
            tmp = U.arrayList(this.readers);
        }
        U.interrupt(tmp);
        U.joinThreads(tmp, this.log);
        U.cancel(this.msgWorker);
        U.join(this.msgWorker, this.log);
        for (ClientMessageWorker msgWorker : this.clientMsgWorkers.values()) {
            if (msgWorker == null) continue;
            U.interrupt(msgWorker.runner());
            U.join(msgWorker.runner(), this.log);
        }
        U.interrupt(this.statsPrinter);
        U.join(this.statsPrinter, this.log);
    }

    @Override
    public void brakeConnection() {
        Socket sock = this.msgWorker.sock;
        if (sock != null) {
            U.closeQuiet(sock);
        }
    }

    @Override
    public void reconnect() throws IgniteSpiException {
        throw new UnsupportedOperationException("Reconnect is not supported for server.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<IgniteSpiThread> threads() {
        Thread tcpSrvThread;
        ArrayList<IgniteSpiThread> threads;
        Iterator iterator = this.mux;
        synchronized (iterator) {
            threads = new ArrayList<IgniteSpiThread>(this.readers.size() + this.clientMsgWorkers.size() + 4);
            threads.addAll(this.readers);
        }
        for (ClientMessageWorker wrk : this.clientMsgWorkers.values()) {
            Thread t = wrk.runner();
            assert (t instanceof IgniteSpiThread);
            threads.add((IgniteSpiThread)t);
        }
        TcpServer tcpSrvr0 = this.tcpSrvr;
        if (tcpSrvr0 != null && (tcpSrvThread = tcpSrvr0.runner()) != null) {
            assert (tcpSrvThread instanceof IgniteSpiThread);
            threads.add((IgniteSpiThread)tcpSrvThread);
        }
        threads.add(this.ipFinderCleaner);
        Thread msgWorkerThread = this.msgWorker.runner();
        if (msgWorkerThread != null) {
            assert (msgWorkerThread instanceof IgniteSpiThread);
            threads.add((IgniteSpiThread)msgWorkerThread);
        }
        threads.add(this.statsPrinter);
        threads.removeAll(Collections.singleton(null));
        return threads;
    }

    @Override
    public void updateMetrics(UUID nodeId, ClusterMetrics metrics, Map<Integer, CacheMetrics> cacheMetrics, long tsNanos) {
        assert (nodeId != null);
        assert (metrics != null);
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node != null) {
            node.setMetrics(metrics);
            node.setCacheMetrics(cacheMetrics);
            node.lastUpdateTimeNanos(tsNanos);
            this.notifyDiscovery(13, this.ring.topologyVersion(), node);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Received metrics from unknown node: " + nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceNextNodeFailure() {
        TcpDiscoveryNode next;
        U.warn(this.log, "Next node will be forcibly failed (if any).");
        Object object = this.mux;
        synchronized (object) {
            next = this.ring.nextNode(this.failedNodes.keySet());
        }
        if (next != null) {
            this.msgWorker.addMessage(new TcpDiscoveryNodeFailedMessage(this.getLocalNodeId(), next.id(), next.internalOrder()));
        }
    }

    TcpDiscoveryNodesRing ring() {
        return this.ring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDebugInfo(IgniteLogger log) {
        if (!this.debugMode) {
            U.quietAndWarn(log, "Failed to dump debug info (discovery SPI was not configured in debug mode, consider setting 'debugMode' configuration property to 'true').");
            return;
        }
        assert (log.isInfoEnabled());
        StringBuilder b = new StringBuilder(U.nl());
        Object object = this.mux;
        synchronized (object) {
            b.append(">>>").append(U.nl());
            b.append(">>>").append("Dumping discovery SPI debug info.").append(U.nl());
            b.append(">>>").append(U.nl());
            b.append("Local node ID: ").append(this.getLocalNodeId()).append(U.nl()).append(U.nl());
            b.append("Local node: ").append(this.locNode).append(U.nl()).append(U.nl());
            b.append("SPI state: ").append((Object)this.spiState).append(U.nl()).append(U.nl());
            b.append("Internal threads: ").append(U.nl());
            b.append("    Message worker: ").append(ServerImpl.threadStatus(this.msgWorker.runner())).append(U.nl());
            b.append("    IP finder cleaner: ").append(ServerImpl.threadStatus(this.ipFinderCleaner)).append(U.nl());
            b.append("    Stats printer: ").append(ServerImpl.threadStatus(this.statsPrinter)).append(U.nl());
            b.append(U.nl());
            b.append("Socket readers: ").append(U.nl());
            for (SocketReader rdr : this.readers) {
                b.append("    ").append(rdr).append(U.nl());
            }
            b.append(U.nl());
            b.append("In-memory log messages: ").append(U.nl());
            for (String msg : this.debugLogQ) {
                b.append("    ").append(msg).append(U.nl());
            }
            b.append(U.nl());
            b.append("Leaving nodes: ").append(U.nl());
            for (TcpDiscoveryNode node : this.leavingNodes) {
                b.append("    ").append(node.id()).append(U.nl());
            }
            b.append(U.nl());
            b.append("Failed nodes: ").append(U.nl());
            for (TcpDiscoveryNode node : this.failedNodes.keySet()) {
                b.append("    ").append(node.id()).append(U.nl());
            }
            b.append(U.nl());
            b.append("Stats: ").append(this.spi.stats).append(U.nl());
        }
        U.quietAndInfo(log, b.toString());
    }

    @Override
    public void dumpRingStructure(IgniteLogger log) {
        U.quietAndInfo(log, this.ring.toString());
    }

    @Override
    public long getCurrentTopologyVersion() {
        return this.ring.topologyVersion();
    }

    private boolean recordable(TcpDiscoveryAbstractMessage msg) {
        return !(msg instanceof TcpDiscoveryMetricsUpdateMessage) && !(msg instanceof TcpDiscoveryStatusCheckMessage) && !(msg instanceof TcpDiscoveryDiscardMessage) && !(msg instanceof TcpDiscoveryConnectionCheckMessage);
    }

    private boolean permissionsEqual(@Nullable SecurityPermissionSet locPerms, @Nullable SecurityPermissionSet rmtPerms) {
        if (locPerms == null || rmtPerms == null) {
            return false;
        }
        boolean dfltAllowMatch = locPerms.defaultAllowAll() == rmtPerms.defaultAllowAll();
        boolean bothHaveSamePerms = F.eqNotOrdered(rmtPerms.systemPermissions(), locPerms.systemPermissions()) && F.eqNotOrdered(rmtPerms.cachePermissions(), locPerms.cachePermissions()) && F.eqNotOrdered(rmtPerms.taskPermissions(), locPerms.taskPermissions());
        return dfltAllowMatch && bothHaveSamePerms;
    }

    private static void removeMetrics(TcpDiscoveryMetricsUpdateMessage msg, UUID nodeId) {
        msg.removeMetrics(nodeId);
        msg.removeCacheMetrics(nodeId);
    }

    public String toString() {
        return S.toString(ServerImpl.class, this);
    }

    ClusterNode getNode0(UUID nodeId) {
        assert (nodeId != null);
        UUID locNodeId0 = this.getLocalNodeId();
        if (locNodeId0 != null && locNodeId0.equals(nodeId)) {
            return this.locNode;
        }
        return this.ring.node(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweepMessageFailedNodes(TcpDiscoveryAbstractMessage msg) {
        msg.failedNodes(null);
        Object object = this.mux;
        synchronized (object) {
            for (TcpDiscoveryNode n : this.failedNodes.keySet()) {
                msg.addFailedNode(n.id());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Message failed nodes were replaced with failed nodes observed by local node: " + msg.failedNodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageFailedNodes(TcpDiscoveryAbstractMessage msg) {
        Collection<UUID> msgFailedNodes = msg.failedNodes();
        if (msgFailedNodes != null) {
            UUID sndId = msg.senderNodeId();
            if (sndId != null) {
                if (this.ring.node(sndId) == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Ignore message failed nodes, sender node is not alive [nodeId=" + sndId + ", failedNodes=" + msgFailedNodes + ']');
                    }
                    this.sweepMessageFailedNodes(msg);
                    return;
                }
                Object object = this.mux;
                synchronized (object) {
                    for (TcpDiscoveryNode failedNode : this.failedNodes.keySet()) {
                        if (!failedNode.id().equals(sndId)) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Ignore message failed nodes, sender node is in fail list [nodeId=" + sndId + ", failedNodes=" + msgFailedNodes + ']');
                        }
                        this.sweepMessageFailedNodes(msg);
                        return;
                    }
                }
            }
            for (UUID nodeId : msgFailedNodes) {
                TcpDiscoveryNode failedNode;
                failedNode = this.ring.node(nodeId);
                if (failedNode == null || failedNode.isLocal()) continue;
                boolean added = false;
                Object object = this.mux;
                synchronized (object) {
                    if (!this.failedNodes.containsKey(failedNode)) {
                        this.failedNodes.put(failedNode, msg.senderNodeId() != null ? msg.senderNodeId() : this.getLocalNodeId());
                        added = true;
                    }
                }
                if (!added || !this.log.isDebugEnabled()) continue;
                this.log.debug("Added node to failed nodes list [node=" + failedNode + ", msg=" + msg + ']');
            }
        }
    }

    private static WorkersRegistry getWorkerRegistry(TcpDiscoverySpi spi) {
        return spi.ignite() instanceof IgniteEx ? ((IgniteEx)spi.ignite()).context().workersRegistry() : null;
    }

    static /* synthetic */ int access$2400() {
        return ENSURED_MSG_HIST_SIZE;
    }

    static /* synthetic */ long access$9400(ServerImpl x0) {
        return x0.lastRingMsgReceivedTime;
    }

    static /* synthetic */ boolean access$9700(ServerImpl x0, TcpDiscoveryAbstractMessage x1) {
        return x0.recordable(x1);
    }

    static /* synthetic */ Thread access$9900(ServerImpl x0) {
        return x0.msgWorkerThread;
    }

    private class MetricsUpdateMessageFilter {
        private volatile TcpDiscoveryMetricsUpdateMessage actualFirstLapMetricsUpdate;
        private volatile TcpDiscoveryMetricsUpdateMessage actualSecondLapMetricsUpdate;

        private MetricsUpdateMessageFilter() {
        }

        private boolean addMessage(TcpDiscoveryMetricsUpdateMessage msg) {
            boolean addToQueue;
            int laps = msg.passedLaps(ServerImpl.this.getLocalNodeId());
            if (laps == 2) {
                return true;
            }
            if (laps == 0) {
                addToQueue = this.actualFirstLapMetricsUpdate == null;
                this.actualFirstLapMetricsUpdate = msg;
            } else {
                assert (laps == 1) : "Unexpected number of laps passed by a metric update message: " + laps;
                addToQueue = this.actualSecondLapMetricsUpdate == null;
                this.actualSecondLapMetricsUpdate = msg;
            }
            return addToQueue;
        }

        private TcpDiscoveryMetricsUpdateMessage pollActualMessage(int laps, TcpDiscoveryMetricsUpdateMessage msg) {
            if (laps == 0) {
                msg = this.actualFirstLapMetricsUpdate;
                this.actualFirstLapMetricsUpdate = null;
            } else if (laps == 1) {
                msg = this.actualSecondLapMetricsUpdate;
                this.actualSecondLapMetricsUpdate = null;
            }
            return msg;
        }
    }

    private class CrossRingMessageSendState {
        private RingMessageSendState state = RingMessageSendState.STARTING_POINT;
        private int failedNodes;
        private final long failTimeNanos;

        CrossRingMessageSendState() {
            this.failTimeNanos = U.millisToNanos(ServerImpl.this.spi.getEffectiveConnectionRecoveryTimeout()) + System.nanoTime();
        }

        boolean isStartingPoint() {
            return this.state == RingMessageSendState.STARTING_POINT;
        }

        boolean isBackward() {
            return this.state == RingMessageSendState.BACKWARD_PASS;
        }

        boolean isFailed() {
            return this.state == RingMessageSendState.FAILED;
        }

        boolean markNextNodeFailed() {
            if (this.state == RingMessageSendState.STARTING_POINT || this.state == RingMessageSendState.FORWARD_PASS) {
                this.state = RingMessageSendState.FORWARD_PASS;
                ++this.failedNodes;
                return true;
            }
            return false;
        }

        boolean markLastFailedNodeAlive() {
            if (this.state == RingMessageSendState.FORWARD_PASS || this.state == RingMessageSendState.BACKWARD_PASS) {
                this.state = RingMessageSendState.BACKWARD_PASS;
                if (--this.failedNodes <= 0) {
                    this.failedNodes = 0;
                    if (System.nanoTime() - this.failTimeNanos >= 0L) {
                        this.state = RingMessageSendState.FAILED;
                        return false;
                    }
                    this.state = RingMessageSendState.STARTING_POINT;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return S.toString(CrossRingMessageSendState.class, this);
        }
    }

    private static enum RingMessageSendState {
        STARTING_POINT,
        FORWARD_PASS,
        BACKWARD_PASS,
        FAILED;

    }

    private static class GridPingFutureAdapter<R>
    extends GridFutureAdapter<R> {
        private final UUID nodeId;
        private volatile Socket sock;

        GridPingFutureAdapter(@Nullable UUID nodeId) {
            this.nodeId = nodeId;
        }

        public Socket sock() {
            return this.sock;
        }

        public void sock(Socket sock) {
            this.sock = sock;
        }
    }

    private abstract class MessageWorker<T>
    extends GridWorker {
        protected final BlockingDeque<T> queue;
        private final long pollingTimeout;
        private Runnable beforeEachPoll;

        protected MessageWorker(String name, IgniteLogger log, @Nullable long pollingTimeout, GridWorkerListener lsnr) {
            super(ServerImpl.this.spi.ignite().name(), name, log, lsnr);
            this.queue = new LinkedBlockingDeque<T>();
            this.pollingTimeout = pollingTimeout;
        }

        void setBeforeEachPollAction(Runnable act) {
            this.beforeEachPoll = act;
        }

        @Override
        protected void body() throws InterruptedException {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Message worker started [locNodeId=" + ServerImpl.this.getConfiguredNodeId() + ']');
            }
            while (!this.isCancelled()) {
                T msg;
                if (this.beforeEachPoll != null) {
                    this.beforeEachPoll.run();
                }
                if ((msg = this.queue.poll(this.pollingTimeout, TimeUnit.MILLISECONDS)) == null) {
                    this.noMessageLoop();
                    continue;
                }
                this.processMessage(msg);
            }
        }

        int queueSize() {
            return this.queue.size();
        }

        protected abstract void processMessage(T var1);

        protected void noMessageLoop() {
        }

        protected void tearDown() {
        }
    }

    private static class MessageWorkerThread<W extends GridWorker>
    extends IgniteSpiThread {
        private volatile boolean interrupted;
        protected final W worker;
        final /* synthetic */ ServerImpl this$0;

        private MessageWorkerThread(W worker, IgniteLogger log) {
            this.this$0 = var1_1;
            super(((GridWorker)worker).igniteInstanceName(), ((GridWorker)worker).name(), log);
            this.worker = worker;
            this.setPriority(var1_1.spi.threadPri);
        }

        @Override
        protected void body() throws InterruptedException {
            ((GridWorker)this.worker).run();
        }

        @Override
        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        @Override
        public boolean isInterrupted() {
            return this.interrupted || super.isInterrupted();
        }
    }

    private class MessageWorkerDiscoveryThread
    extends MessageWorkerThread<GridWorker>
    implements IgniteDiscoveryThread {
        private MessageWorkerDiscoveryThread(GridWorker worker, IgniteLogger log) {
            super(ServerImpl.this, worker, log);
        }

        @Override
        public GridWorker worker() {
            return this.worker;
        }
    }

    private class MessageWorkerThreadWithCleanup<T>
    extends MessageWorkerThread<MessageWorker<T>> {
        private MessageWorkerThreadWithCleanup(MessageWorker<T> worker, IgniteLogger log) {
            super(ServerImpl.this, worker, log);
        }

        @Override
        protected void cleanup() {
            super.cleanup();
            ((MessageWorker)this.worker).tearDown();
        }
    }

    private class ClientMessageWorker
    extends MessageWorker<T2<TcpDiscoveryAbstractMessage, byte[]>> {
        private final UUID clientNodeId;
        private final Socket sock;
        private volatile ClusterMetrics metrics;
        private volatile long lastMetricsUpdateMsgTimeNanos;
        private final AtomicReference<GridFutureAdapter<Boolean>> pingFut;
        private IgniteProductVersion clientVer;

        private ClientMessageWorker(Socket sock, UUID clientNodeId, IgniteLogger log) {
            super("tcp-disco-client-message-worker-[" + U.id8(clientNodeId) + ' ' + sock.getInetAddress().getHostAddress() + ":" + sock.getPort() + ']', log, Math.max(ServerImpl.this.spi.metricsUpdateFreq, 10L), null);
            this.pingFut = new AtomicReference();
            this.sock = sock;
            this.clientNodeId = clientNodeId;
            this.lastMetricsUpdateMsgTimeNanos = System.nanoTime();
        }

        void clientVersion(IgniteProductVersion clientVer) {
            this.clientVer = clientVer;
        }

        ClusterMetrics metrics() {
            return this.metrics;
        }

        void metrics(ClusterMetrics metrics) {
            this.lastMetricsUpdateMsgTimeNanos = System.nanoTime();
            this.metrics = metrics;
        }

        void addMessage(TcpDiscoveryAbstractMessage msg) {
            this.addMessage(msg, null);
        }

        void addMessage(TcpDiscoveryAbstractMessage msg, @Nullable byte[] msgBytes) {
            T2<TcpDiscoveryAbstractMessage, byte[]> t = new T2<TcpDiscoveryAbstractMessage, byte[]>(msg, msgBytes);
            if (msg.highPriority()) {
                this.queue.addFirst(t);
            } else {
                this.queue.add(t);
            }
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if (log.isDebugEnabled()) {
                log.debug("Message has been added to client queue: " + msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processMessage(T2<TcpDiscoveryAbstractMessage, byte[]> msgT) {
            boolean success = false;
            TcpDiscoveryAbstractMessage msg = (TcpDiscoveryAbstractMessage)msgT.get1();
            try {
                boolean clientFailed;
                assert (msg.verified()) : msg;
                byte[] msgBytes = (byte[])msgT.get2();
                if (msgBytes == null) {
                    msgBytes = U.marshal(ServerImpl.this.spi.marshaller(), (Object)msg);
                }
                TcpDiscoveryImpl.DebugLogger msgLog = ServerImpl.this.messageLogger(msg);
                if (msg instanceof TcpDiscoveryClientAckResponse) {
                    if (this.clientVer == null) {
                        ClusterNode node = ServerImpl.this.spi.getNode(this.clientNodeId);
                        if (node != null) {
                            this.clientVer = IgniteUtils.productVersion(node);
                        } else if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Skip sending message ack to client, fail to get client node [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']');
                        }
                    }
                    if (this.clientVer != null) {
                        if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Sending message ack to client [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']');
                        }
                        ServerImpl.this.spi.writeToSocket(this.sock, msg, msgBytes, ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.clientFailureDetectionTimeout() : ServerImpl.this.spi.getSocketTimeout());
                    }
                } else {
                    if (msgLog.isDebugEnabled()) {
                        msgLog.debug("Redirecting message to client [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']');
                    }
                    assert (this.topologyInitialized(msg)) : msg;
                    ServerImpl.this.spi.writeToSocket(this.sock, msg, msgBytes, ServerImpl.this.spi.getEffectiveSocketTimeout(false));
                }
                boolean bl = clientFailed = msg instanceof TcpDiscoveryNodeFailedMessage && ((TcpDiscoveryNodeFailedMessage)msg).failedNodeId().equals(this.clientNodeId);
                assert (!clientFailed || msg.force()) : msg;
                success = !clientFailed;
            }
            catch (IOException | IgniteCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    U.error(this.log, "Client connection failed [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']', e);
                }
                ServerImpl.this.onException("Client connection failed [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']', e);
            }
            finally {
                if (!success) {
                    ServerImpl.this.clientMsgWorkers.remove(this.clientNodeId, this);
                    U.interrupt(this.runner());
                    U.close(this.sock, this.log);
                }
            }
        }

        private boolean topologyInitialized(TcpDiscoveryAbstractMessage msg) {
            TcpDiscoveryNodeAddedMessage addedMsg;
            if (msg instanceof TcpDiscoveryNodeAddedMessage && this.clientNodeId.equals((addedMsg = (TcpDiscoveryNodeAddedMessage)msg).node().id())) {
                return addedMsg.topology() != null;
            }
            return true;
        }

        public void pingResult(boolean res) {
            GridFutureAdapter fut = this.pingFut.getAndSet(null);
            if (fut != null) {
                fut.onDone(res);
            }
        }

        public boolean ping(IgniteSpiOperationTimeoutHelper timeoutHelper) throws InterruptedException {
            GridFutureAdapter<Boolean> fut;
            if (ServerImpl.this.spi.isNodeStopping0()) {
                return false;
            }
            while ((fut = this.pingFut.get()) == null) {
                fut = new GridFutureAdapter();
                if (!this.pingFut.compareAndSet(null, fut)) continue;
                TcpDiscoveryPingRequest pingReq = new TcpDiscoveryPingRequest(ServerImpl.this.getLocalNodeId(), this.clientNodeId);
                pingReq.verify(ServerImpl.this.getLocalNodeId());
                this.addMessage(pingReq);
                break;
            }
            try {
                return fut.get(timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getAckTimeout()), TimeUnit.MILLISECONDS);
            }
            catch (IgniteInterruptedCheckedException ignored) {
                throw new InterruptedException();
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (this.pingFut.compareAndSet(fut, null)) {
                    fut.onDone(false);
                }
                return false;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteSpiException("Internal error: ping future cannot be done with exception", e);
            }
        }

        @Override
        protected void tearDown() {
            this.pingResult(false);
            U.closeQuiet(this.sock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void noMessageLoop() {
            TcpDiscoveryNode clientNode;
            if (U.millisSinceNanos(this.lastMetricsUpdateMsgTimeNanos) > ServerImpl.this.spi.clientFailureDetectionTimeout() && (clientNode = ServerImpl.this.ring.node(this.clientNodeId)) != null) {
                boolean failedNode;
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    failedNode = ServerImpl.this.failedNodes.containsKey(clientNode);
                }
                if (!failedNode) {
                    String msg = "Client node considered as unreachable and will be dropped from cluster, because no metrics update messages received in interval: TcpDiscoverySpi.clientFailureDetectionTimeout() ms. It may be caused by network problems or long GC pause on client node, try to increase this parameter. [nodeId=" + this.clientNodeId + ", clientFailureDetectionTimeout=" + ServerImpl.this.spi.clientFailureDetectionTimeout() + ']';
                    ServerImpl.this.failNode(this.clientNodeId, msg);
                    U.warn(this.log, msg);
                }
            }
        }

        static /* synthetic */ Socket access$9600(ClientMessageWorker x0) {
            return x0.sock;
        }
    }

    private class StatisticsPrinter
    extends IgniteSpiThread {
        StatisticsPrinter() {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-stats-printer", ServerImpl.this.log);
            assert (ServerImpl.this.spi.statsPrintFreq > 0L);
            assert (ServerImpl.this.log.isInfoEnabled());
            this.setPriority(ServerImpl.this.spi.threadPri);
        }

        @Override
        protected void body() throws InterruptedException {
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Statistics printer has been started.");
            }
            while (!this.isInterrupted()) {
                Thread.sleep(ServerImpl.this.spi.statsPrintFreq);
                ServerImpl.this.printStatistics();
            }
        }
    }

    private class SocketReader
    extends IgniteSpiThread {
        private final Socket sock;
        private volatile UUID nodeId;

        SocketReader(Socket sock) {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-sock-reader-[]", ServerImpl.this.log);
            this.sock = sock;
            this.setPriority(ServerImpl.this.spi.threadPri);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void body() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 50[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void ringMessageReceived() {
            ServerImpl.this.lastRingMsgReceivedTime = U.currentTimeMillis();
        }

        private boolean isConnectionRefused(SocketAddress addr) {
            try (Socket sock = new Socket();){
                sock.connect(addr, 100);
            }
            catch (ConnectException e) {
                return true;
            }
            catch (IOException e) {
                return false;
            }
            return false;
        }

        private void processClientReconnectMessage(TcpDiscoveryClientReconnectMessage msg) {
            UUID nodeId = msg.creatorNodeId();
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            boolean isLocNodeRouter = msg.routerNodeId().equals(locNodeId);
            TcpDiscoveryNode node = ServerImpl.this.ring.node(nodeId);
            assert (node == null || node.clientRouterNodeId() != null);
            if (node != null) {
                node.clientRouterNodeId(msg.routerNodeId());
                node.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
            }
            if (!msg.verified()) {
                if (isLocNodeRouter || ServerImpl.this.isLocalNodeCoordinator()) {
                    if (node != null) {
                        Collection<TcpDiscoveryAbstractMessage> pending = ServerImpl.this.msgHist.messages(msg.lastMessageId(), node, (x$0, x$1) -> ServerImpl.this.clientSupportsDiscoveryMessage(x$0, x$1));
                        if (pending != null) {
                            msg.verify(locNodeId);
                            msg.pendingMessages(pending);
                            msg.success(true);
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Accept client reconnect, restored pending messages [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                            }
                        } else if (!ServerImpl.this.isLocalNodeCoordinator()) {
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Failed to restore pending messages for reconnecting client. Forwarding reconnection message to coordinator [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                            }
                        } else {
                            msg.verify(locNodeId);
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Failing reconnecting client node because failed to restore pending messages [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                            }
                            TcpDiscoveryNodeFailedMessage nodeFailedMsg = new TcpDiscoveryNodeFailedMessage(locNodeId, node.id(), node.internalOrder());
                            ServerImpl.this.msgWorker.addMessage(nodeFailedMsg);
                        }
                    } else {
                        msg.verify(locNodeId);
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Reconnecting client node is already failed [nodeId=" + nodeId + ']');
                        }
                    }
                    if (msg.verified() && isLocNodeRouter) {
                        ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(nodeId);
                        if (wrk != null) {
                            wrk.addMessage(msg);
                        } else if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Failed to reconnect client node (disconnected during the process) [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                        }
                    } else {
                        ServerImpl.this.msgWorker.addMessage(msg);
                    }
                } else {
                    ServerImpl.this.msgWorker.addMessage(msg);
                }
            } else {
                if (ServerImpl.this.isLocalNodeCoordinator()) {
                    ServerImpl.this.msgWorker.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                }
                if (isLocNodeRouter) {
                    ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(nodeId);
                    if (wrk != null) {
                        wrk.addMessage(msg);
                    } else if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Failed to reconnect client node (disconnected during the process) [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                    }
                } else if (ServerImpl.this.ring.hasRemoteNodes() && !ServerImpl.this.isLocalNodeCoordinator()) {
                    ServerImpl.this.msgWorker.addMessage(msg);
                }
            }
        }

        private void processClientMetricsUpdateMessage(TcpDiscoveryClientMetricsUpdateMessage msg) {
            assert (msg.client());
            ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(msg.creatorNodeId());
            if (wrk != null) {
                wrk.metrics(msg.metrics());
            } else if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Received client metrics update message from unknown client node: " + msg);
            }
        }

        private boolean processJoinRequestMessage(TcpDiscoveryJoinRequestMessage msg, @Nullable ClientMessageWorker clientMsgWrk) throws IOException {
            long sockTimeout;
            assert (msg != null);
            assert (!msg.responded());
            TcpDiscoverySpiState state = ServerImpl.this.spiStateCopy();
            long l = sockTimeout = ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.failureDetectionTimeout() : ServerImpl.this.spi.getSocketTimeout();
            if (state == TcpDiscoverySpiState.CONNECTED) {
                TcpDiscoveryNode node = msg.node();
                if (node.clientRouterNodeId() == null && !this.pingJoiningNode(node)) {
                    ServerImpl.this.spi.writeToSocket(msg, this.sock, 255, sockTimeout);
                    return false;
                }
                ServerImpl.this.spi.writeToSocket(msg, this.sock, 1, sockTimeout);
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Responded to join request message [msg=" + msg + ", res=" + 1 + ']');
                }
                msg.responded(true);
                if (clientMsgWrk != null && clientMsgWrk.runner() == null && !clientMsgWrk.isDone()) {
                    clientMsgWrk.clientVersion(U.productVersion(msg.node()));
                    new MessageWorkerThreadWithCleanup(clientMsgWrk, ServerImpl.this.log).start();
                }
                ServerImpl.this.msgWorker.addMessage(msg);
                return true;
            }
            ServerImpl.this.spi.stats.onMessageProcessingStarted(msg);
            SocketAddress rmtAddr = this.sock.getRemoteSocketAddress();
            int res = state == TcpDiscoverySpiState.CONNECTING ? (ServerImpl.this.noResAddrs.contains(rmtAddr) || ServerImpl.this.getLocalNodeId().compareTo(msg.creatorNodeId()) < 0 ? 200 : 100) : 100;
            ServerImpl.this.spi.writeToSocket(msg, this.sock, res, sockTimeout);
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Responded to join request message [msg=" + msg + ", res=" + res + ']');
            }
            ServerImpl.this.fromAddrs.addAll(msg.node().socketAddresses());
            ServerImpl.this.spi.stats.onMessageProcessingFinished(msg);
            return false;
        }

        private boolean pingJoiningNode(TcpDiscoveryNode node) {
            for (InetSocketAddress addr : ServerImpl.this.spi.getNodeAddresses(node, false)) {
                try {
                    IgniteBiTuple t;
                    if (addr.getAddress().isLoopbackAddress() && ServerImpl.this.locNode.socketAddresses().contains(addr) || (t = ServerImpl.this.pingNode(addr, node.id(), null)) == null) continue;
                    return true;
                }
                catch (IgniteCheckedException e) {
                    if (!ServerImpl.this.log.isDebugEnabled()) continue;
                    ServerImpl.this.log.debug("Failed to ping joining node, closing connection. [node=" + node + ", err=" + e.getMessage() + ']');
                }
            }
            U.warn(ServerImpl.this.log, "Failed to ping joining node, closing connection. [node=" + node + ']');
            return false;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            U.closeQuiet(this.sock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cleanup() {
            super.cleanup();
            U.closeQuiet(this.sock);
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                ServerImpl.this.readers.remove(this);
            }
        }

        @Override
        public String toString() {
            return "Socket reader [id=" + this.getId() + ", name=" + this.getName() + ", nodeId=" + this.nodeId + ']';
        }
    }

    private class TcpServer
    extends GridWorker {
        private ServerSocket srvrSock;
        private int port;

        TcpServer(IgniteLogger log) throws IgniteSpiException {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-srvr-[]", log, ServerImpl.getWorkerRegistry(ServerImpl.this.spi));
            int lastPort = ServerImpl.this.spi.locPortRange == 0 ? ServerImpl.this.spi.locPort : ServerImpl.this.spi.locPort + ServerImpl.this.spi.locPortRange - 1;
            this.port = ServerImpl.this.spi.locPort;
            while (this.port <= lastPort) {
                try {
                    ServerSocket serverSocket = this.srvrSock = ServerImpl.this.spi.isSslEnabled() ? ServerImpl.this.spi.sslSrvSockFactory.createServerSocket(this.port, 0, ServerImpl.this.spi.locHost) : new ServerSocket(this.port, 0, ServerImpl.this.spi.locHost);
                    if (log.isInfoEnabled()) {
                        log.info("Successfully bound to TCP port [port=" + this.port + ", localHost=" + ServerImpl.this.spi.locHost + ", locNodeId=" + ServerImpl.this.spi.ignite().configuration().getNodeId() + ']');
                    }
                    return;
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to bind to local port (will try next port within range) [port=" + this.port + ", localHost=" + ServerImpl.this.spi.locHost + ']');
                    }
                    ServerImpl.this.onException("Failed to bind to local port. [port=" + this.port + ", localHost=" + ServerImpl.this.spi.locHost + ']', e);
                    ++this.port;
                }
            }
            throw new IgniteSpiException("Failed to bind TCP server socket (possibly all ports in range are in use) [firstPort=" + ServerImpl.this.spi.locPort + ", lastPort=" + lastPort + ", addr=" + ServerImpl.this.spi.locHost + ']');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() {
            Throwable err = null;
            try {
                U.enhanceThreadName(":" + this.port);
                while (!this.isCancelled()) {
                    Socket sock;
                    this.blockingSectionBegin();
                    try {
                        sock = IgniteUtils.acceptServerSocket(this.srvrSock);
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    long tsNanos = System.nanoTime();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("TCP discovery accepted incoming connection [rmtAddr=" + sock.getInetAddress() + ", rmtPort=" + sock.getPort() + ']');
                    }
                    SocketReader reader = new SocketReader(sock);
                    Object object = ServerImpl.this.mux;
                    synchronized (object) {
                        ServerImpl.this.readers.add(reader);
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("TCP discovery spawning a new thread for connection [rmtAddr=" + sock.getInetAddress() + ", rmtPort=" + sock.getPort() + ']');
                    }
                    reader.start();
                    this.onIdle();
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    U.error(this.log, "Failed to accept TCP connection.", e);
                }
                ServerImpl.this.onException("Failed to accept TCP connection.", e);
                if (!this.runner().isInterrupted()) {
                    err = e;
                    if (U.isMacInvalidArgumentError(e)) {
                        U.error(this.log, "Failed to accept TCP connection\n\tOn MAC OS you may have too many file descriptors open (simple restart usually solves the issue)", e);
                    } else {
                        U.error(this.log, "Failed to accept TCP connection.", e);
                    }
                }
            }
            catch (Throwable t) {
                err = t;
                throw t;
            }
            finally {
                if (ServerImpl.this.spi.ignite() instanceof IgniteEx) {
                    if (err == null && !ServerImpl.this.spi.isNodeStopping0() && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.DISCONNECTING) {
                        err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly.");
                    }
                    FailureProcessor failure = ((IgniteEx)ServerImpl.this.spi.ignite()).context().failure();
                    if (err instanceof OutOfMemoryError) {
                        failure.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                    } else if (err != null) {
                        failure.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                    }
                }
                U.closeQuiet(this.srvrSock);
            }
        }

        public void stop() {
            this.cancel();
            U.close(this.srvrSock, this.log);
            U.join(this, this.log);
        }
    }

    private class TcpServerThread
    extends IgniteSpiThread {
        private final TcpServer worker;

        private TcpServerThread(TcpServer worker, IgniteLogger log) {
            super(worker.igniteInstanceName(), worker.name(), log);
            this.setPriority(ServerImpl.this.spi.threadPri);
            this.worker = worker;
        }

        @Override
        protected void body() throws InterruptedException {
            this.worker.run();
        }
    }

    private class RingMessageWorker
    extends MessageWorker<TcpDiscoveryAbstractMessage> {
        private TcpDiscoveryNode next;
        private final PendingMessages pendingMsgs;
        private final ConcurrentLinkedQueue<FutureTask<Void>> tasks;
        private TcpDiscoveryAbstractMessage lastMsg;
        private boolean forceSndPending;
        private Socket sock;
        private OutputStream out;
        private long lastTimeStatusMsgSentNanos;
        private long metricsCheckFreq;
        private long lastTimeMetricsUpdateMsgSentNanos;
        private long lastTimeConnCheckMsgSent;
        private boolean failureThresholdReached;
        private long connCheckThreshold;
        private long lastRingMsgTimeNanos;
        private List<DiscoveryDataPacket> joiningNodesDiscoDataList;
        private DiscoveryDataPacket gridDiscoveryData;
        private final ThreadLocal<Boolean> notifiedDiscovery;
        private final MetricsUpdateMessageFilter metricsMsgFilter;

        private RingMessageWorker(IgniteLogger log) {
            super("tcp-disco-msg-worker-[]", log, 10L, ServerImpl.getWorkerRegistry(ServerImpl.this.spi));
            this.pendingMsgs = new PendingMessages();
            this.tasks = new ConcurrentLinkedQueue();
            this.metricsCheckFreq = 3L * ServerImpl.this.spi.metricsUpdateFreq + 50L;
            this.lastTimeMetricsUpdateMsgSentNanos = System.nanoTime() - U.millisToNanos(ServerImpl.this.spi.metricsUpdateFreq);
            this.notifiedDiscovery = ThreadLocal.withInitial(() -> false);
            this.metricsMsgFilter = new MetricsUpdateMessageFilter();
            this.initConnectionCheckThreshold();
            this.setBeforeEachPollAction(() -> {
                this.updateHeartbeat();
                this.onIdle();
                this.runTasks();
            });
        }

        FutureTask<Void> addTask(FutureTask<Void> task) {
            this.tasks.add(task);
            this.addMessage(WAKEUP);
            return task;
        }

        void addMessage(TcpDiscoveryAbstractMessage msg) {
            this.addMessage(msg, false, false);
        }

        void addMessage(TcpDiscoveryAbstractMessage msg, boolean ignoreHighPriority) {
            this.addMessage(msg, ignoreHighPriority, false);
        }

        void addMessage(TcpDiscoveryAbstractMessage msg, boolean ignoreHighPriority, boolean fromSocket) {
            boolean addFirst;
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if ((msg instanceof TcpDiscoveryStatusCheckMessage || msg instanceof TcpDiscoveryJoinRequestMessage || msg instanceof TcpDiscoveryCustomEventMessage || msg instanceof TcpDiscoveryClientReconnectMessage) && this.queue.contains(msg)) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring duplicate message: " + msg);
                }
                return;
            }
            if (msg instanceof TraceableMessage) {
                TraceableMessage tMsg = (TraceableMessage)((Object)msg);
                if (fromSocket) {
                    ServerImpl.this.tracing.messages().afterReceive(tMsg);
                } else if (!msg.verified() && tMsg.spanContainer().serializedSpanBytes() == null) {
                    Span rootSpan = ServerImpl.this.tracing.create(TraceableMessagesTable.traceName(tMsg.getClass())).end();
                    tMsg.spanContainer().serializedSpanBytes(ServerImpl.this.tracing.serialize(rootSpan));
                }
            }
            boolean bl = addFirst = msg.highPriority() && !ignoreHighPriority;
            if (msg instanceof TcpDiscoveryMetricsUpdateMessage) {
                if (this.metricsMsgFilter.addMessage((TcpDiscoveryMetricsUpdateMessage)msg)) {
                    this.addToQueue(msg, addFirst);
                } else if (log.isDebugEnabled()) {
                    log.debug("Metric update message has been replaced in the worker's queue: " + msg);
                }
            } else {
                this.addToQueue(msg, addFirst);
            }
        }

        private void addToQueue(TcpDiscoveryAbstractMessage msg, boolean addFirst) {
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if (addFirst) {
                this.queue.addFirst(msg);
                if (log.isDebugEnabled()) {
                    log.debug("Message has been added to a head of a worker's queue: " + msg);
                }
            } else {
                this.queue.add(msg);
                if (log.isDebugEnabled()) {
                    log.debug("Message has been added to a worker's queue: " + msg);
                }
            }
        }

        @Override
        protected void body() throws InterruptedException {
            Throwable err = null;
            try {
                super.body();
            }
            catch (InterruptedException e) {
                if (!ServerImpl.this.spi.isNodeStopping0() && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.DISCONNECTING) {
                    err = e;
                }
                throw e;
            }
            catch (Throwable e) {
                Ignite ignite;
                if (!ServerImpl.this.spi.isNodeStopping0() && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.DISCONNECTING && (ignite = ServerImpl.this.spi.ignite()) != null) {
                    U.error(this.log, "TcpDiscoverSpi's message worker thread failed abnormally. Stopping the node in order to prevent cluster wide instability.", e);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IgnitionEx.stop(ignite.name(), true, ShutdownPolicy.IMMEDIATE, true);
                                U.log(RingMessageWorker.this.log, "Stopped the node successfully in response to TcpDiscoverySpi's message worker thread abnormal termination.");
                            }
                            catch (Throwable e) {
                                U.error(RingMessageWorker.this.log, "Failed to stop the node in response to TcpDiscoverySpi's message worker thread abnormal termination.", e);
                            }
                        }
                    }, "node-stop-thread").start();
                }
                err = e;
                throw e;
            }
            finally {
                if (ServerImpl.this.spi.ignite() instanceof IgniteEx) {
                    if (err == null && !ServerImpl.this.spi.isNodeStopping0() && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.DISCONNECTING) {
                        err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly.");
                    }
                    FailureProcessor failure = ((IgniteEx)ServerImpl.this.spi.ignite()).context().failure();
                    if (err instanceof OutOfMemoryError) {
                        failure.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                    } else if (err != null) {
                        failure.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                    }
                }
            }
        }

        private void nullifyDiscoData() {
            this.gridDiscoveryData = null;
            this.joiningNodesDiscoDataList = null;
        }

        private void initConnectionCheckThreshold() {
            this.connCheckThreshold = ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.failureDetectionTimeout() : Math.min(ServerImpl.this.spi.getSocketTimeout(), ServerImpl.this.spi.metricsUpdateFreq);
            if (this.log.isInfoEnabled()) {
                this.log.info("Connection check threshold is calculated: " + this.connCheckThreshold);
            }
        }

        protected void runTasks() {
            FutureTask<Void> task;
            while ((task = this.tasks.poll()) != null) {
                task.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processMessage(TcpDiscoveryAbstractMessage msg) {
            Object tMsg;
            if (msg == WAKEUP) {
                return;
            }
            this.notifiedDiscovery.set(false);
            if (msg instanceof TraceableMessage) {
                tMsg = (TraceableMessage)((Object)msg);
                ServerImpl.this.tracing.messages().afterReceive((TraceableMessage)tMsg);
            }
            ServerImpl.this.spi.startMessageProcess(msg);
            this.sendMetricsUpdateMessage();
            tMsg = ServerImpl.this.mux;
            synchronized (tMsg) {
                if (ServerImpl.this.spiState == TcpDiscoverySpiState.RING_FAILED) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discovery detected ring connectivity issues and will stop local node, ignoring message [msg=" + msg + ", locNode=" + ServerImpl.this.locNode + ']');
                    }
                    if (msg instanceof TraceableMessage) {
                        ((TraceableMessage)((Object)msg)).spanContainer().span().addLog(() -> "Ring failed").setStatus(SpanStatus.ABORTED).end();
                    }
                    return;
                }
            }
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if (log.isDebugEnabled()) {
                log.debug("Processing message [cls=" + msg.getClass().getSimpleName() + ", id=" + msg.id() + ']');
            }
            if (ServerImpl.this.debugMode) {
                ServerImpl.this.debugLog(msg, "Processing message [cls=" + msg.getClass().getSimpleName() + ", id=" + msg.id() + ']');
            }
            boolean ensured = ServerImpl.this.spi.ensured(msg);
            if (!ServerImpl.this.locNode.id().equals(msg.senderNodeId()) && ensured) {
                this.lastRingMsgTimeNanos = System.nanoTime();
            }
            if (ServerImpl.this.locNode.internalOrder() == 0L) {
                boolean proc = false;
                if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                    proc = ((TcpDiscoveryNodeAddedMessage)msg).node().equals(ServerImpl.this.locNode);
                }
                if (!proc) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignore message, local node order is not initialized [msg=" + msg + ", locNode=" + ServerImpl.this.locNode + ']');
                    }
                    if (msg instanceof TraceableMessage) {
                        ((TraceableMessage)((Object)msg)).spanContainer().span().addLog(() -> "Local node order not initialized").setStatus(SpanStatus.ABORTED).end();
                    }
                    return;
                }
            }
            ServerImpl.this.spi.stats.onMessageProcessingStarted(msg);
            ServerImpl.this.processMessageFailedNodes(msg);
            if (msg instanceof TcpDiscoveryJoinRequestMessage) {
                this.processJoinRequestMessage((TcpDiscoveryJoinRequestMessage)msg);
            } else if (msg instanceof TcpDiscoveryClientReconnectMessage) {
                if (this.sendMessageToRemotes(msg)) {
                    this.sendMessageAcrossRing(msg);
                }
            } else if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                this.processNodeAddedMessage((TcpDiscoveryNodeAddedMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeAddFinishedMessage) {
                this.processNodeAddFinishedMessage((TcpDiscoveryNodeAddFinishedMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeLeftMessage) {
                this.processNodeLeftMessage((TcpDiscoveryNodeLeftMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeFailedMessage) {
                this.processNodeFailedMessage((TcpDiscoveryNodeFailedMessage)msg);
            } else if (msg instanceof TcpDiscoveryMetricsUpdateMessage) {
                this.processMetricsUpdateMessage((TcpDiscoveryMetricsUpdateMessage)msg);
            } else if (msg instanceof TcpDiscoveryStatusCheckMessage) {
                this.processStatusCheckMessage((TcpDiscoveryStatusCheckMessage)msg);
            } else if (msg instanceof TcpDiscoveryDiscardMessage) {
                this.processDiscardMessage((TcpDiscoveryDiscardMessage)msg);
            } else if (msg instanceof TcpDiscoveryCustomEventMessage) {
                this.processCustomMessage((TcpDiscoveryCustomEventMessage)msg, false);
            } else if (msg instanceof TcpDiscoveryClientPingRequest) {
                this.processClientPingRequest((TcpDiscoveryClientPingRequest)msg);
            } else if (msg instanceof TcpDiscoveryRingLatencyCheckMessage) {
                this.processRingLatencyCheckMessage((TcpDiscoveryRingLatencyCheckMessage)msg);
            } else if (msg instanceof TcpDiscoveryAuthFailedMessage) {
                this.processAuthFailedMessage((TcpDiscoveryAuthFailedMessage)msg);
            } else assert (false) : "Unknown message type: " + msg.getClass().getSimpleName();
            if (msg.senderNodeId() != null && !msg.senderNodeId().equals(ServerImpl.this.getLocalNodeId())) {
                ServerImpl.this.onMessageExchanged();
                this.failureThresholdReached = false;
            }
            if (this.next != null && this.sock != null && (msg instanceof TcpDiscoveryNodeLeftMessage || msg instanceof TcpDiscoveryNodeFailedMessage || msg instanceof TcpDiscoveryNodeAddFinishedMessage || msg instanceof TcpDiscoveryNodeAddedMessage)) {
                U.enhanceThreadName(U.id8(this.next.id()) + ' ' + this.sock.getInetAddress().getHostAddress() + ":" + this.sock.getPort() + (ServerImpl.this.isLocalNodeCoordinator() ? " crd" : ""));
            }
            ServerImpl.this.spi.stats.onMessageProcessingFinished(msg);
            if (msg instanceof TraceableMessage && (msg instanceof TcpDiscoveryNodeAddedMessage || msg instanceof TcpDiscoveryJoinRequestMessage || this.notifiedDiscovery.get().booleanValue())) {
                TraceableMessage tMsg2 = (TraceableMessage)((Object)msg);
                ServerImpl.this.tracing.messages().finishProcessing(tMsg2);
            }
        }

        private void processAuthFailedMessage(TcpDiscoveryAuthFailedMessage authFailedMsg) {
            try {
                this.sendDirectlyToClient(authFailedMsg.getTargetNodeId(), authFailedMsg);
            }
            catch (IgniteSpiException ex) {
                this.log.warning("Skipping send auth failed message to client due to some trouble with connection detected: " + ex.getMessage());
            }
        }

        @Override
        protected void noMessageLoop() {
            if (ServerImpl.this.locNode == null) {
                return;
            }
            this.checkConnection();
            this.sendMetricsUpdateMessage();
            this.checkMetricsReceiving();
            this.checkPendingCustomMessages();
            this.checkFailedNodesList();
        }

        private void sendMessageToClients(TcpDiscoveryAbstractMessage msg) {
            if (this.redirectToClients(msg)) {
                if (ServerImpl.this.spi.ensured(msg)) {
                    ServerImpl.this.msgHist.add(msg);
                }
                byte[] msgBytes = null;
                for (ClientMessageWorker clientMsgWorker : ServerImpl.this.clientMsgWorkers.values()) {
                    if (msg instanceof TcpDiscoveryCustomEventMessage) {
                        try {
                            if (!ServerImpl.this.clientSupportsDiscoveryMessage(msg, clientMsgWorker.clientNodeId)) {
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            U.error(this.log, "Failed when unmarshalling a message: " + msg, e);
                            break;
                        }
                    }
                    if (msgBytes == null) {
                        try {
                            msgBytes = U.marshal(ServerImpl.this.spi.marshaller(), (Object)msg);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.log, "Failed to marshal message: " + msg, e);
                            break;
                        }
                    }
                    TcpDiscoveryAbstractMessage msg0 = msg;
                    byte[] msgBytes0 = msgBytes;
                    if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                        TcpDiscoveryNodeAddedMessage nodeAddedMsg = (TcpDiscoveryNodeAddedMessage)msg;
                        TcpDiscoveryNode node = nodeAddedMsg.node();
                        if (clientMsgWorker.clientNodeId.equals(node.id())) {
                            try {
                                msg0 = (TcpDiscoveryAbstractMessage)U.unmarshal(ServerImpl.this.spi.marshaller(), msgBytes, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                                ServerImpl.this.prepareNodeAddedMessage(msg0, clientMsgWorker.clientNodeId, null, null);
                                msgBytes0 = null;
                            }
                            catch (IgniteCheckedException e) {
                                U.error(this.log, "Failed to create message copy: " + msg, e);
                            }
                        }
                    }
                    clientMsgWorker.addMessage(msg0, msgBytes0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessageAcrossRing(TcpDiscoveryAbstractMessage msg) {
            TcpDiscoverySpiState state;
            List<TcpDiscoveryNode> failedNodes;
            assert (msg != null);
            assert (ServerImpl.this.ring.hasRemoteNodes());
            for (IgniteInClosure<TcpDiscoveryAbstractMessage> msgLsnr : ServerImpl.this.spi.sndMsgLsnrs) {
                msgLsnr.apply(msg);
            }
            if (msg instanceof TraceableMessage) {
                ServerImpl.this.tracing.messages().beforeSend((TraceableMessage)((Object)msg));
            }
            this.sendMessageToClients(msg);
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                failedNodes = U.arrayList(ServerImpl.this.failedNodes.keySet());
                state = ServerImpl.this.spiState;
            }
            ArrayList<Throwable> errs = null;
            boolean sent = false;
            boolean newNextNode = false;
            CrossRingMessageSendState sndState = null;
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            block38: while (true) {
                boolean failedNextNode;
                TcpDiscoveryNode newNext;
                if ((newNext = ServerImpl.this.ring.nextNode(failedNodes)) == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("No next node in topology.");
                    }
                    if (ServerImpl.this.debugMode) {
                        ServerImpl.this.debugLog(msg, "No next node in topology.");
                    }
                    if (!ServerImpl.this.ring.hasRemoteNodes() || msg instanceof TcpDiscoveryConnectionCheckMessage || msg instanceof TcpDiscoveryStatusCheckMessage && msg.creatorNodeId().equals(locNodeId)) break;
                    msg.senderNodeId(locNodeId);
                    this.addMessage(msg, true);
                    break;
                }
                if (!newNext.equals(this.next)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("New next node [newNext=" + newNext + ", formerNext=" + this.next + ", ring=" + ServerImpl.this.ring + ", failedNodes=" + failedNodes + ']');
                    } else if (this.log.isInfoEnabled()) {
                        this.log.info("New next node [newNext=" + newNext + ']');
                    }
                    if (ServerImpl.this.debugMode) {
                        ServerImpl.this.debugLog(msg, "New next node [newNext=" + newNext + ", formerNext=" + this.next + ", ring=" + ServerImpl.this.ring + ", failedNodes=" + failedNodes + ']');
                    }
                    U.closeQuiet(this.sock);
                    this.sock = null;
                    this.next = newNext;
                    newNextNode = true;
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("Next node remains the same [nextId=" + this.next.id() + ", nextOrder=" + this.next.internalOrder() + ']');
                }
                boolean sameHost = U.sameMacs(ServerImpl.this.locNode, this.next);
                List locNodeAddrs = U.arrayList(ServerImpl.this.locNode.socketAddresses());
                block39: for (InetSocketAddress addr : ServerImpl.this.spi.getNodeAddresses(this.next, sameHost)) {
                    long ackTimeout0 = ServerImpl.this.spi.getAckTimeout();
                    if (locNodeAddrs.contains(addr)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skip to send message to the local node (probably remote node has the same loopback address that local node): " + addr);
                        continue;
                    }
                    int reconCnt = 0;
                    IgniteSpiOperationTimeoutHelper timeoutHelper = null;
                    while (true) {
                        block120: {
                            if (this.sock == null) {
                                if (timeoutHelper == null) {
                                    timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                                }
                                boolean success = false;
                                boolean openSock = false;
                                try {
                                    boolean changeTop;
                                    long tsNanos = System.nanoTime();
                                    this.sock = ServerImpl.this.spi.openSocket(addr, timeoutHelper);
                                    this.out = ServerImpl.this.spi.socketStream(this.sock);
                                    openSock = true;
                                    TcpDiscoveryHandshakeRequest hndMsg = new TcpDiscoveryHandshakeRequest(locNodeId);
                                    boolean bl = changeTop = sndState != null && !sndState.isStartingPoint();
                                    if (changeTop) {
                                        hndMsg.changeTopology(ServerImpl.this.ring.previousNodeOf(this.next).id());
                                    }
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Sending handshake [hndMsg=" + hndMsg + ", sndState=" + sndState + ']');
                                    }
                                    ServerImpl.this.spi.writeToSocket(this.sock, this.out, hndMsg, timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getSocketTimeout()));
                                    TcpDiscoveryHandshakeResponse res = (TcpDiscoveryHandshakeResponse)ServerImpl.this.spi.readMessage(this.sock, null, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Handshake response: " + res);
                                    }
                                    if (res.creatorNodeId().equals(this.next.id()) && res.previousNodeAlive() && sndState != null) {
                                        boolean previousNode = sndState.markLastFailedNodeAlive();
                                        if (previousNode) {
                                            failedNodes.remove(failedNodes.size() - 1);
                                        } else {
                                            newNextNode = false;
                                            this.next = ServerImpl.this.ring.nextNode(failedNodes);
                                        }
                                        U.closeQuiet(this.sock);
                                        this.sock = null;
                                        if (sndState.isFailed()) {
                                            this.segmentLocalNodeOnSendFail(failedNodes);
                                            return;
                                        }
                                        if (!previousNode) continue block38;
                                        U.warn(this.log, "New next node has connection to it's previous, trying previous again. [next=" + this.next + ']');
                                        continue block38;
                                    }
                                    if (locNodeId.equals(res.creatorNodeId())) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Handshake response from local node: " + res);
                                        }
                                        U.closeQuiet(this.sock);
                                        this.sock = null;
                                        continue block39;
                                    }
                                    UUID nextId = res.creatorNodeId();
                                    long nextOrder = res.order();
                                    if (!this.next.id().equals(nextId)) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Failed to restore ring because next node ID received is not as expected [expectedId=" + this.next.id() + ", rcvdId=" + nextId + ']');
                                        }
                                        if (!ServerImpl.this.debugMode) continue block39;
                                        ServerImpl.this.debugLog(msg, "Failed to restore ring because next node ID received is not as expected [expectedId=" + this.next.id() + ", rcvdId=" + nextId + ']');
                                        continue block39;
                                    }
                                    if (nextOrder != this.next.internalOrder()) {
                                        boolean nextNew;
                                        boolean bl2 = nextNew = msg instanceof TcpDiscoveryNodeAddedMessage && ((TcpDiscoveryNodeAddedMessage)msg).node().id().equals(nextId);
                                        if (!nextNew) {
                                            nextNew = this.hasPendingAddMessage(nextId);
                                        }
                                        if (!nextNew) {
                                            if (this.log.isDebugEnabled()) {
                                                this.log.debug("Failed to restore ring because next node order received is not as expected [expected=" + this.next.internalOrder() + ", rcvd=" + nextOrder + ", id=" + this.next.id() + ']');
                                            }
                                            if (!ServerImpl.this.debugMode) continue block39;
                                            ServerImpl.this.debugLog(msg, "Failed to restore ring because next node order received is not as expected [expected=" + this.next.internalOrder() + ", rcvd=" + nextOrder + ", id=" + this.next.id() + ']');
                                            continue block39;
                                        }
                                    }
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Initialized connection with next node: " + this.next.id());
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Initialized connection with next node: " + this.next.id());
                                    }
                                    errs = null;
                                    success = true;
                                    this.next.lastSuccessfulAddress(addr);
                                }
                                catch (IOException | IgniteCheckedException e) {
                                    if (errs == null) {
                                        errs = new ArrayList();
                                    }
                                    errs.add(e);
                                    if (this.log.isDebugEnabled()) {
                                        U.error(this.log, "Failed to connect to next node [msg=" + msg + ", err=" + e.getMessage() + ']', e);
                                    }
                                    ServerImpl.this.onException("Failed to connect to next node [msg=" + msg + ", err=" + e + ']', e);
                                    if (openSock && (ServerImpl.this.spi.failureDetectionTimeoutEnabled() || ++reconCnt != ServerImpl.this.spi.getReconnectCount()) && !timeoutHelper.checkFailureTimeoutReached(e) && (ServerImpl.this.spi.failureDetectionTimeoutEnabled() || !(e instanceof SocketTimeoutException) && !X.hasCause((Throwable)e, SocketTimeoutException.class) || ServerImpl.this.checkAckTimeout(ackTimeout0 *= 2L))) continue;
                                    continue block39;
                                }
                                finally {
                                    if (!success) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Closing socket to next: " + this.next);
                                        }
                                        U.closeQuiet(this.sock);
                                        this.sock = null;
                                        continue block39;
                                    }
                                    timeoutHelper = null;
                                    continue block39;
                                }
                            }
                            try {
                                boolean failure;
                                Iterator<TcpDiscoveryAbstractMessage> openSock = ServerImpl.this.mux;
                                synchronized (openSock) {
                                    failure = ServerImpl.this.failedNodes.size() < failedNodes.size();
                                }
                                assert (!this.forceSndPending || msg instanceof TcpDiscoveryNodeLeftMessage);
                                if (failure || this.forceSndPending || newNextNode) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Pending messages will be sent [failure=" + failure + ", newNextNode=" + newNextNode + ", forceSndPending=" + this.forceSndPending + ", failedNodes=" + failedNodes + ']');
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Pending messages will be sent [failure=" + failure + ", newNextNode=" + newNextNode + ", forceSndPending=" + this.forceSndPending + ", failedNodes=" + failedNodes + ']');
                                    }
                                    for (TcpDiscoveryAbstractMessage pendingMsg : this.pendingMsgs) {
                                        long tsNanos = System.nanoTime();
                                        ServerImpl.this.prepareNodeAddedMessage(pendingMsg, this.next.id(), this.pendingMsgs.msgs, this.pendingMsgs.customDiscardId);
                                        this.addFailedNodes(pendingMsg, failedNodes);
                                        if (timeoutHelper == null) {
                                            timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                                        }
                                        try {
                                            ServerImpl.this.spi.writeToSocket(this.sock, this.out, pendingMsg, timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getSocketTimeout()));
                                        }
                                        finally {
                                            ServerImpl.this.clearNodeAddedMessage(pendingMsg);
                                        }
                                        long tsNanos0 = System.nanoTime();
                                        int res = ServerImpl.this.spi.readReceipt(this.sock, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                                        ServerImpl.this.spi.stats.onMessageSent(pendingMsg, U.nanosToMillis(tsNanos0 - tsNanos));
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Pending message has been sent to next node [msgId=" + msg.id() + ", pendingMsgId=" + pendingMsg.id() + ", next=" + this.next.id() + ", res=" + res + ']');
                                        }
                                        if (ServerImpl.this.debugMode) {
                                            ServerImpl.this.debugLog(msg, "Pending message has been sent to next node [msgId=" + msg.id() + ", pendingMsgId=" + pendingMsg.id() + ", next=" + this.next.id() + ", res=" + res + ']');
                                        }
                                        timeoutHelper = null;
                                    }
                                }
                                if (!(msg instanceof TcpDiscoveryConnectionCheckMessage)) {
                                    ServerImpl.this.prepareNodeAddedMessage(msg, this.next.id(), this.pendingMsgs.msgs, this.pendingMsgs.customDiscardId);
                                }
                                try {
                                    SecurityUtils.serializeVersion(1);
                                    long tsNanos = System.nanoTime();
                                    if (timeoutHelper == null) {
                                        timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                                    }
                                    this.addFailedNodes(msg, failedNodes);
                                    boolean latencyCheck = msg instanceof TcpDiscoveryRingLatencyCheckMessage;
                                    if (latencyCheck && this.log.isInfoEnabled()) {
                                        this.log.info("Latency check message has been written to socket: " + msg.id());
                                    }
                                    ServerImpl.this.spi.writeToSocket(newNextNode ? newNext : this.next, this.sock, this.out, msg, timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getSocketTimeout()));
                                    long tsNanos0 = System.nanoTime();
                                    int res = ServerImpl.this.spi.readReceipt(this.sock, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                                    if (latencyCheck && this.log.isInfoEnabled()) {
                                        this.log.info("Latency check message has been acked: " + msg.id());
                                    }
                                    ServerImpl.this.spi.stats.onMessageSent(msg, U.nanosToMillis(tsNanos0 - tsNanos));
                                    ServerImpl.this.onMessageExchanged();
                                    TcpDiscoveryImpl.DebugLogger debugLog = ServerImpl.this.messageLogger(msg);
                                    if (debugLog.isDebugEnabled()) {
                                        debugLog.debug("Message has been sent to next node [msg=" + msg + ", next=" + this.next.id() + ", res=" + res + ']');
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Message has been sent to next node [msg=" + msg + ", next=" + this.next.id() + ", res=" + res + ']');
                                    }
                                }
                                finally {
                                    SecurityUtils.restoreDefaultSerializeVersion();
                                    ServerImpl.this.clearNodeAddedMessage(msg);
                                }
                                this.registerPendingMessage(msg);
                                sent = true;
                                this.forceSndPending = false;
                                if (sent) break block39;
                                if (!this.log.isDebugEnabled()) break block120;
                                this.log.debug("Closing socket to next (not sent): " + this.next);
                            }
                            catch (IOException | IgniteCheckedException e) {
                                block123: {
                                    block126: {
                                        block124: {
                                            block125: {
                                                block121: {
                                                    block122: {
                                                        try {
                                                            if (errs == null) {
                                                                errs = new ArrayList<Throwable>();
                                                            }
                                                            errs.add(e);
                                                            if (this.log.isDebugEnabled()) {
                                                                U.error(this.log, "Failed to send message to next node [next=" + this.next.id() + ", msg=" + msg + ", err=" + e + ']', e);
                                                            }
                                                            ServerImpl.this.onException("Failed to send message to next node [next=" + this.next.id() + ", msg=" + msg + ']', e);
                                                            if (!timeoutHelper.checkFailureTimeoutReached(e)) break block121;
                                                            this.forceSndPending = false;
                                                            if (sent) continue block39;
                                                            if (!this.log.isDebugEnabled()) break block122;
                                                            this.log.debug("Closing socket to next (not sent): " + this.next);
                                                        }
                                                        catch (Throwable throwable) {
                                                            this.forceSndPending = false;
                                                            if (!sent) {
                                                                if (this.log.isDebugEnabled()) {
                                                                    this.log.debug("Closing socket to next (not sent): " + this.next);
                                                                }
                                                                U.closeQuiet(this.sock);
                                                                this.sock = null;
                                                                if (this.log.isDebugEnabled()) {
                                                                    this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                                                }
                                                            }
                                                            throw throwable;
                                                        }
                                                    }
                                                    U.closeQuiet(this.sock);
                                                    this.sock = null;
                                                    if (!this.log.isDebugEnabled()) continue block39;
                                                    this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                                    continue block39;
                                                }
                                                if (ServerImpl.this.spi.failureDetectionTimeoutEnabled()) break block123;
                                                if (++reconCnt != ServerImpl.this.spi.getReconnectCount()) break block124;
                                                this.forceSndPending = false;
                                                if (sent) continue block39;
                                                if (!this.log.isDebugEnabled()) break block125;
                                                this.log.debug("Closing socket to next (not sent): " + this.next);
                                            }
                                            U.closeQuiet(this.sock);
                                            this.sock = null;
                                            if (!this.log.isDebugEnabled()) continue block39;
                                            this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                            continue block39;
                                        }
                                        if (!(e instanceof SocketTimeoutException) && !X.hasCause((Throwable)e, SocketTimeoutException.class) || ServerImpl.this.checkAckTimeout(ackTimeout0 *= 2L)) break block123;
                                        this.forceSndPending = false;
                                        if (sent) continue block39;
                                        if (!this.log.isDebugEnabled()) break block126;
                                        this.log.debug("Closing socket to next (not sent): " + this.next);
                                    }
                                    U.closeQuiet(this.sock);
                                    this.sock = null;
                                    if (!this.log.isDebugEnabled()) continue block39;
                                    this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                    continue block39;
                                }
                                this.forceSndPending = false;
                                if (sent) continue;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Closing socket to next (not sent): " + this.next);
                                }
                                U.closeQuiet(this.sock);
                                this.sock = null;
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                continue;
                            }
                        }
                        U.closeQuiet(this.sock);
                        this.sock = null;
                        if (!this.log.isDebugEnabled()) break block39;
                        this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                        break block39;
                        break;
                    }
                }
                if (sent) break;
                if (sndState == null && ServerImpl.this.spi.getEffectiveConnectionRecoveryTimeout() > 0L) {
                    sndState = new CrossRingMessageSendState();
                }
                boolean bl = failedNextNode = sndState == null || sndState.markNextNodeFailed();
                if (failedNextNode && !failedNodes.contains(this.next)) {
                    failedNodes.add(this.next);
                    if (state == TcpDiscoverySpiState.CONNECTED) {
                        IgniteCheckedException err = errs != null ? U.exceptionWithSuppressed("Failed to send message to next node [msg=" + msg + ", next=" + U.toShortString(this.next) + ']', errs) : null;
                        U.warn(this.log, "Failed to send message to next node [msg=" + msg + ", next=" + this.next + ", errMsg=" + (err != null ? err.getMessage() : "N/A") + ']');
                    }
                } else if (!failedNextNode && sndState != null && sndState.isBackward()) {
                    boolean prev = sndState.markLastFailedNodeAlive();
                    U.warn(this.log, "Failed to send message to next node, try previous [msg=" + msg + ", next=" + this.next + ']');
                    if (prev) {
                        failedNodes.remove(failedNodes.size() - 1);
                    } else {
                        newNextNode = false;
                        this.next = ServerImpl.this.ring.nextNode(failedNodes);
                    }
                }
                if (sndState != null && sndState.isFailed()) {
                    this.segmentLocalNodeOnSendFail(failedNodes);
                    return;
                }
                this.next = null;
                errs = null;
            }
            Iterator<TcpDiscoveryNode> iterator = ServerImpl.this.mux;
            synchronized (iterator) {
                failedNodes.removeAll(ServerImpl.this.failedNodes.keySet());
            }
            if (!failedNodes.isEmpty()) {
                if (state == TcpDiscoverySpiState.CONNECTED) {
                    if (!sent && this.log.isDebugEnabled()) {
                        this.log.debug("Message has not been sent: " + msg);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Detected failed nodes: " + failedNodes);
                    }
                }
                iterator = ServerImpl.this.mux;
                synchronized (iterator) {
                    for (TcpDiscoveryNode failedNode : failedNodes) {
                        if (ServerImpl.this.failedNodes.containsKey(failedNode)) continue;
                        ServerImpl.this.failedNodes.put(failedNode, locNodeId);
                    }
                    for (TcpDiscoveryNode failedNode : failedNodes) {
                        ServerImpl.this.failedNodesMsgSent.add(failedNode.id());
                    }
                }
                for (TcpDiscoveryNode n : failedNodes) {
                    ServerImpl.this.msgWorker.addMessage(new TcpDiscoveryNodeFailedMessage(locNodeId, n.id(), n.internalOrder()));
                }
                if (!sent) {
                    assert (this.next == null) : this.next;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Pending messages will be resent to local node");
                    }
                    if (ServerImpl.this.debugMode) {
                        ServerImpl.this.debugLog(msg, "Pending messages will be resent to local node");
                    }
                    this.processPendingMessagesLocally(msg);
                }
                LT.warn(this.log, "Local node has detected failed nodes and started cluster-wide procedure. To speed up failure detection please see 'Failure Detection' section under javadoc for 'TcpDiscoverySpi'");
            }
        }

        private void processPendingMessagesLocally(TcpDiscoveryAbstractMessage curMsg) {
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            for (TcpDiscoveryAbstractMessage pendingMsg : this.pendingMsgs) {
                ServerImpl.this.prepareNodeAddedMessage(pendingMsg, locNodeId, this.pendingMsgs.msgs, this.pendingMsgs.customDiscardId);
                pendingMsg.senderNodeId(locNodeId);
                ServerImpl.this.msgWorker.addMessage(pendingMsg);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Pending message has been sent to local node [msg=" + curMsg.id() + ", pendingMsg=" + pendingMsg + ']');
                }
                if (!ServerImpl.this.debugMode) continue;
                ServerImpl.this.debugLog(curMsg, "Pending message has been sent to local node [msg=" + curMsg.id() + ", pendingMsg=" + pendingMsg + ']');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void segmentLocalNodeOnSendFail(List<TcpDiscoveryNode> failedNodes) {
            String failedNodesStr = failedNodes == null ? "" : ", failedNodes=" + failedNodes;
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                if (ServerImpl.this.spiState == TcpDiscoverySpiState.CONNECTING) {
                    U.warn(this.log, "Unable to connect to next nodes in a ring, it seems local node is experiencing connectivity issues or the rest of the cluster is undergoing massive restarts. Failing local node join to avoid case when one node fails a big part of cluster. To disable this behavior set TcpDiscoverySpi.setConnectionRecoveryTimeout() to 0. [connRecoveryTimeout=" + ServerImpl.this.spi.connRecoveryTimeout + ", effectiveConnRecoveryTimeout=" + ServerImpl.this.spi.getEffectiveConnectionRecoveryTimeout() + failedNodesStr + ']');
                    ServerImpl.this.spiState = TcpDiscoverySpiState.RING_FAILED;
                    ServerImpl.this.mux.notifyAll();
                    return;
                }
            }
            U.warn(this.log, "Unable to connect to next nodes in a ring, it seems local node is experiencing connectivity issues. Segmenting local node to avoid case when one node fails a big part of cluster. To disable this behavior set TcpDiscoverySpi.setConnectionRecoveryTimeout() to 0. [connRecoveryTimeout=" + ServerImpl.this.spi.connRecoveryTimeout + ", effectiveConnRecoveryTimeout=" + ServerImpl.this.spi.getEffectiveConnectionRecoveryTimeout() + failedNodesStr + ']');
            ServerImpl.this.notifyDiscovery(14, ServerImpl.this.ring.topologyVersion(), ServerImpl.this.locNode);
        }

        private void addFailedNodes(TcpDiscoveryAbstractMessage msg, Collection<TcpDiscoveryNode> failedNodes) {
            if (!failedNodes.isEmpty()) {
                for (TcpDiscoveryNode failedNode : failedNodes) {
                    assert (!failedNode.equals(this.next)) : failedNode;
                    msg.addFailedNode(failedNode.id());
                }
            }
        }

        private boolean redirectToClients(TcpDiscoveryAbstractMessage msg) {
            return msg.verified() && U.hasDeclaredAnnotation(msg, TcpDiscoveryRedirectToClient.class);
        }

        private void registerPendingMessage(TcpDiscoveryAbstractMessage msg) {
            assert (msg != null);
            if (ServerImpl.this.spi.ensured(msg)) {
                this.pendingMsgs.add(msg);
                ServerImpl.this.spi.stats.onPendingMessageRegistered();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Pending message has been registered: " + msg.id());
                }
            }
        }

        private boolean hasPendingAddMessage(UUID nodeId) {
            if (this.pendingMsgs.msgs.isEmpty()) {
                return false;
            }
            for (PendingMessage pendingMsg : this.pendingMsgs.msgs) {
                TcpDiscoveryNodeAddedMessage addMsg;
                if (!(pendingMsg.msg instanceof TcpDiscoveryNodeAddedMessage) || !(addMsg = (TcpDiscoveryNodeAddedMessage)pendingMsg.msg).node().id().equals(nodeId) || addMsg.id().compareTo(this.pendingMsgs.discardId) <= 0) continue;
                return true;
            }
            return false;
        }

        private void processJoinRequestMessage(final TcpDiscoveryJoinRequestMessage msg) {
            assert (msg != null);
            final TcpDiscoveryNode node = msg.node();
            final UUID locNodeId = ServerImpl.this.getLocalNodeId();
            msg.spanContainer().span().addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> node.id().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> node.consistentId().toString());
            if (locNodeId.equals(node.id())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received join request for local node, dropping: " + msg);
                }
                msg.spanContainer().span().addLog(() -> "Dropped").setStatus(SpanStatus.ABORTED).end();
                return;
            }
            if (!msg.client()) {
                boolean rmtHostLoopback;
                boolean bl = rmtHostLoopback = node.socketAddresses().size() == 1 && node.socketAddresses().iterator().next().getAddress().isLoopbackAddress();
                if (ServerImpl.this.spi.locHost.isLoopbackAddress() != rmtHostLoopback) {
                    String firstNode = rmtHostLoopback ? "remote" : "local";
                    String secondNode = rmtHostLoopback ? "local" : "remote";
                    String errMsg = "Failed to add node to topology because " + firstNode + " node is configured to use loopback address, but " + secondNode + " node is not (consider changing 'localAddress' configuration parameter) [locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ']';
                    LT.warn(this.log, errMsg);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(errMsg);
                    }
                    try {
                        this.trySendMessageDirectly(node, new TcpDiscoveryLoopbackProblemMessage(locNodeId, ServerImpl.this.locNode.addresses(), ServerImpl.this.locNode.hostNames()));
                    }
                    catch (IgniteSpiException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to send loopback problem message to node [node=" + node + ", err=" + e.getMessage() + ']');
                        }
                        ServerImpl.this.onException("Failed to send loopback problem message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                    }
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
            }
            if (ServerImpl.this.isLocalNodeCoordinator()) {
                boolean rmtSrvcProcMode;
                boolean rmtLateAssignBool;
                boolean rmtMarshStrSerialVer2Bool;
                boolean rmtMarshCompactFooterBool;
                boolean locLateAssignBool;
                String rmtMarsh;
                IgniteNodeValidationResult err;
                TcpDiscoveryNode existingNode = ServerImpl.this.ring.node(node.id());
                if (existingNode != null) {
                    if (!node.socketAddresses().equals(existingNode.socketAddresses())) {
                        if (!ServerImpl.this.pingNode(existingNode)) {
                            U.warn(this.log, "Sending node failed message for existing node: " + node);
                            this.addMessage(new TcpDiscoveryNodeFailedMessage(locNodeId, existingNode.id(), existingNode.internalOrder()));
                            msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                            return;
                        }
                        try {
                            this.trySendMessageDirectly(node, ServerImpl.this.createTcpDiscoveryDuplicateIdMessage(locNodeId, existingNode));
                        }
                        catch (IgniteSpiException e) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to send duplicate ID message to node [node=" + node + ", existingNode=" + existingNode + ", err=" + e.getMessage() + ']');
                            }
                            ServerImpl.this.onException("Failed to send duplicate ID message to node [node=" + node + ", existingNode=" + existingNode + ']', e);
                        }
                        LT.warn(this.log, "Ignoring join request from node (duplicate ID) [node=" + node + ", existingNode=" + existingNode + ']');
                        msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                        return;
                    }
                    if (msg.client()) {
                        TcpDiscoveryClientReconnectMessage reconMsg = new TcpDiscoveryClientReconnectMessage(node.id(), node.clientRouterNodeId(), null);
                        reconMsg.verify(ServerImpl.this.getLocalNodeId());
                        Collection<TcpDiscoveryAbstractMessage> msgs = ServerImpl.this.msgHist.messages(null, node, (x$0, x$1) -> ServerImpl.this.clientSupportsDiscoveryMessage(x$0, x$1));
                        if (msgs != null) {
                            reconMsg.pendingMessages(msgs);
                            reconMsg.success(true);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Send reconnect message to already joined client [clientNode=" + existingNode + ", msg=" + reconMsg + ']');
                        }
                        if (ServerImpl.this.getLocalNodeId().equals(node.clientRouterNodeId())) {
                            ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(node.id());
                            if (wrk != null) {
                                wrk.addMessage(reconMsg);
                            } else if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to find client message worker [clientNode=" + existingNode + ", msg=" + reconMsg + ']');
                            }
                        } else if (this.sendMessageToRemotes(reconMsg)) {
                            this.sendMessageAcrossRing(reconMsg);
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Ignoring join request message since node is already in topology: " + msg);
                    }
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                if (!node.isClient() && !node.isDaemon() && ServerImpl.this.nodesIdsHist.contains(node.id())) {
                    try {
                        this.trySendMessageDirectly(node, ServerImpl.this.createTcpDiscoveryDuplicateIdMessage(locNodeId, node));
                    }
                    catch (IgniteSpiException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to send duplicate ID message to node [node=" + node + ", err=" + e.getMessage() + ']');
                        }
                        ServerImpl.this.onException("Failed to send duplicate ID message to node: " + node, e);
                    }
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                if (ServerImpl.this.spi.nodeAuth != null) {
                    try {
                        SecurityCredentials cred = ServerImpl.this.unmarshalCredentials(node);
                        SecurityContext subj = ServerImpl.this.spi.nodeAuth.authenticateNode(node, cred);
                        if (subj == null) {
                            LT.warn(this.log, "Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']');
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node));
                            }
                            try {
                                this.trySendMessageDirectly(node, new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost, node.id()));
                            }
                            catch (IgniteSpiException e) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                                ServerImpl.this.onException("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                            }
                            msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                            return;
                        }
                        String authFailedMsg = null;
                        if (!(subj instanceof Serializable)) {
                            LT.warn(this.log, "Authentication subject is not Serializable [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']');
                            authFailedMsg = "Authentication subject is not serializable";
                        } else if (node.clientRouterNodeId() == null && !subj.systemOperationAllowed(SecurityPermission.JOIN_AS_SERVER)) {
                            authFailedMsg = "Node is not authorised to join as a server node";
                        }
                        if (authFailedMsg != null) {
                            block61: {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug(authFailedMsg + " [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node));
                                }
                                try {
                                    this.trySendMessageDirectly(node, new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost, node.id()));
                                }
                                catch (IgniteSpiException e) {
                                    if (!this.log.isDebugEnabled()) break block61;
                                    this.log.debug("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                            }
                            msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                            return;
                        }
                        HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
                        attrs.put("org.apache.ignite.security.subject.v2", U.marshal(ServerImpl.this.spi.marshaller(), (Object)subj));
                        attrs.put("org.apache.ignite.security.subject", ServerImpl.this.marshalWithSecurityVersion(subj, 1));
                        node.setAttributes(attrs);
                    }
                    catch (IgniteCheckedException | IgniteException e) {
                        LT.error(this.log, e, "Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']');
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to authenticate node (will ignore join request) [node=" + node + ", err=" + e + ']');
                        }
                        ServerImpl.this.onException("Failed to authenticate node (will ignore join request) [node=" + node + ", err=" + e + ']', e);
                        msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                        return;
                    }
                }
                if ((err = ServerImpl.this.spi.getSpiContext().validateNode(node)) == null) {
                    try {
                        DiscoveryDataBag data = msg.gridDiscoveryData().unmarshalJoiningNodeData(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()), false, this.log);
                        err = ServerImpl.this.spi.getSpiContext().validateNode(node, data);
                    }
                    catch (IgniteCheckedException e) {
                        err = new IgniteNodeValidationResult(node.id(), e.getMessage());
                    }
                }
                if (err != null) {
                    final IgniteNodeValidationResult err0 = err;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Node validation failed [res=" + err + ", node=" + node + ']');
                    }
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            boolean ping;
                            boolean bl = ping = node.id().equals(err0.nodeId()) ? ServerImpl.this.pingNode(node) : ServerImpl.this.pingNode(err0.nodeId());
                            if (!ping) {
                                if (RingMessageWorker.this.log.isDebugEnabled()) {
                                    RingMessageWorker.this.log.debug("Conflicting node has already left, need to wait for event. Will ignore join request for now since it will be recent [req=" + msg + ", err=" + err0.message() + ']');
                                }
                                return;
                            }
                            LT.warn(RingMessageWorker.this.log, err0.message());
                            if (RingMessageWorker.this.log.isDebugEnabled()) {
                                RingMessageWorker.this.log.debug(err0.message());
                            }
                            try {
                                RingMessageWorker.this.trySendMessageDirectly(node, new TcpDiscoveryCheckFailedMessage(err0.nodeId(), err0.sendMessage()));
                            }
                            catch (IgniteSpiException e) {
                                if (RingMessageWorker.this.log.isDebugEnabled()) {
                                    RingMessageWorker.this.log.debug("Failed to send hash ID resolver validation failed message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                                ServerImpl.this.onException("Failed to send hash ID resolver validation failed message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                            }
                        }
                    });
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                final String locMarsh = (String)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller");
                if (!F.eq(locMarsh, rmtMarsh = (String)node.attribute("org.apache.ignite.marshaller"))) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's marshaller differs from remote node's marshaller (to make sure all nodes in topology have identical marshaller, configure marshaller explicitly in configuration) [locMarshaller=" + locMarsh + ", rmtMarshaller=" + rmtMarsh + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            LT.warn(RingMessageWorker.this.log, errMsg);
                            if (RingMessageWorker.this.log.isDebugEnabled()) {
                                RingMessageWorker.this.log.debug(errMsg);
                            }
                            try {
                                String sndMsg = "Local node's marshaller differs from remote node's marshaller (to make sure all nodes in topology have identical marshaller, configure marshaller explicitly in configuration) [locMarshaller=" + rmtMarsh + ", rmtMarshaller=" + locMarsh + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                                RingMessageWorker.this.trySendMessageDirectly(node, new TcpDiscoveryCheckFailedMessage(locNodeId, sndMsg));
                            }
                            catch (IgniteSpiException e) {
                                if (RingMessageWorker.this.log.isDebugEnabled()) {
                                    RingMessageWorker.this.log.debug("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                                ServerImpl.this.onException("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                            }
                        }
                    });
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                final Boolean locMarshUseDfltSuid = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller.useDefaultSUID");
                boolean locMarshUseDfltSuidBool = locMarshUseDfltSuid == null ? true : locMarshUseDfltSuid;
                final Boolean rmtMarshUseDfltSuid = (Boolean)node.attribute("org.apache.ignite.marshaller.useDefaultSUID");
                boolean rmtMarshUseDfltSuidBool = rmtMarshUseDfltSuid == null ? true : rmtMarshUseDfltSuid;
                Boolean locLateAssign = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.cache.lateAffinity");
                boolean bl = locLateAssignBool = locLateAssign != null ? locLateAssign : false;
                if (locMarshUseDfltSuidBool != rmtMarshUseDfltSuidBool) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshUseDfltSuid=" + locMarshUseDfltSuid + ", rmtMarshUseDfltSuid=" + rmtMarshUseDfltSuid + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshUseDfltSuid=" + rmtMarshUseDfltSuid + ", rmtMarshUseDfltSuid=" + locMarshUseDfltSuid + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                Boolean locMarshCompactFooter = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller.compactFooter");
                final boolean locMarshCompactFooterBool = locMarshCompactFooter != null ? locMarshCompactFooter : false;
                Boolean rmtMarshCompactFooter = (Boolean)node.attribute("org.apache.ignite.marshaller.compactFooter");
                boolean bl2 = rmtMarshCompactFooterBool = rmtMarshCompactFooter != null ? rmtMarshCompactFooter : false;
                if (locMarshCompactFooterBool != rmtMarshCompactFooterBool) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's binary marshaller \"compactFooter\" property differs from the same property on remote node (make sure all nodes in topology have the same value of \"compactFooter\" property) [locMarshallerCompactFooter=" + locMarshCompactFooterBool + ", rmtMarshallerCompactFooter=" + rmtMarshCompactFooterBool + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's binary marshaller \"compactFooter\" property differs from the same property on remote node (make sure all nodes in topology have the same value of \"compactFooter\" property) [locMarshallerCompactFooter=" + rmtMarshCompactFooterBool + ", rmtMarshallerCompactFooter=" + locMarshCompactFooterBool + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                final Boolean locMarshStrSerialVer2 = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
                boolean locMarshStrSerialVer2Bool = locMarshStrSerialVer2 != null ? locMarshStrSerialVer2 : false;
                final Boolean rmtMarshStrSerialVer2 = (Boolean)node.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
                boolean bl3 = rmtMarshStrSerialVer2Bool = rmtMarshStrSerialVer2 != null ? rmtMarshStrSerialVer2 : false;
                if (locMarshStrSerialVer2Bool != rmtMarshStrSerialVer2Bool) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshStrSerialVer2=" + locMarshStrSerialVer2 + ", rmtMarshStrSerialVer2=" + rmtMarshStrSerialVer2 + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshStrSerialVer2=" + rmtMarshStrSerialVer2 + ", rmtMarshStrSerialVer2=" + locMarshStrSerialVer2 + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                Boolean rmtLateAssign = (Boolean)node.attribute("org.apache.ignite.cache.lateAffinity");
                boolean bl4 = rmtLateAssignBool = rmtLateAssign != null ? rmtLateAssign : false;
                if (locLateAssignBool != rmtLateAssignBool) {
                    String errMsg = "Local node's cache affinity assignment mode differs from the same property on remote node (make sure all nodes in topology have the same cache affinity assignment mode) [locLateAssign=" + locLateAssignBool + ", rmtLateAssign=" + rmtLateAssignBool + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                    String sndMsg = "Local node's cache affinity assignment mode differs from the same property on remote node (make sure all nodes in topology have the same cache affinity assignment mode) [locLateAssign=" + rmtLateAssignBool + ", rmtLateAssign=" + locLateAssign + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                    this.nodeCheckError(node, errMsg, sndMsg);
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                Boolean locSrvcProcModeAttr = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.event.driven.service.processor.enabled");
                final Boolean locSrvcProcMode = locSrvcProcModeAttr != null ? locSrvcProcModeAttr : false;
                Boolean rmtSrvcProcModeAttr = (Boolean)node.attribute("org.apache.ignite.event.driven.service.processor.enabled");
                boolean bl5 = rmtSrvcProcMode = rmtSrvcProcModeAttr != null ? rmtSrvcProcModeAttr : false;
                if (!F.eq(locSrvcProcMode, rmtSrvcProcMode)) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED property value differs from remote node's value (to make sure all nodes in topology have identical service processor mode, configure system property explicitly) [locSrvcProcMode=" + locSrvcProcMode + ", rmtSrvcProcMode=" + rmtSrvcProcMode + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED property value differs from remote node's value (to make sure all nodes in topology have identical service processor mode, configure system property explicitly) [locSrvcProcMode=" + rmtSrvcProcMode + ", rmtSrvcProcMode=" + locSrvcProcMode + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    msg.spanContainer().span().addLog(() -> "Ignored").setStatus(SpanStatus.ABORTED).end();
                    return;
                }
                node.internalOrder(ServerImpl.this.ring.nextNodeOrder());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Internal order has been assigned to node: " + node);
                }
                DiscoveryDataPacket data = msg.gridDiscoveryData();
                TcpDiscoveryNodeAddedMessage nodeAddedMsg = new TcpDiscoveryNodeAddedMessage(locNodeId, node, data, ServerImpl.this.spi.gridStartTime);
                nodeAddedMsg = ServerImpl.this.tracing.messages().branch(nodeAddedMsg, msg);
                nodeAddedMsg.client(msg.client());
                this.processNodeAddedMessage(nodeAddedMsg);
                ServerImpl.this.tracing.messages().finishProcessing(nodeAddedMsg);
            } else if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            }
        }

        private boolean booleanAttribute(ClusterNode node, String name, boolean dflt) {
            Boolean attr = (Boolean)node.attribute(name);
            return attr != null ? attr : dflt;
        }

        private void nodeCheckError(TcpDiscoveryNode node, String errMsg, String sndMsg) {
            LT.warn(this.log, errMsg);
            if (this.log.isDebugEnabled()) {
                this.log.debug(errMsg);
            }
            try {
                this.trySendMessageDirectly(node, new TcpDiscoveryCheckFailedMessage(ServerImpl.this.locNode.id(), sndMsg));
            }
            catch (IgniteSpiException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']');
                }
                ServerImpl.this.onException("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
            }
        }

        private void trySendMessageDirectlyToAddrs(Collection<InetSocketAddress> addrs, @Nullable TcpDiscoveryNode node, TcpDiscoveryAbstractMessage msg) {
            IgniteSpiException ex = null;
            for (InetSocketAddress addr : addrs) {
                try {
                    IgniteSpiOperationTimeoutHelper timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                    ServerImpl.this.sendMessageDirectly(msg, addr, timeoutHelper);
                    if (node != null) {
                        node.lastSuccessfulAddress(addr);
                    }
                    return;
                }
                catch (IgniteSpiException e) {
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void trySendMessageDirectly(Collection<InetSocketAddress> addrs, UUID nodeId, TcpDiscoveryAbstractMessage msg) {
            TcpDiscoveryNode node = ServerImpl.this.ring.node(nodeId);
            if (node == null) {
                if (F.isEmpty(addrs)) throw new IgniteSpiException("Node does not exist: " + nodeId);
                this.trySendMessageDirectlyToAddrs(addrs, null, msg);
                return;
            } else {
                this.trySendMessageDirectly(node, msg);
            }
        }

        private void trySendMessageDirectly(TcpDiscoveryNode node, TcpDiscoveryAbstractMessage msg) throws IgniteSpiException {
            if (node.clientRouterNodeId() != null) {
                TcpDiscoveryNode routerNode = ServerImpl.this.ring.node(node.clientRouterNodeId());
                if (routerNode == null) {
                    throw new IgniteSpiException("Router node for client does not exist: " + node);
                }
                if (routerNode.clientRouterNodeId() != null) {
                    throw new IgniteSpiException("Router node is a client node: " + node);
                }
                if (routerNode.id().equals(ServerImpl.this.getLocalNodeId())) {
                    this.sendDirectlyToClient(node.id(), msg);
                    return;
                }
                this.trySendMessageDirectly(routerNode, msg);
                return;
            }
            this.trySendMessageDirectlyToAddrs(ServerImpl.this.spi.getNodeAddresses(node, U.sameMacs(ServerImpl.this.locNode, node)), node, msg);
        }

        private void sendDirectlyToClient(UUID clientNodeId, TcpDiscoveryAbstractMessage msg) {
            ClientMessageWorker worker = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(clientNodeId);
            if (worker == null) {
                throw new IgniteSpiException("Client node already disconnected: " + clientNodeId);
            }
            msg.verify(ServerImpl.this.getLocalNodeId());
            worker.addMessage(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Deprecated
        private void processNodeAddedMessage(TcpDiscoveryNodeAddedMessage msg) {
            block62: {
                Iterator<TcpDiscoveryNode> iterator;
                Collection<TcpDiscoveryNode> top;
                TcpDiscoveryNode node;
                block64: {
                    block63: {
                        assert (msg != null);
                        node = msg.node();
                        assert (node != null);
                        msg.spanContainer().span().addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> node.id().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> node.consistentId().toString());
                        if (node.internalOrder() < ServerImpl.this.locNode.internalOrder()) {
                            if (!ServerImpl.this.locNode.id().equals(node.id())) {
                                U.warn(this.log, "Discarding node added message since local node's order is greater [node=" + node + ", ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                                return;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Received node added message with node order smaller than local node order (will appy) [node=" + node + ", ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                            }
                        }
                        UUID locNodeId = ServerImpl.this.getLocalNodeId();
                        if (ServerImpl.this.isLocalNodeCoordinator()) {
                            if (msg.verified()) {
                                TcpDiscoveryNodeAddFinishedMessage addFinishMsg = new TcpDiscoveryNodeAddFinishedMessage(locNodeId, node.id());
                                if (node.clientRouterNodeId() != null) {
                                    addFinishMsg.clientDiscoData(msg.gridDiscoveryData());
                                    addFinishMsg.clientNodeAttributes(node.attributes());
                                }
                                addFinishMsg = ServerImpl.this.tracing.messages().branch(addFinishMsg, msg);
                                addFinishMsg.spanContainer().span().addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> node.id().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> node.consistentId().toString());
                                this.processNodeAddFinishedMessage(addFinishMsg);
                                ServerImpl.this.tracing.messages().finishProcessing(addFinishMsg);
                                this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                                return;
                            }
                            msg.verify(locNodeId);
                            msg.spanContainer().span().addLog(() -> "Verified");
                        } else if (!locNodeId.equals(node.id()) && ServerImpl.this.ring.node(node.id()) != null) {
                            if (this.sendMessageToRemotes(msg)) {
                                this.sendMessageAcrossRing(msg);
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Local node already has node being added. Passing TcpDiscoveryNodeAddedMessage to coordinator for final processing [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                            }
                            if (ServerImpl.this.debugMode) {
                                ServerImpl.this.debugLog(msg, "Local node already has node being added. Passing TcpDiscoveryNodeAddedMessage to coordinator for final processing [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                            }
                            msg.spanContainer().span().addLog(() -> "Bypassed to crd").setStatus(SpanStatus.OK).end();
                            return;
                        }
                        if (msg.verified() && !locNodeId.equals(node.id())) {
                            boolean topChanged;
                            block61: {
                                if (!node.isClient() && !node.isDaemon() && ServerImpl.this.nodesIdsHist.contains(node.id())) {
                                    U.warn(this.log, "Discarding node added message since local node has already seen joining node in topology [node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                                    msg.spanContainer().span().addLog(() -> "Discarded").setStatus(SpanStatus.ABORTED).end();
                                    return;
                                }
                                if (node.internalOrder() <= ServerImpl.this.ring.maxInternalOrder()) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Discarding node added message since new node's order is less than max order in ring [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Discarding node added message since new node's order is less than max order in ring [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                                    }
                                    msg.spanContainer().span().addLog(() -> "Discarded").setStatus(SpanStatus.ABORTED).end();
                                    return;
                                }
                                Object addFinishMsg = ServerImpl.this.mux;
                                // MONITORENTER : addFinishMsg
                                ServerImpl.this.joiningNodes.add(node.id());
                                // MONITOREXIT : addFinishMsg
                                if (!ServerImpl.this.isLocalNodeCoordinator() && ServerImpl.this.spi.nodeAuth != null && ServerImpl.this.spi.nodeAuth.isGlobalNodeAuthentication()) {
                                    boolean authFailed = true;
                                    try {
                                        SecurityCredentials cred = ServerImpl.this.unmarshalCredentials(node);
                                        if (cred == null) {
                                            if (this.log.isDebugEnabled()) {
                                                this.log.debug("Skipping global authentication for node (security credentials not found, probably, due to coordinator has older version) [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ", coord=" + ServerImpl.this.ring.coordinator() + ']');
                                            }
                                            authFailed = false;
                                            break block61;
                                        }
                                        SecurityContext subj = ServerImpl.this.spi.nodeAuth.authenticateNode(node, cred);
                                        SecurityContext coordSubj = SecurityUtils.nodeSecurityContext(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()), node);
                                        if (!ServerImpl.this.permissionsEqual(this.getPermissions(coordSubj), this.getPermissions(subj))) {
                                            LT.warn(this.log, "Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']');
                                            if (this.log.isDebugEnabled()) {
                                                this.log.debug("Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node));
                                            }
                                            break block61;
                                        }
                                        authFailed = false;
                                    }
                                    catch (IgniteException e) {
                                        U.error(this.log, "Failed to verify node permissions consistency (will drop the node): " + node, e);
                                    }
                                    finally {
                                        if (authFailed) {
                                            try {
                                                this.trySendMessageDirectly(node, new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost, node.id()));
                                            }
                                            catch (IgniteSpiException e) {
                                                if (this.log.isDebugEnabled()) {
                                                    this.log.debug("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                                }
                                                ServerImpl.this.onException("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                                            }
                                            this.addMessage(new TcpDiscoveryNodeFailedMessage(locNodeId, node.id(), node.internalOrder()));
                                        }
                                    }
                                }
                            }
                            if (msg.client()) {
                                node.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
                            }
                            if (topChanged = ServerImpl.this.ring.add(node)) {
                                assert (!node.visible()) : "Added visible node [node=" + node + ", locNode=" + ServerImpl.this.locNode + ']';
                                DiscoveryDataPacket dataPacket = msg.gridDiscoveryData();
                                assert (dataPacket != null) : msg;
                                dataPacket.joiningNodeClient(msg.client());
                                if (dataPacket.hasJoiningNodeData()) {
                                    if (ServerImpl.this.spiState == TcpDiscoverySpiState.CONNECTED) {
                                        ServerImpl.this.spi.onExchange(dataPacket, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                                        if (!node.isDaemon()) {
                                            ServerImpl.this.spi.collectExchangeData(dataPacket);
                                        }
                                    } else if (ServerImpl.this.spiState == TcpDiscoverySpiState.CONNECTING) {
                                        this.joiningNodesDiscoDataList.add(dataPacket);
                                    }
                                }
                                ServerImpl.this.processMessageFailedNodes(msg);
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Added node to local ring [added=" + topChanged + ", node=" + node + ", ring=" + ServerImpl.this.ring + ']');
                            }
                        }
                        if (!msg.verified() || !locNodeId.equals(node.id())) break block62;
                        Object object = ServerImpl.this.mux;
                        // MONITORENTER : object
                        if (ServerImpl.this.spiState != TcpDiscoverySpiState.CONNECTING || ServerImpl.this.locNode.internalOrder() == node.internalOrder()) break block63;
                        top = msg.topology();
                        if (top != null && !top.isEmpty()) {
                            ServerImpl.this.spi.gridStartTime = msg.gridStartTime();
                            if (ServerImpl.this.spi.nodeAuth != null && ServerImpl.this.spi.nodeAuth.isGlobalNodeAuthentication()) {
                                TcpDiscoveryAuthFailedMessage authFail = new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost, node.id());
                                try {
                                    ClassLoader ldr = U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration());
                                    SecurityContext rmCrd = SecurityUtils.nodeSecurityContext(ServerImpl.this.spi.marshaller(), ldr, node);
                                    SecurityContext locCrd = SecurityUtils.nodeSecurityContext(ServerImpl.this.spi.marshaller(), ldr, ServerImpl.this.locNode);
                                    if (!ServerImpl.this.permissionsEqual(this.getPermissions(locCrd), this.getPermissions(rmCrd))) {
                                        LT.warn(this.log, "Failed to authenticate local node (local authentication result is different from rest of topology) [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']');
                                        ServerImpl.this.joinRes.set(authFail);
                                        ServerImpl.this.spiState = TcpDiscoverySpiState.AUTH_FAILED;
                                        ServerImpl.this.mux.notifyAll();
                                        // MONITOREXIT : object
                                        return;
                                    }
                                }
                                catch (IgniteException e) {
                                    U.error(this.log, "Failed to verify node permissions consistency (will drop the node): " + node, e);
                                    ServerImpl.this.joinRes.set(authFail);
                                    ServerImpl.this.spiState = TcpDiscoverySpiState.AUTH_FAILED;
                                    ServerImpl.this.mux.notifyAll();
                                    // MONITOREXIT : object
                                    return;
                                }
                            }
                            iterator = top.iterator();
                            break block64;
                        } else {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Discarding node added message with empty topology: " + msg);
                            }
                            msg.spanContainer().span().addLog(() -> "Discarded").setStatus(SpanStatus.ABORTED).end();
                            // MONITOREXIT : object
                            return;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node added message (this message has already been processed) [spiState=" + (Object)((Object)ServerImpl.this.spiState) + ", msg=" + msg + ", locNode=" + ServerImpl.this.locNode + ']');
                    }
                    msg.spanContainer().span().addLog(() -> "Discarded").setStatus(SpanStatus.ABORTED).end();
                    // MONITOREXIT : object
                    return;
                }
                while (iterator.hasNext()) {
                    TcpDiscoveryNode n = iterator.next();
                    assert (n.internalOrder() < node.internalOrder()) : "Invalid node [topNode=" + n + ", added=" + node + ']';
                    n.visible(true);
                    if (!ServerImpl.this.nodeCompactRepresentationSupported) continue;
                    ServerImpl.this.nodeCompactRepresentationSupported = IgniteFeatures.nodeSupports(ServerImpl.this.gridKernalContext(), n, IgniteFeatures.TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION);
                }
                ServerImpl.this.joiningNodes.clear();
                ServerImpl.this.locNode.setAttributes(node.attributes());
                ServerImpl.this.locNode.visible(true);
                ServerImpl.this.ring.restoreTopology(top, node.internalOrder());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Restored topology from node added message: " + ServerImpl.this.ring);
                }
                this.gridDiscoveryData = msg.gridDiscoveryData();
                this.joiningNodesDiscoDataList = new ArrayList<DiscoveryDataPacket>();
                ServerImpl.this.topHist.clear();
                ServerImpl.this.topHist.putAll(msg.topologyHistory());
                this.pendingMsgs.reset(msg.messages(), msg.discardedMessageId(), msg.discardedCustomMessageId());
                msg.messages(null, null, null);
                msg.topology(null);
                msg.topologyHistory(null);
                msg.clearDiscoveryData();
                // MONITOREXIT : object
                ServerImpl.this.processMessageFailedNodes(msg);
            }
            if (!this.sendMessageToRemotes(msg)) return;
            this.sendMessageAcrossRing(msg);
        }

        @Nullable
        private SecurityPermissionSet getPermissions(SecurityContext secCtx) {
            if (secCtx == null || secCtx.subject() == null) {
                return null;
            }
            return secCtx.subject().permissions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNodeAddFinishedMessage(TcpDiscoveryNodeAddFinishedMessage msg) {
            assert (msg != null);
            UUID nodeId = msg.nodeId();
            assert (nodeId != null);
            TcpDiscoveryNode node = ServerImpl.this.ring.node(nodeId);
            if (node == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding node add finished message since node is not found [msg=" + msg + ']');
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node to finish add: " + node);
            }
            if (ServerImpl.this.nodeCompactRepresentationSupported) {
                ServerImpl.this.nodeCompactRepresentationSupported = IgniteFeatures.nodeSupports(ServerImpl.this.gridKernalContext(), node, IgniteFeatures.TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION);
            }
            boolean locNodeCoord = ServerImpl.this.isLocalNodeCoordinator();
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (locNodeCoord) {
                if (msg.verified()) {
                    this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                    return;
                }
                if (node.visible() && node.order() != 0L) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node add finished message since node has already been added [node=" + node + ", msg=" + msg + ']');
                    }
                    return;
                }
                msg.topologyVersion(ServerImpl.this.ring.incrementTopologyVersion());
                msg.verify(locNodeId);
            }
            long topVer = msg.topologyVersion();
            boolean fireEvt = false;
            if (msg.verified()) {
                assert (topVer > 0L) : "Invalid topology version: " + msg;
                if (node.order() == 0L) {
                    node.order(topVer);
                }
                if (!node.visible()) {
                    node.visible(true);
                    fireEvt = true;
                }
            }
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                ServerImpl.this.joiningNodes.remove(nodeId);
            }
            TcpDiscoverySpiState state = ServerImpl.this.spiStateCopy();
            if (msg.verified() && !locNodeId.equals(nodeId) && state != TcpDiscoverySpiState.CONNECTING && fireEvt) {
                ServerImpl.this.spi.stats.onNodeJoined();
                assert (node.internalOrder() > ServerImpl.this.locNode.internalOrder()) : "Invalid order [node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ", ring=" + ServerImpl.access$1500(ServerImpl.this) + ']';
                if (ServerImpl.this.spi.locNodeVer.equals(node.version())) {
                    node.version(ServerImpl.this.spi.locNodeVer);
                }
                if (!locNodeCoord) {
                    boolean b = ServerImpl.this.ring.topologyVersion(topVer);
                    assert (b) : "Topology version has not been updated: [ring=" + ServerImpl.access$1500(ServerImpl.this) + ", msg=" + msg + ", lastMsg=" + this.lastMsg + ", spiState=" + (Object)((Object)state) + ']';
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Topology version has been updated: [ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                    }
                    this.lastMsg = msg;
                }
                if (state == TcpDiscoverySpiState.CONNECTED) {
                    boolean notified = ServerImpl.this.notifyDiscovery(10, topVer, node, msg.spanContainer());
                    this.notifiedDiscovery.set(notified);
                    if (!node.isClient() && !node.isDaemon()) {
                        ServerImpl.this.nodesIdsHist.add(node.id());
                    }
                }
                try {
                    if (ServerImpl.this.spi.ipFinder.isShared() && locNodeCoord && node.clientRouterNodeId() == null) {
                        ServerImpl.this.spi.ipFinder.registerAddresses(node.socketAddresses());
                    }
                }
                catch (IgniteSpiException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to register new node address [node=" + node + ", err=" + e.getMessage() + ']');
                    }
                    ServerImpl.this.onException("Failed to register new node address [node=" + node + ", err=" + e.getMessage() + ']', e);
                }
            }
            if (msg.verified() && locNodeId.equals(nodeId) && state == TcpDiscoverySpiState.CONNECTING) {
                assert (node != null);
                assert (topVer > 0L) : "Invalid topology version: " + msg;
                ServerImpl.this.ring.topologyVersion(topVer);
                node.order(topVer);
                Iterator<DiscoveryDataPacket> e = ServerImpl.this.mux;
                synchronized (e) {
                    ServerImpl.this.spiState = TcpDiscoverySpiState.CONNECTED;
                    ServerImpl.this.mux.notifyAll();
                }
                if (this.gridDiscoveryData != null) {
                    ServerImpl.this.spi.onExchange(this.gridDiscoveryData, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                }
                if (this.joiningNodesDiscoDataList != null) {
                    for (DiscoveryDataPacket dataPacket : this.joiningNodesDiscoDataList) {
                        ServerImpl.this.spi.onExchange(dataPacket, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                    }
                }
                this.nullifyDiscoData();
                boolean notified = ServerImpl.this.notifyDiscovery(10, topVer, ServerImpl.this.locNode, msg.spanContainer());
                this.notifiedDiscovery.set(notified);
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            }
            this.checkPendingCustomMessages();
        }

        private void processRingLatencyCheckMessage(TcpDiscoveryRingLatencyCheckMessage msg) {
            assert (msg != null);
            if (msg.maxHopsReached()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Latency check has been discarded (max hops reached) [id=" + msg.id() + ", maxHops=" + msg.maxHops() + ']');
                }
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Latency check processing: " + msg.id());
            }
            if (ServerImpl.this.ring.hasRemoteServerNodes()) {
                this.sendMessageAcrossRing(msg);
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Latency check has been discarded (no remote nodes): " + msg.id());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNodeLeftMessage(TcpDiscoveryNodeLeftMessage msg) {
            assert (msg != null);
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            UUID leavingNodeId = msg.creatorNodeId();
            msg.spanContainer().span().addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> leavingNodeId.toString());
            if (locNodeId.equals(leavingNodeId)) {
                if (msg.senderNodeId() == null) {
                    Object object = ServerImpl.this.mux;
                    synchronized (object) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Starting local node stop procedure.");
                        }
                        ServerImpl.this.spiState = TcpDiscoverySpiState.STOPPING;
                        ServerImpl.this.mux.notifyAll();
                    }
                }
                if (msg.verified() || !ServerImpl.this.ring.hasRemoteNodes() || msg.senderNodeId() != null) {
                    if (ServerImpl.this.spi.ipFinder.isShared() && !ServerImpl.this.ring.hasRemoteNodes()) {
                        try {
                            ServerImpl.this.spi.ipFinder.unregisterAddresses(U.resolveAddresses(ServerImpl.this.spi.getAddressResolver(), ServerImpl.this.locNode.socketAddresses()));
                        }
                        catch (IgniteSpiException e) {
                            U.error(this.log, "Failed to unregister local node address from IP finder.", e);
                        }
                    }
                    Object e = ServerImpl.this.mux;
                    synchronized (e) {
                        if (ServerImpl.this.spiState == TcpDiscoverySpiState.STOPPING) {
                            ServerImpl.this.spiState = TcpDiscoverySpiState.LEFT;
                            ServerImpl.this.mux.notifyAll();
                        }
                    }
                    return;
                }
                this.sendMessageAcrossRing(msg);
                return;
            }
            if (ServerImpl.this.ring.node(msg.senderNodeId()) == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding node left message since sender node is not in topology: " + msg);
                }
                return;
            }
            TcpDiscoveryNode leavingNode = ServerImpl.this.ring.node(leavingNodeId);
            if (leavingNode != null) {
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    ServerImpl.this.leavingNodes.add(leavingNode);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding node left message since node was not found: " + msg);
                }
                msg.spanContainer().span().addLog(() -> "Discarded").setStatus(SpanStatus.ABORTED).end();
                return;
            }
            boolean locNodeCoord = ServerImpl.this.isLocalNodeCoordinator();
            if (locNodeCoord) {
                if (msg.verified()) {
                    msg.spanContainer().span().addLog(() -> "Ring failed").setStatus(SpanStatus.ABORTED).end();
                    this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                    return;
                }
                msg.verify(locNodeId);
                msg.spanContainer().span().addLog(() -> "Verified");
            }
            if (msg.verified() && !locNodeId.equals(leavingNodeId)) {
                long topVer;
                if (!ServerImpl.this.nodeCompactRepresentationSupported) {
                    ServerImpl.this.nodeCompactRepresentationSupported = ServerImpl.this.allNodesSupport(IgniteFeatures.TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION, IgniteDiscoverySpi.ALL_NODES);
                }
                TcpDiscoveryNode leftNode = ServerImpl.this.ring.removeNode(leavingNodeId);
                ServerImpl.this.interruptPing(leavingNode);
                assert (leftNode != null) : msg;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Removed node from topology: " + leftNode);
                }
                if (locNodeCoord) {
                    topVer = ServerImpl.this.ring.incrementTopologyVersion();
                    msg.topologyVersion(topVer);
                } else {
                    topVer = msg.topologyVersion();
                    assert (topVer > 0L) : "Topology version is empty for message: " + msg;
                    boolean b = ServerImpl.this.ring.topologyVersion(topVer);
                    assert (b) : "Topology version has not been updated: [ring=" + ServerImpl.access$1500(ServerImpl.this) + ", msg=" + msg + ", lastMsg=" + this.lastMsg + ", spiState=" + (Object)((Object)ServerImpl.access$2200(ServerImpl.this)) + ']';
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Topology version has been updated: [ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                    }
                    this.lastMsg = msg;
                }
                if (msg.client()) {
                    ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.remove(leavingNodeId);
                    if (wrk != null) {
                        wrk.addMessage(msg);
                    }
                } else if (leftNode.equals(this.next) && this.sock != null) {
                    try {
                        ServerImpl.this.spi.writeToSocket(this.sock, this.out, msg, ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.failureDetectionTimeout() : ServerImpl.this.spi.getSocketTimeout());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Sent verified node left message to leaving node: " + msg);
                        }
                    }
                    catch (IOException | IgniteCheckedException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to send verified node left message to leaving node [msg=" + msg + ", err=" + e.getMessage() + ']');
                        }
                        ServerImpl.this.onException("Failed to send verified node left message to leaving node [msg=" + msg + ", err=" + e.getMessage() + ']', e);
                    }
                    finally {
                        this.forceSndPending = true;
                        this.next = null;
                        U.closeQuiet(this.sock);
                    }
                }
                Object e = ServerImpl.this.mux;
                synchronized (e) {
                    ServerImpl.this.joiningNodes.remove(leftNode.id());
                }
                ServerImpl.this.spi.stats.onNodeLeft();
                boolean notified = ServerImpl.this.notifyDiscovery(11, topVer, leftNode, msg.spanContainer());
                this.notifiedDiscovery.set(notified);
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    ServerImpl.this.failedNodes.remove(leftNode);
                    ServerImpl.this.leavingNodes.remove(leftNode);
                    ServerImpl.this.failedNodesMsgSent.remove(leftNode.id());
                }
            }
            if (this.sendMessageToRemotes(msg)) {
                try {
                    this.sendMessageAcrossRing(msg);
                }
                finally {
                    this.forceSndPending = false;
                }
            } else {
                this.forceSndPending = false;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unable to send message across the ring (topology has no remote nodes): " + msg);
                }
                U.closeQuiet(this.sock);
                this.processPendingMessagesLocally(msg);
            }
            this.checkPendingCustomMessages();
        }

        private boolean sendMessageToRemotes(TcpDiscoveryAbstractMessage msg) {
            if (ServerImpl.this.ring.hasRemoteNodes()) {
                return true;
            }
            this.sendMessageToClients(msg);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNodeFailedMessage(TcpDiscoveryNodeFailedMessage msg) {
            Object object;
            assert (msg != null);
            UUID sndId = msg.senderNodeId();
            if (sndId != null) {
                boolean contains;
                TcpDiscoveryNode sndNode = ServerImpl.this.ring.node(sndId);
                if (sndNode == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node failed message sent from unknown node: " + msg);
                    }
                    return;
                }
                UUID creatorId = msg.creatorNodeId();
                assert (creatorId != null) : msg;
                object = ServerImpl.this.mux;
                synchronized (object) {
                    contains = ServerImpl.this.failedNodes.containsKey(sndNode) || ServerImpl.this.ring.node(creatorId) == null;
                }
                if (contains) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node failed message sent from node which is about to fail: " + msg);
                    }
                    return;
                }
            }
            UUID failedNodeId = msg.failedNodeId();
            TcpDiscoveryNode failedNode = ServerImpl.this.ring.node(failedNodeId);
            if (failedNode != null && failedNode.internalOrder() != msg.internalOrder()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Ignoring node failed message since node internal order does not match [msg=" + msg + ", node=" + failedNode + ']');
                }
                return;
            }
            if (failedNode != null) {
                boolean skipUpdateFailedNodes;
                assert (!failedNode.isLocal() || !msg.verified()) : msg;
                boolean bl = skipUpdateFailedNodes = msg.force() && !msg.verified();
                if (!skipUpdateFailedNodes) {
                    object = ServerImpl.this.mux;
                    synchronized (object) {
                        if (!ServerImpl.this.failedNodes.containsKey(failedNode)) {
                            ServerImpl.this.failedNodes.put(failedNode, msg.senderNodeId() != null ? msg.senderNodeId() : ServerImpl.this.getLocalNodeId());
                        }
                    }
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding node failed message since node was not found: " + msg);
                }
                return;
            }
            boolean locNodeCoord = ServerImpl.this.isLocalNodeCoordinator();
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (locNodeCoord) {
                if (msg.verified()) {
                    this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                    return;
                }
                if (locNodeId.equals(failedNodeId)) {
                    this.segmentLocalNodeOnSendFail(null);
                    return;
                }
                msg.verify(locNodeId);
            }
            if (msg.verified()) {
                Object creatorNode;
                long topVer;
                if (!ServerImpl.this.nodeCompactRepresentationSupported) {
                    ServerImpl.this.nodeCompactRepresentationSupported = ServerImpl.this.allNodesSupport(IgniteFeatures.TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION, IgniteDiscoverySpi.ALL_NODES);
                }
                failedNode = ServerImpl.this.ring.removeNode(failedNodeId);
                ServerImpl.this.interruptPing(failedNode);
                assert (failedNode != null);
                if (locNodeCoord) {
                    topVer = ServerImpl.this.ring.incrementTopologyVersion();
                    msg.topologyVersion(topVer);
                } else {
                    topVer = msg.topologyVersion();
                    assert (topVer > 0L) : "Topology version is empty for message: " + msg;
                    boolean b = ServerImpl.this.ring.topologyVersion(topVer);
                    assert (b) : "Topology version has not been updated: [ring=" + ServerImpl.access$1500(ServerImpl.this) + ", msg=" + msg + ", lastMsg=" + this.lastMsg + ", spiState=" + (Object)((Object)ServerImpl.access$2200(ServerImpl.this)) + ']';
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Topology version has been updated: [ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                    }
                    this.lastMsg = msg;
                }
                Object b = ServerImpl.this.mux;
                synchronized (b) {
                    ClientMessageWorker worker;
                    ServerImpl.this.failedNodes.remove(failedNode);
                    ServerImpl.this.leavingNodes.remove(failedNode);
                    ServerImpl.this.failedNodesMsgSent.remove(failedNode.id());
                    if (!msg.force() && (worker = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.remove(failedNode.id())) != null && worker.runner() != null) {
                        worker.runner().interrupt();
                    }
                }
                if (msg.warning() != null && !msg.creatorNodeId().equals(ServerImpl.this.getLocalNodeId())) {
                    creatorNode = ServerImpl.this.ring.node(msg.creatorNodeId());
                    U.warn(this.log, "Received EVT_NODE_FAILED event with warning [nodeInitiatedEvt=" + (creatorNode != null ? creatorNode : msg.creatorNodeId()) + ", msg=" + msg.warning() + ']');
                }
                creatorNode = ServerImpl.this.mux;
                synchronized (creatorNode) {
                    ServerImpl.this.joiningNodes.remove(failedNode.id());
                }
                boolean notified = ServerImpl.this.notifyDiscovery(12, topVer, failedNode, msg.spanContainer());
                this.notifiedDiscovery.set(notified);
                ServerImpl.this.spi.stats.onNodeFailed();
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unable to send message across the ring (topology has no remote nodes): " + msg);
                }
                U.closeQuiet(this.sock);
                this.processPendingMessagesLocally(msg);
            }
            this.checkPendingCustomMessages();
        }

        private void processStatusCheckMessage(final TcpDiscoveryStatusCheckMessage msg) {
            assert (msg != null);
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (msg.failedNodeId() != null) {
                if (locNodeId.equals(msg.failedNodeId())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Status check message discarded (suspect node is local node).");
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Status check message discarded (local node is the sender of the status message).");
                    }
                    return;
                }
                if (ServerImpl.this.isLocalNodeCoordinator() && ServerImpl.this.ring.node(msg.creatorNodeId()) == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Status check message discarded (creator node is not in topology).");
                    }
                    return;
                }
            } else {
                if (ServerImpl.this.isLocalNodeCoordinator() && !locNodeId.equals(msg.creatorNodeId())) {
                    if (ServerImpl.this.ring.node(msg.creatorNodeId()) != null) {
                        msg.status(1);
                        this.sendMessageAcrossRing(msg);
                    } else {
                        msg.status(2);
                        ServerImpl.this.utilityPool.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block14: {
                                    Object object = ServerImpl.this.mux;
                                    synchronized (object) {
                                        if (ServerImpl.this.spiState == TcpDiscoverySpiState.DISCONNECTED) {
                                            if (RingMessageWorker.this.log.isDebugEnabled()) {
                                                RingMessageWorker.this.log.debug("Ignoring status check request, SPI is already disconnected: " + msg);
                                            }
                                            return;
                                        }
                                    }
                                    TcpDiscoveryStatusCheckMessage msg0 = msg;
                                    if (F.contains(msg.failedNodes(), msg.creatorNodeId())) {
                                        msg0 = ServerImpl.this.createTcpDiscoveryStatusCheckMessage(msg.creatorNode(), msg.creatorNodeId(), msg.failedNodeId());
                                        if (msg0 == null) {
                                            RingMessageWorker.this.log.debug("Status check message discarded (creator node is not in topology).");
                                            return;
                                        }
                                        msg0.failedNodes(null);
                                        for (UUID failedNodeId : msg.failedNodes()) {
                                            if (failedNodeId.equals(msg.creatorNodeId())) continue;
                                            msg0.addFailedNode(failedNodeId);
                                        }
                                    }
                                    try {
                                        RingMessageWorker.this.trySendMessageDirectly(msg0.creatorNodeAddrs(), msg0.creatorNodeId(), msg0);
                                        if (RingMessageWorker.this.log.isDebugEnabled()) {
                                            RingMessageWorker.this.log.debug("Responded to status check message [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']');
                                        }
                                    }
                                    catch (IgniteSpiException e) {
                                        if (e.hasCause(SocketException.class)) {
                                            if (RingMessageWorker.this.log.isDebugEnabled()) {
                                                RingMessageWorker.this.log.debug("Failed to respond to status check message (connection refused) [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']');
                                            }
                                            ServerImpl.this.onException("Failed to respond to status check message (connection refused) [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']', e);
                                        }
                                        if (ServerImpl.this.spi.isNodeStopping0()) break block14;
                                        if (ServerImpl.this.pingNode(msg0.creatorNodeId())) {
                                            U.error(RingMessageWorker.this.log, "Failed to respond to status check message [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']', e);
                                        }
                                        if (!RingMessageWorker.this.log.isDebugEnabled()) break block14;
                                        RingMessageWorker.this.log.debug("Failed to respond to status check message (did the node stop?)[recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']');
                                    }
                                }
                            }
                        });
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() == null && U.millisSinceNanos(ServerImpl.this.locNode.lastUpdateTimeNanos()) < ServerImpl.this.spi.metricsUpdateFreq) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Status check message discarded (local node receives updates).");
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() == null && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.CONNECTED) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Status check message discarded (local node is not connected to topology).");
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() != null) {
                    if (ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.CONNECTED) {
                        return;
                    }
                    if (msg.status() == 1) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received OK status response from coordinator: " + msg);
                        }
                    } else {
                        if (msg.status() == 2) {
                            U.warn(this.log, "Node is out of topology (probably, due to short-time network problems).");
                            ServerImpl.this.notifyDiscovery(14, ServerImpl.this.ring.topologyVersion(), ServerImpl.this.locNode);
                            return;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Status value was not updated in status response: " + msg);
                        }
                    }
                    return;
                }
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMetricsUpdateMessage(TcpDiscoveryMetricsUpdateMessage msg) {
            assert (msg != null);
            assert (!msg.client());
            int laps = msg.passedLaps(ServerImpl.this.getLocalNodeId());
            msg = this.metricsMsgFilter.pollActualMessage(laps, msg);
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (ServerImpl.this.ring.node(msg.creatorNodeId()) == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding metrics update message issued by unknown node [msg=" + msg + ", ring=" + ServerImpl.this.ring + ']');
                }
                return;
            }
            if (ServerImpl.this.isLocalNodeCoordinator() && !locNodeId.equals(msg.creatorNodeId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding metrics update message issued by non-coordinator node: " + msg);
                }
                return;
            }
            if (!ServerImpl.this.isLocalNodeCoordinator() && locNodeId.equals(msg.creatorNodeId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding metrics update message issued by local node (node is no more coordinator): " + msg);
                }
                return;
            }
            if (laps == 2) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Discarding metrics update message that has made two passes: " + msg);
                }
                return;
            }
            long tsNanos = System.nanoTime();
            if (ServerImpl.this.spiStateCopy() == TcpDiscoverySpiState.CONNECTED && msg.hasMetrics()) {
                ServerImpl.this.processMsgCacheMetrics(msg, tsNanos);
            }
            if (this.sendMessageToRemotes(msg)) {
                if (laps == 0 && ServerImpl.this.spiStateCopy() == TcpDiscoverySpiState.CONNECTED) {
                    msg.setMetrics(locNodeId, ServerImpl.this.spi.metricsProvider.metrics());
                    msg.setCacheMetrics(locNodeId, ServerImpl.this.spi.metricsProvider.cacheMetrics());
                    for (Map.Entry e : ServerImpl.this.clientMsgWorkers.entrySet()) {
                        UUID nodeId = (UUID)e.getKey();
                        ClusterMetrics metrics = ((ClientMessageWorker)e.getValue()).metrics();
                        if (metrics != null) {
                            msg.setClientMetrics(locNodeId, nodeId, metrics);
                        }
                        msg.addClientNodeId(nodeId);
                    }
                } else {
                    ServerImpl.removeMetrics(msg, locNodeId);
                    Collection<UUID> clientNodeIds = msg.clientNodeIds();
                    for (TcpDiscoveryNode clientNode : ServerImpl.this.ring.clientNodes()) {
                        boolean failedNode;
                        boolean aliveCheck;
                        if (!clientNode.visible()) continue;
                        if (clientNodeIds.contains(clientNode.id())) {
                            clientNode.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
                            continue;
                        }
                        if (!clientNode.clientAliveTimeSet()) {
                            clientNode.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
                        }
                        if ((aliveCheck = clientNode.isClientAlive()) || !ServerImpl.this.isLocalNodeCoordinator()) continue;
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Client node failed liveness check. Node: " + clientNode);
                        }
                        Object object = ServerImpl.this.mux;
                        synchronized (object) {
                            failedNode = ServerImpl.this.failedNodes.containsKey(clientNode);
                        }
                        if (failedNode) continue;
                        U.warn(this.log, "Failing client node due to not receiving metrics updates from client node within 'IgniteConfiguration.clientFailureDetectionTimeout' (consider increasing configuration property) [timeout=" + ServerImpl.this.spi.clientFailureDetectionTimeout() + ", timeSinceClientLivenessCheckFailed: " + U.nanosToMillis(System.nanoTime() - clientNode.aliveCheckTimeNanos()) + ", node=" + clientNode + ']');
                        TcpDiscoveryNodeFailedMessage nodeFailedMsg = new TcpDiscoveryNodeFailedMessage(locNodeId, clientNode.id(), clientNode.internalOrder());
                        this.processNodeFailedMessage(nodeFailedMsg);
                    }
                }
                if (this.sendMessageToRemotes(msg)) {
                    this.sendMessageAcrossRing(msg);
                }
            } else {
                ServerImpl.this.locNode.lastUpdateTimeNanos(tsNanos);
                ServerImpl.this.notifyDiscovery(13, ServerImpl.this.ring.topologyVersion(), ServerImpl.this.locNode);
            }
        }

        private void processDiscardMessage(TcpDiscoveryDiscardMessage msg) {
            assert (msg != null);
            IgniteUuid msgId = msg.msgId();
            assert (msgId != null);
            if (ServerImpl.this.isLocalNodeCoordinator()) {
                if (!ServerImpl.this.getLocalNodeId().equals(msg.verifierNodeId())) {
                    msg.verify(ServerImpl.this.getLocalNodeId());
                } else {
                    return;
                }
            }
            if (msg.verified()) {
                this.pendingMsgs.discard(msgId, msg.customMessageDiscard());
            }
            if (ServerImpl.this.ring.hasRemoteNodes()) {
                this.sendMessageAcrossRing(msg);
            }
        }

        private void processClientPingRequest(final TcpDiscoveryClientPingRequest msg) {
            ServerImpl.this.utilityPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ServerImpl.this.mux;
                    synchronized (object) {
                        if (ServerImpl.this.spiState == TcpDiscoverySpiState.DISCONNECTED) {
                            if (RingMessageWorker.this.log.isDebugEnabled()) {
                                RingMessageWorker.this.log.debug("Ignoring ping request, SPI is already disconnected: " + msg);
                            }
                            return;
                        }
                    }
                    ClientMessageWorker worker = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(msg.creatorNodeId());
                    if (worker == null) {
                        if (RingMessageWorker.this.log.isDebugEnabled()) {
                            RingMessageWorker.this.log.debug("Ping request from dead client node, will be skipped: " + msg.creatorNodeId());
                        }
                    } else {
                        boolean res;
                        try {
                            res = ServerImpl.this.pingNode(msg.nodeToPing());
                        }
                        catch (IgniteSpiException e) {
                            RingMessageWorker.this.log.error("Failed to ping node [nodeToPing=" + msg.nodeToPing() + ']', e);
                            res = false;
                        }
                        TcpDiscoveryClientPingResponse pingRes = new TcpDiscoveryClientPingResponse(ServerImpl.this.getLocalNodeId(), msg.nodeToPing(), res);
                        pingRes.verify(ServerImpl.this.getLocalNodeId());
                        worker.addMessage(pingRes);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCustomMessage(TcpDiscoveryCustomEventMessage msg, boolean waitForNotification) {
            if (ServerImpl.this.isLocalNodeCoordinator()) {
                if (this.postponeUndeliveredMessages(msg)) {
                    return;
                }
                if (!msg.verified()) {
                    msg.verify(ServerImpl.this.getLocalNodeId());
                    msg.spanContainer().span().addLog(() -> "Verified");
                    msg.topologyVersion(ServerImpl.this.ring.topologyVersion());
                    if (this.pendingMsgs.procCustomMsgs.add(msg.id())) {
                        this.notifyDiscoveryListener(msg, waitForNotification);
                        if (this.sendMessageToRemotes(msg)) {
                            this.sendMessageAcrossRing(msg);
                        } else {
                            this.registerPendingMessage(msg);
                            this.processCustomMessage(msg, waitForNotification);
                        }
                    }
                    msg.message(null, msg.messageBytes());
                } else {
                    DiscoverySpiCustomMessage nextMsg;
                    this.addMessage(new TcpDiscoveryDiscardMessage(ServerImpl.this.getLocalNodeId(), msg.id(), true));
                    DiscoverySpiCustomMessage msgObj = null;
                    try {
                        msgObj = msg.message(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                    }
                    catch (Throwable e) {
                        U.error(this.log, "Failed to unmarshal discovery custom message.", e);
                    }
                    if (msgObj != null && (nextMsg = msgObj.ackMessage()) != null) {
                        try {
                            TcpDiscoveryCustomEventMessage ackMsg = new TcpDiscoveryCustomEventMessage(ServerImpl.this.getLocalNodeId(), nextMsg, U.marshal(ServerImpl.this.spi.marshaller(), (Object)nextMsg));
                            ackMsg.topologyVersion(msg.topologyVersion());
                            this.processCustomMessage(ackMsg, waitForNotification);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.log, "Failed to marshal discovery custom message.", e);
                        }
                    }
                }
            } else {
                TcpDiscoverySpiState state0;
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    state0 = ServerImpl.this.spiState;
                }
                if (msg.verified() && msg.topologyVersion() != ServerImpl.this.ring.topologyVersion()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding custom event message [msg=" + msg + ", ring=" + ServerImpl.this.ring + ']');
                    }
                    return;
                }
                if (msg.verified() && state0 == TcpDiscoverySpiState.CONNECTED && this.pendingMsgs.procCustomMsgs.add(msg.id())) {
                    assert (msg.topologyVersion() == ServerImpl.this.ring.topologyVersion()) : "msg: " + msg + ", topVer=" + ServerImpl.access$1500(ServerImpl.this).topologyVersion();
                    this.notifyDiscoveryListener(msg, waitForNotification);
                }
                msg.message(null, msg.messageBytes());
                if (this.sendMessageToRemotes(msg)) {
                    this.sendMessageAcrossRing(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean postponeUndeliveredMessages(TcpDiscoveryCustomEventMessage msg) {
            boolean delayMsg;
            boolean joiningEmpty;
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                joiningEmpty = ServerImpl.this.joiningNodes.isEmpty();
            }
            boolean bl = delayMsg = msg.topologyVersion() == 0L && !joiningEmpty;
            if (delayMsg) {
                Object object2 = ServerImpl.this.mux;
                synchronized (object2) {
                    ServerImpl.this.pendingCustomMsgs.add(msg);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Delay custom message processing, there are joining nodes [msg=" + msg + ", joiningNodes=" + ServerImpl.this.joiningNodes + ']');
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFailedNodesList() {
            ArrayList<TcpDiscoveryNodeFailedMessage> msgs = null;
            Iterator iterator = ServerImpl.this.mux;
            synchronized (iterator) {
                Iterator it;
                if (!ServerImpl.this.failedNodes.isEmpty()) {
                    it = ServerImpl.this.failedNodes.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        TcpDiscoveryNode node = (TcpDiscoveryNode)e.getKey();
                        UUID failSndNode = (UUID)e.getValue();
                        if (ServerImpl.this.ring.node(node.id()) == null) {
                            it.remove();
                            continue;
                        }
                        if (ServerImpl.this.nodeAlive(failSndNode) || ServerImpl.this.failedNodesMsgSent.contains(node.id())) continue;
                        if (msgs == null) {
                            msgs = new ArrayList<TcpDiscoveryNodeFailedMessage>();
                        }
                        msgs.add(new TcpDiscoveryNodeFailedMessage(ServerImpl.this.getLocalNodeId(), node.id(), node.internalOrder()));
                        ServerImpl.this.failedNodesMsgSent.add(node.id());
                    }
                }
                if (!ServerImpl.this.failedNodesMsgSent.isEmpty()) {
                    it = ServerImpl.this.failedNodesMsgSent.iterator();
                    while (it.hasNext()) {
                        UUID nodeId = (UUID)((Object)it.next());
                        if (ServerImpl.this.ring.node(nodeId) != null) continue;
                        it.remove();
                    }
                }
            }
            if (msgs != null) {
                for (TcpDiscoveryNodeFailedMessage msg : msgs) {
                    U.warn(this.log, "Added node failed message for node from failed nodes list: " + msg);
                    this.addMessage(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkPendingCustomMessages() {
            boolean joiningEmpty;
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                joiningEmpty = ServerImpl.this.joiningNodes.isEmpty();
            }
            if (joiningEmpty && ServerImpl.this.isLocalNodeCoordinator()) {
                TcpDiscoveryCustomEventMessage msg;
                while ((msg = this.pollPendingCustomMessage()) != null) {
                    this.processCustomMessage(msg, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private TcpDiscoveryCustomEventMessage pollPendingCustomMessage() {
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                return (TcpDiscoveryCustomEventMessage)ServerImpl.this.pendingCustomMsgs.poll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyDiscoveryListener(TcpDiscoveryCustomEventMessage msg, boolean waitForNotification) {
            TreeMap<Long, Collection<ClusterNode>> hist;
            DiscoverySpiListener lsnr = ServerImpl.this.spi.lsnr;
            TcpDiscoverySpiState spiState = ServerImpl.this.spiStateCopy();
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                hist = new TreeMap<Long, Collection<ClusterNode>>(ServerImpl.this.topHist);
            }
            Collection snapshot = (Collection)hist.get(msg.topologyVersion());
            if (lsnr != null && (spiState == TcpDiscoverySpiState.CONNECTED || spiState == TcpDiscoverySpiState.DISCONNECTING)) {
                DiscoverySpiCustomMessage msgObj;
                TcpDiscoveryNode node = ServerImpl.this.ring.node(msg.creatorNodeId());
                if (node == null) {
                    return;
                }
                try {
                    msgObj = msg.message(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                }
                catch (Throwable t) {
                    throw new IgniteException("Failed to unmarshal discovery custom message: " + msg, t);
                }
                IgniteFuture<?> fut = lsnr.onDiscovery(new DiscoveryNotification(18, msg.topologyVersion(), node, snapshot, hist, msgObj, msg.spanContainer()));
                this.notifiedDiscovery.set(true);
                if (waitForNotification || msgObj.isMutable()) {
                    this.blockingSectionBegin();
                    try {
                        fut.get();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
                if (msgObj.isMutable()) {
                    try {
                        msg.message(msgObj, U.marshal(ServerImpl.this.spi.marshaller(), (Object)msgObj));
                    }
                    catch (Throwable t) {
                        throw new IgniteException("Failed to marshal mutable discovery message: " + msgObj, t);
                    }
                }
            }
        }

        private void sendMetricsUpdateMessage() {
            long elapsed = ServerImpl.this.spi.metricsUpdateFreq - U.millisSinceNanos(this.lastTimeMetricsUpdateMsgSentNanos);
            if (elapsed > 0L || !ServerImpl.this.isLocalNodeCoordinator()) {
                return;
            }
            TcpDiscoveryMetricsUpdateMessage msg = new TcpDiscoveryMetricsUpdateMessage(ServerImpl.this.getConfiguredNodeId());
            msg.verify(ServerImpl.this.getLocalNodeId());
            ServerImpl.this.msgWorker.addMessage(msg);
            this.lastTimeMetricsUpdateMsgSentNanos = System.nanoTime();
        }

        private void checkMetricsReceiving() {
            long updateTimeNanos;
            if (this.lastTimeStatusMsgSentNanos < ServerImpl.this.locNode.lastUpdateTimeNanos()) {
                this.lastTimeStatusMsgSentNanos = ServerImpl.this.locNode.lastUpdateTimeNanos();
            }
            if (U.millisSinceNanos(updateTimeNanos = Math.max(this.lastTimeStatusMsgSentNanos, this.lastRingMsgTimeNanos)) < this.metricsCheckFreq) {
                return;
            }
            ServerImpl.this.msgWorker.addMessage(ServerImpl.this.createTcpDiscoveryStatusCheckMessage(ServerImpl.this.locNode, ServerImpl.this.locNode.id(), null));
            this.lastTimeStatusMsgSentNanos = System.nanoTime();
        }

        private void checkConnection() {
            long elapsed;
            Boolean hasRemoteSrvNodes = null;
            if (ServerImpl.this.spi.failureDetectionTimeoutEnabled() && !this.failureThresholdReached && U.millisSinceNanos(ServerImpl.this.locNode.lastExchangeTimeNanos()) >= this.connCheckThreshold && ServerImpl.this.spiStateCopy() == TcpDiscoverySpiState.CONNECTED && (hasRemoteSrvNodes = Boolean.valueOf(ServerImpl.this.ring.hasRemoteServerNodes())).booleanValue()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Local node seems to be disconnected from topology (failure detection timeout is reached) [failureDetectionTimeout=" + ServerImpl.this.spi.failureDetectionTimeout() + ", connCheckInterval=" + 500 + ']');
                }
                this.failureThresholdReached = true;
                this.lastTimeConnCheckMsgSent = 0L;
            }
            if ((elapsed = this.lastTimeConnCheckMsgSent + 500L - U.currentTimeMillis()) > 0L) {
                return;
            }
            if (hasRemoteSrvNodes == null) {
                hasRemoteSrvNodes = ServerImpl.this.ring.hasRemoteServerNodes();
            }
            if (hasRemoteSrvNodes.booleanValue()) {
                this.sendMessageAcrossRing(new TcpDiscoveryConnectionCheckMessage(ServerImpl.this.locNode));
                this.lastTimeConnCheckMsgSent = U.currentTimeMillis();
            }
        }

        @Override
        public String toString() {
            return String.format("%s, nextNode=[%s]", super.toString(), this.next);
        }
    }

    private static class PendingMessages
    implements Iterable<TcpDiscoveryAbstractMessage> {
        private static final int MAX = 1024;
        private final Queue<PendingMessage> msgs = new ArrayDeque<PendingMessage>(2048);
        private Set<IgniteUuid> procCustomMsgs = new GridBoundedLinkedHashSet<IgniteUuid>(2048);
        private IgniteUuid discardId;
        private IgniteUuid customDiscardId;

        private PendingMessages() {
        }

        void add(TcpDiscoveryAbstractMessage msg) {
            this.msgs.add(new PendingMessage(msg));
            while (this.msgs.size() > 1024) {
                PendingMessage queueHead = this.msgs.peek();
                assert (queueHead != null);
                if (queueHead.customMsg && this.customDiscardId != null) {
                    if (queueHead.id.equals(this.customDiscardId)) {
                        this.customDiscardId = null;
                    }
                } else {
                    if (queueHead.customMsg || this.discardId == null) break;
                    if (queueHead.id.equals(this.discardId)) {
                        this.discardId = null;
                    }
                }
                this.msgs.poll();
            }
        }

        void reset(@Nullable Collection<TcpDiscoveryAbstractMessage> msgs, @Nullable IgniteUuid discardId, @Nullable IgniteUuid customDiscardId) {
            this.msgs.clear();
            if (msgs != null) {
                for (TcpDiscoveryAbstractMessage msg : msgs) {
                    this.msgs.add(new PendingMessage(msg));
                }
            }
            this.discardId = discardId;
            this.customDiscardId = customDiscardId;
        }

        void discard(IgniteUuid id, boolean custom) {
            if (!this.hasPendingMessage(custom, id)) {
                return;
            }
            if (custom) {
                this.customDiscardId = id;
            } else {
                this.discardId = id;
            }
            this.cleanup();
        }

        private boolean hasPendingMessage(boolean custom, IgniteUuid id) {
            for (PendingMessage msg : this.msgs) {
                if (msg.customMsg != custom || !msg.id.equals(id)) continue;
                return true;
            }
            return false;
        }

        void cleanup() {
            boolean skipCustomMsg;
            Iterator msgIt = this.msgs.iterator();
            boolean skipMsg = this.discardId != null;
            boolean bl = skipCustomMsg = this.customDiscardId != null;
            while (msgIt.hasNext()) {
                PendingMessage msg = (PendingMessage)msgIt.next();
                if (msg.customMsg) {
                    if (!skipCustomMsg) continue;
                    assert (this.customDiscardId != null);
                    if (!F.eq(this.customDiscardId, msg.id)) continue;
                    msg.msg = null;
                    if (!msg.verified) continue;
                    return;
                }
                if (!skipMsg) continue;
                assert (this.discardId != null);
                if (!F.eq(this.discardId, msg.id)) continue;
                msg.msg = null;
                if (!msg.verified) continue;
                return;
            }
        }

        @Override
        public Iterator<TcpDiscoveryAbstractMessage> iterator() {
            return new SkipIterator();
        }

        private class SkipIterator
        implements Iterator<TcpDiscoveryAbstractMessage> {
            private boolean skipMsg;
            private boolean skipCustomMsg;
            private Iterator<PendingMessage> msgIt;
            private TcpDiscoveryAbstractMessage next;

            private SkipIterator() {
                this.skipMsg = PendingMessages.this.discardId != null;
                this.skipCustomMsg = PendingMessages.this.customDiscardId != null;
                this.msgIt = PendingMessages.this.msgs.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public TcpDiscoveryAbstractMessage next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                TcpDiscoveryAbstractMessage next0 = this.next;
                this.advance();
                return next0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                this.next = null;
                while (this.msgIt.hasNext()) {
                    PendingMessage msg0 = this.msgIt.next();
                    if (msg0.customMsg) {
                        if (this.skipCustomMsg) {
                            assert (PendingMessages.this.customDiscardId != null);
                            if (!F.eq(PendingMessages.this.customDiscardId, msg0.id) || !msg0.verified) continue;
                            this.skipCustomMsg = false;
                            continue;
                        }
                    } else if (this.skipMsg) {
                        assert (PendingMessages.this.discardId != null);
                        if (!F.eq(PendingMessages.this.discardId, msg0.id) || !msg0.verified) continue;
                        this.skipMsg = false;
                        continue;
                    }
                    if (msg0.msg == null) continue;
                    this.next = msg0.msg;
                    break;
                }
            }
        }
    }

    private static class PendingMessage {
        TcpDiscoveryAbstractMessage msg;
        final boolean customMsg;
        final IgniteUuid id;
        final boolean verified;

        PendingMessage(TcpDiscoveryAbstractMessage msg) {
            assert (msg != null && msg.id() != null) : msg;
            this.msg = msg;
            this.id = msg.id();
            this.customMsg = msg instanceof TcpDiscoveryCustomEventMessage;
            this.verified = msg.verified();
        }

        public String toString() {
            return S.toString(PendingMessage.class, this, "msg", (Object)this.msg, "customMsg", (Object)this.customMsg, "id", (Object)this.id);
        }
    }

    private class EnsuredMessageHistory {
        private final GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> msgs = new GridBoundedLinkedHashSet(ServerImpl.access$2400());

        private EnsuredMessageHistory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(TcpDiscoveryAbstractMessage msg) {
            assert (ServerImpl.this.spi.ensured(msg) && msg.verified()) : msg;
            assert (U.hasDeclaredAnnotation(msg, TcpDiscoveryRedirectToClient.class)) : msg;
            if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                TcpDiscoveryNodeAddedMessage addedMsg = new TcpDiscoveryNodeAddedMessage((TcpDiscoveryNodeAddedMessage)msg);
                msg = addedMsg;
                TcpDiscoveryNode node = addedMsg.node();
                if (node.clientRouterNodeId() != null && !this.msgs.contains(msg)) {
                    Collection<TcpDiscoveryNode> allNodes = ServerImpl.this.ring.allNodes();
                    ArrayList<TcpDiscoveryNode> top = new ArrayList<TcpDiscoveryNode>(allNodes.size());
                    for (TcpDiscoveryNode n0 : allNodes) {
                        assert (n0.internalOrder() > 0L) : n0;
                        if (n0.internalOrder() >= node.internalOrder()) continue;
                        top.add(n0);
                    }
                    addedMsg.clientTopology(top);
                }
                if (addedMsg.gridDiscoveryData() != null) {
                    addedMsg.clearDiscoveryData();
                }
            } else if (msg instanceof TcpDiscoveryNodeAddFinishedMessage) {
                TcpDiscoveryNodeAddFinishedMessage addFinishMsg = (TcpDiscoveryNodeAddFinishedMessage)msg;
                if (addFinishMsg.clientDiscoData() != null) {
                    addFinishMsg = new TcpDiscoveryNodeAddFinishedMessage(addFinishMsg);
                    msg = addFinishMsg;
                    DiscoveryDataPacket discoData = addFinishMsg.clientDiscoData();
                    HashSet<Integer> mrgdCmnData = new HashSet<Integer>();
                    HashSet<UUID> mrgdSpecData = new HashSet<UUID>();
                    boolean allMerged = false;
                    for (TcpDiscoveryAbstractMessage msg0 : this.msgs) {
                        DiscoveryDataPacket existingDiscoData;
                        if (msg0 instanceof TcpDiscoveryNodeAddFinishedMessage && (existingDiscoData = ((TcpDiscoveryNodeAddFinishedMessage)msg0).clientDiscoData()) != null) {
                            allMerged = discoData.mergeDataFrom(existingDiscoData, mrgdCmnData, mrgdSpecData);
                        }
                        if (!allMerged) continue;
                        break;
                    }
                }
            } else if (msg instanceof TcpDiscoveryNodeLeftMessage) {
                this.clearClientAddFinished(msg.creatorNodeId());
            } else if (msg instanceof TcpDiscoveryNodeFailedMessage) {
                this.clearClientAddFinished(((TcpDiscoveryNodeFailedMessage)msg).failedNodeId());
            } else if (msg instanceof TcpDiscoveryCustomEventMessage) {
                TcpDiscoveryCustomEventMessage msg0 = (TcpDiscoveryCustomEventMessage)msg;
                msg = new TcpDiscoveryCustomEventMessage(msg0);
                ((TcpDiscoveryCustomEventMessage)msg).clearMessage();
            }
            GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> gridBoundedLinkedHashSet = this.msgs;
            synchronized (gridBoundedLinkedHashSet) {
                this.msgs.add(msg);
            }
        }

        private void clearClientAddFinished(UUID clientId) {
            for (TcpDiscoveryAbstractMessage msg : this.msgs) {
                TcpDiscoveryNodeAddFinishedMessage addFinishMsg;
                if (!(msg instanceof TcpDiscoveryNodeAddFinishedMessage) || (addFinishMsg = (TcpDiscoveryNodeAddFinishedMessage)msg).clientDiscoData() == null || !clientId.equals(addFinishMsg.nodeId())) continue;
                addFinishMsg.clientDiscoData(null);
                addFinishMsg.clientNodeAttributes(null);
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Collection<TcpDiscoveryAbstractMessage> messages(@Nullable IgniteUuid lastMsgId, TcpDiscoveryNode node, @Nullable IgniteBiPredicate<TcpDiscoveryAbstractMessage, ClusterNode> filterPred) {
            boolean skip;
            ArrayList<TcpDiscoveryAbstractMessage> cp;
            assert (node != null && node.clientRouterNodeId() != null) : node;
            if (lastMsgId == null) {
                ArrayList<TcpDiscoveryAbstractMessage> res = null;
                GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> gridBoundedLinkedHashSet = this.msgs;
                synchronized (gridBoundedLinkedHashSet) {
                    for (TcpDiscoveryAbstractMessage msg : this.msgs) {
                        if (msg instanceof TcpDiscoveryNodeAddedMessage && node.id().equals(((TcpDiscoveryNodeAddedMessage)msg).node().id())) {
                            res = new ArrayList<TcpDiscoveryAbstractMessage>(this.msgs.size());
                        }
                        if (res == null || filterPred != null && !filterPred.apply(msg, node)) continue;
                        res.add(this.prepare(msg, node.id()));
                    }
                }
                if (ServerImpl.this.log.isDebugEnabled()) {
                    if (res == null) {
                        ServerImpl.this.log.debug("Failed to find node added message [node=" + node + ']');
                    } else {
                        ServerImpl.this.log.debug("Found add added message [node=" + node + ", hist=" + res + ']');
                    }
                }
                return res;
            }
            GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> gridBoundedLinkedHashSet = this.msgs;
            synchronized (gridBoundedLinkedHashSet) {
                if (this.msgs.isEmpty()) {
                    return Collections.emptyList();
                }
                cp = new ArrayList<TcpDiscoveryAbstractMessage>(this.msgs.size());
                skip = true;
                for (TcpDiscoveryAbstractMessage msg : this.msgs) {
                    if (skip) {
                        if (!msg.id().equals(lastMsgId)) continue;
                        skip = false;
                        continue;
                    }
                    if (filterPred != null && !filterPred.apply(msg, node)) continue;
                    cp.add(this.prepare(msg, node.id()));
                }
            }
            ArrayList<TcpDiscoveryAbstractMessage> arrayList = cp = !skip ? cp : null;
            if (ServerImpl.this.log.isDebugEnabled()) {
                if (cp == null) {
                    ServerImpl.this.log.debug("Failed to find messages history [node=" + node + ", lastMsgId=" + lastMsgId + ']');
                } else {
                    ServerImpl.this.log.debug("Found messages history [node=" + node + ", hist=" + cp + ']');
                }
            }
            return cp;
        }

        private TcpDiscoveryAbstractMessage prepare(TcpDiscoveryAbstractMessage msg, UUID destNodeId) {
            TcpDiscoveryNodeAddedMessage addedMsg;
            if (msg instanceof TcpDiscoveryNodeAddedMessage && (addedMsg = (TcpDiscoveryNodeAddedMessage)msg).node().id().equals(destNodeId)) {
                assert (addedMsg.clientTopology() != null) : addedMsg;
                TcpDiscoveryNodeAddedMessage msg0 = new TcpDiscoveryNodeAddedMessage(addedMsg);
                ServerImpl.this.prepareNodeAddedMessage(msg0, destNodeId, null, null);
                msg0.topology(addedMsg.clientTopology());
                return msg0;
            }
            return msg;
        }
    }

    private class IpFinderCleaner
    extends IgniteSpiThread {
        private IpFinderCleaner() {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-ip-finder-cleaner", ServerImpl.this.log);
            this.setPriority(ServerImpl.this.spi.threadPri);
        }

        @Override
        protected void body() throws InterruptedException {
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("IP finder cleaner has been started.");
            }
            while (!this.isInterrupted()) {
                Thread.sleep(ServerImpl.this.spi.ipFinderCleanFreq);
                if (ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.CONNECTED) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Stopping IP finder cleaner (SPI is not connected to topology).");
                    }
                    return;
                }
                if (!ServerImpl.this.isLocalNodeCoordinator() || !ServerImpl.this.spi.ipFinder.isShared()) continue;
                this.cleanIpFinder();
            }
        }

        private void cleanIpFinder() {
            assert (ServerImpl.this.spi.ipFinder.isShared());
            try {
                Collection<InetSocketAddress> missingAddrs;
                Collection<InetSocketAddress> currAddrs = F.flatCollections(F.viewReadOnly(ServerImpl.this.ring.allNodes(), new C1<TcpDiscoveryNode, Collection<InetSocketAddress>>(){

                    @Override
                    public Collection<InetSocketAddress> apply(TcpDiscoveryNode node) {
                        return node.clientRouterNodeId() == null ? ServerImpl.this.spi.getNodeAddresses(node) : Collections.emptyList();
                    }
                }, new IgnitePredicate[0]));
                Collection<InetSocketAddress> regAddrs = ServerImpl.this.spi.registeredAddresses();
                P1<InetSocketAddress> p = new P1<InetSocketAddress>(){
                    private final Map<InetSocketAddress, Boolean> pingResMap = new HashMap<InetSocketAddress, Boolean>();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean apply(InetSocketAddress addr) {
                        Boolean res = this.pingResMap.get(addr);
                        if (res == null) {
                            try {
                                res = ServerImpl.this.pingNode(addr, null, null) != null;
                            }
                            catch (IgniteCheckedException e) {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Failed to ping node [addr=" + addr + ", err=" + e.getMessage() + ']');
                                }
                                res = false;
                            }
                            finally {
                                this.pingResMap.put(addr, res);
                            }
                        }
                        return res == false;
                    }
                };
                ArrayList<InetSocketAddress> rmvAddrs = null;
                for (InetSocketAddress addr : regAddrs) {
                    boolean rmv = !F.contains(currAddrs, addr) && p.apply(addr);
                    if (!rmv) continue;
                    if (rmvAddrs == null) {
                        rmvAddrs = new ArrayList<InetSocketAddress>();
                    }
                    rmvAddrs.add(addr);
                }
                if (rmvAddrs != null) {
                    ServerImpl.this.spi.ipFinder.unregisterAddresses(rmvAddrs);
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Unregistered addresses from IP finder: " + rmvAddrs);
                    }
                }
                if (!(missingAddrs = F.view(currAddrs, F.notContains(regAddrs))).isEmpty()) {
                    ServerImpl.this.spi.ipFinder.registerAddresses(missingAddrs);
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Registered missing addresses in IP finder: " + missingAddrs);
                    }
                }
            }
            catch (IgniteSpiException e) {
                LT.error(ServerImpl.this.log, e, "Failed to clean IP finder up.");
            }
        }
    }
}

