/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.net.InetAddress;
import java.util.regex.Pattern;
import org.apache.ignite.internal.util.lang.gridfunc.AlwaysTruePredicate;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.communication.tcp.internal.NetworkInterfaceMatcher;

public class IPv4Matcher
extends NetworkInterfaceMatcher {
    private static final Pattern OCTET_PATTERN = Pattern.compile("\\d{1,3}");
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\d{1,3}\\s*-\\s*\\d{1,3}");
    private static final String WILDCARD_PATTERN = "*";
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final String INVALID_IPv4_PATTERN_ERR_MSG = "Invalid IPv4 address pattern: ";
    private static final IgnitePredicate<String> ALWAYS_TRUE = new AlwaysTruePredicate<String>();
    private final IgnitePredicate<String>[] segmentPred = new IgnitePredicate[4];

    public IPv4Matcher(String interfacePattern) {
        super(interfacePattern);
        String[] segments = this.networkInterfacePattern().split("\\.");
        if (segments.length != 4) {
            throw new IllegalArgumentException("Invalid IPv4 address pattern: '" + this.networkInterfacePattern() + '\'');
        }
        try {
            for (int s = 0; s < segments.length; ++s) {
                String segment = segments[s];
                if (OCTET_PATTERN.matcher(segment).matches()) {
                    int seg = Integer.parseInt(segment);
                    if (seg < 0 || seg > 255) {
                        throw new IllegalArgumentException("Invalid IPv4 address pattern: '" + this.networkInterfacePattern() + '\'');
                    }
                    this.segmentPred[s] = segmentToCheck -> segment.equals(segmentToCheck);
                    continue;
                }
                if (RANGE_PATTERN.matcher(segment).matches()) {
                    int max;
                    String[] range = segment.split("-");
                    if (range.length != 2) {
                        throw new IllegalArgumentException("Invalid IPv4 address pattern: '" + this.networkInterfacePattern() + '\'');
                    }
                    int min = Integer.parseInt(range[0].trim());
                    if (min > (max = Integer.parseInt(range[1].trim()))) {
                        throw new IllegalArgumentException("Invalid IPv4 address pattern: '" + this.networkInterfacePattern() + '\'');
                    }
                    this.segmentPred[s] = segmentToCheck -> {
                        try {
                            int seg = Integer.parseInt(segmentToCheck);
                            return seg >= min && seg <= max;
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    };
                    continue;
                }
                if (WILDCARD_PATTERN.equals(segments[s])) {
                    this.segmentPred[s] = ALWAYS_TRUE;
                    continue;
                }
                throw new IllegalArgumentException("Invalid IPv4 address pattern: '" + this.networkInterfacePattern() + '\'');
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid IPv4 address pattern: '" + this.networkInterfacePattern() + '\'');
        }
    }

    @Override
    boolean matches(InetAddress addr) {
        String[] segments = addr.getHostAddress().split("\\.");
        if (segments.length != 4) {
            return false;
        }
        for (int s = 0; s < segments.length; ++s) {
            if (this.segmentPred[s].apply(segments[s])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return S.toString(IPv4Matcher.class, this, super.toString());
    }
}

