/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.ssl;

import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.ignite.internal.ssl.SSLContextSpiWrapper;

public class SSLContextClientAuthWrapper
extends SSLContext {
    public SSLContextClientAuthWrapper(SSLContext delegate, boolean needClientAuth) {
        super(new SSLContextSpiWrapperImpl(delegate, needClientAuth), delegate.getProvider(), delegate.getProtocol());
    }

    private static class SSLContextSpiWrapperImpl
    extends SSLContextSpiWrapper {
        private final boolean needClientAuth;

        SSLContextSpiWrapperImpl(SSLContext sslContextDelegate, boolean needClientAuth) {
            super(sslContextDelegate);
            this.needClientAuth = needClientAuth;
        }

        @Override
        protected void configureSSLEngine(SSLEngine engine) {
            engine.setNeedClientAuth(this.needClientAuth);
        }

        @Override
        protected void configureSocket(Socket socket) {
            ((SSLSocket)socket).setNeedClientAuth(this.needClientAuth);
        }

        @Override
        protected void configureServerSocket(ServerSocket socket) {
            ((SSLServerSocket)socket).setNeedClientAuth(this.needClientAuth);
        }
    }
}

