/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.datastreamer;

import java.util.ArrayList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.util.lang.GridMapEntry;

public class PlatformDataStreamer
extends PlatformAbstractTarget {
    private static final int PLC_CONTINUE = 0;
    private static final int PLC_CLOSE = 1;
    private static final int PLC_CANCEL_CLOSE = 2;
    private static final int PLC_FLUSH = 3;
    private static final int OP_UPDATE = 1;
    private static final int OP_RECEIVER = 2;
    private static final int OP_ALLOW_OVERWRITE = 3;
    private static final int OP_SET_ALLOW_OVERWRITE = 4;
    private static final int OP_SKIP_STORE = 5;
    private static final int OP_SET_SKIP_STORE = 6;
    private static final int OP_PER_NODE_BUFFER_SIZE = 7;
    private static final int OP_SET_PER_NODE_BUFFER_SIZE = 8;
    private static final int OP_PER_NODE_PARALLEL_OPS = 9;
    private static final int OP_SET_PER_NODE_PARALLEL_OPS = 10;
    private static final int OP_LISTEN_TOPOLOGY = 11;
    private static final int OP_GET_TIMEOUT = 12;
    private static final int OP_SET_TIMEOUT = 13;
    private static final int OP_PER_THREAD_BUFFER_SIZE = 14;
    private static final int OP_SET_PER_THREAD_BUFFER_SIZE = 15;
    private final String cacheName;
    private final DataStreamerImpl ldr;
    private final boolean keepBinary;
    private volatile GridLocalEventListener lsnr;

    public PlatformDataStreamer(PlatformContext platformCtx, String cacheName, DataStreamerImpl ldr, boolean keepBinary) {
        super(platformCtx);
        this.cacheName = cacheName;
        this.ldr = ldr;
        this.keepBinary = keepBinary;
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                int plc = reader.readInt();
                if (plc == 2) {
                    this.platformCtx.kernalContext().event().removeLocalEventListener(this.lsnr, new int[0]);
                    this.ldr.close(true);
                } else {
                    long futPtr = reader.readLong();
                    int valsCnt = reader.readInt();
                    if (valsCnt > 0) {
                        ArrayList<GridMapEntry<Object, Object>> vals = new ArrayList<GridMapEntry<Object, Object>>(valsCnt);
                        for (int i = 0; i < valsCnt; ++i) {
                            vals.add(new GridMapEntry<Object, Object>(reader.readObjectDetached(), reader.readObjectDetached()));
                        }
                        PlatformFutureUtils.listen(this.platformCtx, this.ldr.addData(vals), futPtr, 9, (PlatformTarget)this);
                    }
                    if (plc == 1) {
                        this.platformCtx.kernalContext().event().removeLocalEventListener(this.lsnr, new int[0]);
                        this.ldr.close(false);
                    } else if (plc == 3) {
                        this.ldr.tryFlush();
                    } else assert (plc == 0);
                }
                return 1L;
            }
            case 2: {
                long ptr = reader.readLong();
                Object rec = reader.readObjectDetached();
                this.ldr.receiver(this.platformCtx.createStreamReceiver(rec, ptr, this.keepBinary));
                return 1L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public long processInLongOutLong(int type, final long val) throws IgniteCheckedException {
        switch (type) {
            case 4: {
                this.ldr.allowOverwrite(val == 1L);
                return 1L;
            }
            case 8: {
                this.ldr.perNodeBufferSize((int)val);
                return 1L;
            }
            case 15: {
                this.ldr.perThreadBufferSize((int)val);
                return 1L;
            }
            case 6: {
                this.ldr.skipStore(val == 1L);
                return 1L;
            }
            case 10: {
                this.ldr.perNodeParallelOperations((int)val);
                return 1L;
            }
            case 11: {
                this.lsnr = new GridLocalEventListener(){

                    @Override
                    public void onEvent(Event evt) {
                        DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                        long topVer = discoEvt.topologyVersion();
                        int topSize = PlatformDataStreamer.this.platformCtx.kernalContext().discovery().cacheNodes(PlatformDataStreamer.this.cacheName, new AffinityTopologyVersion(topVer)).size();
                        PlatformDataStreamer.this.platformCtx.gateway().dataStreamerTopologyUpdate(val, topVer, topSize);
                    }
                };
                this.platformCtx.kernalContext().event().addLocalEventListener(this.lsnr, 10, 12, 11);
                GridDiscoveryManager discoMgr = this.platformCtx.kernalContext().discovery();
                AffinityTopologyVersion topVer = (AffinityTopologyVersion)this.platformCtx.kernalContext().cache().context().exchange().lastTopologyFuture().get();
                int topSize = discoMgr.cacheNodes(this.cacheName, topVer).size();
                this.platformCtx.gateway().dataStreamerTopologyUpdate(val, topVer.topologyVersion(), topSize);
                return 1L;
            }
            case 3: {
                return this.ldr.allowOverwrite() ? 1L : 0L;
            }
            case 7: {
                return this.ldr.perNodeBufferSize();
            }
            case 14: {
                return this.ldr.perThreadBufferSize();
            }
            case 5: {
                return this.ldr.skipStore() ? 1L : 0L;
            }
            case 9: {
                return this.ldr.perNodeParallelOperations();
            }
            case 12: {
                return this.ldr.timeout();
            }
            case 13: {
                this.ldr.timeout(val);
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    public boolean allowOverwrite() {
        return this.ldr.allowOverwrite();
    }

    public void allowOverwrite(boolean val) {
        this.ldr.allowOverwrite(val);
    }

    public boolean skipStore() {
        return this.ldr.skipStore();
    }

    public void skipStore(boolean skipStore) {
        this.ldr.skipStore(skipStore);
    }

    public int perNodeBufferSize() {
        return this.ldr.perNodeBufferSize();
    }

    public void perNodeBufferSize(int val) {
        this.ldr.perNodeBufferSize(val);
    }

    public int perNodeParallelOperations() {
        return this.ldr.perNodeParallelOperations();
    }

    public void perNodeParallelOperations(int val) {
        this.ldr.perNodeParallelOperations(val);
    }
}

