/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.dr;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrExpirationInfo;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerCacheUpdaters;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.stream.StreamReceiver;

public class IgniteDrDataStreamerCacheUpdater
implements StreamReceiver<KeyCacheObject, CacheObject>,
DataStreamerCacheUpdaters.InternalUpdater {
    private static final long serialVersionUID = 0L;

    @Override
    public void receive(IgniteCache<KeyCacheObject, CacheObject> cache0, Collection<Map.Entry<KeyCacheObject, CacheObject>> col) {
        try {
            GridCacheProxyImpl cache;
            GridKernalContext ctx = ((IgniteKernal)cache0.unwrap(Ignite.class)).context();
            if (cache0 instanceof IgniteCacheProxy) {
                cache = ((IgniteCacheProxy)cache0).internalProxy().proxyNoGate();
            } else {
                IgniteInternalCache internalCache = ctx.cache().cache(cache0.getName());
                GridCacheContext cctx = internalCache.context();
                cache = new GridCacheProxyImpl(cctx, internalCache, cctx.operationContextPerCall(), false);
            }
            assert (!F.isEmpty(col));
            CacheObjectContext cacheObjCtx = cache.context().cacheObjectContext();
            for (Map.Entry<KeyCacheObject, CacheObject> entry0 : col) {
                GridCacheDrExpirationInfo val;
                GridCacheRawVersionedEntry entry = (GridCacheRawVersionedEntry)entry0;
                entry.unmarshal(cacheObjCtx, ctx.config().getMarshaller());
                KeyCacheObject key = entry.getKey();
                assert (entry.ttl() != -1L && entry.ttl() != -2L && entry.ttl() >= 0L);
                assert (entry.expireTime() != -1L && entry.expireTime() >= 0L);
                CacheObject cacheVal = entry.getValue();
                GridCacheDrInfo gridCacheDrInfo = cacheVal != null ? (entry.ttl() != 0L ? new GridCacheDrExpirationInfo(cacheVal, entry.version(), entry.ttl(), entry.expireTime()) : new GridCacheDrInfo(cacheVal, entry.version())) : (val = null);
                if (val == null) {
                    cache.removeAllConflict(Collections.singletonMap(key, entry.version()));
                    continue;
                }
                cache.putAllConflict(Collections.singletonMap(key, val));
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }
}

