/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.maintenance;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.processors.cache.persistence.maintenance.ClearFolderAction;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClearFolderWorkflow
implements MaintenanceWorkflowCallback {
    public static final String CLEAR_FOLDER_TASK = "clearFolderAction";
    private final File workDir;
    private final List<String> folders;
    private final MaintenanceRegistry maintenanceRegistry;

    public ClearFolderWorkflow(MaintenanceRegistry maintenanceRegistry, File workDir, List<String> foldersToClear) {
        this.maintenanceRegistry = maintenanceRegistry;
        this.workDir = workDir;
        this.folders = foldersToClear;
    }

    @Override
    public boolean shouldProceedWithMaintenance() {
        for (String cacheStoreDirName : this.folders) {
            File cacheStoreDir = new File(this.workDir, cacheStoreDirName);
            if (!cacheStoreDir.exists() || !cacheStoreDir.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<MaintenanceAction<?>> allActions() {
        return Arrays.asList(new ClearFolderAction(this.maintenanceRegistry, this.workDir, this.folders.toArray(new String[0])));
    }

    @Override
    @Nullable
    public MaintenanceAction<?> automaticAction() {
        return new ClearFolderAction(this.maintenanceRegistry, this.workDir, this.folders.toArray(new String[0]));
    }
}

