/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgniteTxMappingsImpl
implements IgniteTxMappings {
    @GridToStringExclude
    private final Map<UUID, GridDistributedTxMapping> mappings = new ConcurrentHashMap<UUID, GridDistributedTxMapping>();

    @Override
    public void clear() {
        this.mappings.clear();
    }

    @Override
    public boolean empty() {
        return this.mappings.isEmpty();
    }

    @Override
    public GridDistributedTxMapping get(UUID nodeId) {
        return this.mappings.get(nodeId);
    }

    @Override
    public void put(GridDistributedTxMapping mapping) {
        this.mappings.put(mapping.primary().id(), mapping);
    }

    @Override
    public GridDistributedTxMapping remove(UUID nodeId) {
        return this.mappings.remove(nodeId);
    }

    @Override
    @Nullable
    public GridDistributedTxMapping localMapping() {
        for (GridDistributedTxMapping m : this.mappings.values()) {
            if (!m.primary().isLocal()) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean single() {
        return false;
    }

    @Override
    @Nullable
    public GridDistributedTxMapping singleMapping() {
        assert (this.mappings.size() == 1) : this.mappings;
        return F.firstValue(this.mappings);
    }

    @Override
    public Collection<GridDistributedTxMapping> mappings() {
        return this.mappings.values();
    }

    public String toString() {
        return S.toString(IgniteTxMappingsImpl.class, this);
    }
}

