/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.AutoClosableCursorIterator;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;

public class QueryCursorImpl<T>
implements QueryCursorEx<T>,
FieldsQueryCursor<T> {
    private static final AtomicReferenceFieldUpdater<QueryCursorImpl, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(QueryCursorImpl.class, State.class, "state");
    private final Iterable<T> iterExec;
    private final boolean isQry;
    private Iterator<T> iter;
    private volatile State state = State.IDLE;
    private List<GridQueryFieldMetadata> fieldsMeta;
    private final GridQueryCancel cancel;
    private final boolean lazy;
    private PartitionResult partRes;

    public QueryCursorImpl(Iterable<T> iterExec) {
        this(iterExec, null, true, false);
    }

    public QueryCursorImpl(Iterable<T> iterExec, GridQueryCancel cancel, boolean isQry, boolean lazy) {
        this.iterExec = iterExec;
        this.cancel = cancel;
        this.isQry = isQry;
        this.lazy = lazy;
    }

    @Override
    public Iterator<T> iterator() {
        return new AutoClosableCursorIterator<T>(this, this.iter());
    }

    protected Iterator<T> iter() {
        if (!STATE_UPDATER.compareAndSet(this, State.IDLE, State.EXECUTING)) {
            throw new IgniteException("Iterator is already fetched or query was cancelled.");
        }
        this.iter = this.iterExec.iterator();
        if (!this.lazy() && !STATE_UPDATER.compareAndSet(this, State.EXECUTING, State.COMPLETED)) {
            this.closeIter();
            throw new CacheException((Throwable)new QueryCancelledException());
        }
        assert (this.iter != null);
        if (this.lazy()) {
            this.iter = new LazyIterator<T>(this.iter);
        }
        return this.iter;
    }

    @Override
    public List<T> getAll() {
        ArrayList<T> all = new ArrayList<T>();
        try {
            Iterator<T> iter = this.iter();
            while (iter.hasNext()) {
                all.add(iter.next());
            }
        }
        finally {
            this.close();
        }
        return all;
    }

    @Override
    public void getAll(QueryCursorEx.Consumer<T> clo) throws IgniteCheckedException {
        try {
            Iterator<T> iter = this.iter();
            while (iter.hasNext()) {
                clo.consume(iter.next());
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        while (this.state != State.CLOSED) {
            if (STATE_UPDATER.compareAndSet(this, State.COMPLETED, State.CLOSED)) {
                this.closeIter();
                return;
            }
            if (STATE_UPDATER.compareAndSet(this, State.EXECUTING, State.CLOSED)) {
                if (this.cancel != null && (!this.cancel.multiStatement() || this.cancel.multiStatement() && this.cancel.last())) {
                    this.cancel.cancel();
                }
                this.closeIter();
                return;
            }
            if (!STATE_UPDATER.compareAndSet(this, State.IDLE, State.CLOSED)) continue;
            return;
        }
    }

    private void closeIter() {
        if (this.iter instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.iter)).close();
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }
    }

    public boolean isQuery() {
        return this.isQry;
    }

    public void fieldsMeta(List<GridQueryFieldMetadata> fieldsMeta) {
        this.fieldsMeta = fieldsMeta;
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return this.fieldsMeta;
    }

    @Override
    public String getFieldName(int idx) {
        assert (this.fieldsMeta != null);
        GridQueryFieldMetadata metadata = this.fieldsMeta.get(idx);
        return metadata.fieldName();
    }

    @Override
    public int getColumnsCount() {
        assert (this.fieldsMeta != null);
        return this.fieldsMeta.size();
    }

    public PartitionResult partitionResult() {
        return this.partRes;
    }

    protected boolean lazy() {
        return this.lazy;
    }

    public void partitionResult(PartitionResult partRes) {
        this.partRes = partRes;
    }

    public class LazyIterator<Type>
    implements Iterator<Type>,
    AutoCloseable {
        private final Iterator<Type> delegate;

        public LazyIterator(Iterator<Type> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            if (this.delegate.hasNext()) {
                return true;
            }
            STATE_UPDATER.compareAndSet(QueryCursorImpl.this, State.EXECUTING, State.COMPLETED);
            return false;
        }

        @Override
        public Type next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super Type> action) {
            this.delegate.forEachRemaining(action);
        }

        @Override
        public void close() throws Exception {
            if (this.delegate instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.delegate)).close();
            }
        }
    }

    protected static enum State {
        IDLE,
        EXECUTING,
        COMPLETED,
        CLOSED;

    }
}

