/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheAffinityChangeMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id = IgniteUuid.randomUuid();
    private AffinityTopologyVersion topVer;
    private GridDhtPartitionExchangeId exchId;
    private Map<Integer, Map<Integer, List<UUID>>> assignmentChange;
    private Map<Integer, IgniteUuid> cacheDeploymentIds;
    private GridDhtPartitionsFullMessage partsMsg;
    private boolean exchangeNeeded;
    private transient boolean stopProc;

    public CacheAffinityChangeMessage(AffinityTopologyVersion topVer, @Nullable Map<Integer, Map<Integer, List<UUID>>> assignmentChange, Map<Integer, IgniteUuid> cacheDeploymentIds) {
        this.topVer = topVer;
        this.cacheDeploymentIds = cacheDeploymentIds;
        this.assignmentChange = assignmentChange;
    }

    public CacheAffinityChangeMessage(GridDhtPartitionExchangeId exchId, GridDhtPartitionsFullMessage partsMsg, Map<Integer, Map<Integer, List<UUID>>> assignmentChange) {
        this.exchId = exchId;
        this.partsMsg = partsMsg;
        this.assignmentChange = assignmentChange;
    }

    public Map<Integer, IgniteUuid> cacheDeploymentIds() {
        return this.cacheDeploymentIds;
    }

    public boolean exchangeNeeded() {
        return this.exchangeNeeded;
    }

    public void exchangeNeeded(boolean exchangeNeeded) {
        this.exchangeNeeded = exchangeNeeded;
    }

    public GridDhtPartitionsFullMessage partitionsMessage() {
        return this.partsMsg != null ? this.partsMsg.copy() : null;
    }

    @Nullable
    public Map<Integer, Map<Integer, List<UUID>>> assignmentChange() {
        return this.assignmentChange;
    }

    @Nullable
    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        if (!this.stopProc) {
            return null;
        }
        return this;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean stopProcess() {
        return this.stopProc;
    }

    public void stopProcess(boolean stopProc) {
        this.stopProc = stopProc;
    }

    @Override
    @Nullable
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return discoCache.copy(topVer, null);
    }

    public String toString() {
        return S.toString(CacheAffinityChangeMessage.class, this);
    }
}

