/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientAuthorizationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.client.ClientReconnectedException;
import org.apache.ignite.client.events.ConnectionDescription;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryByteBufferInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.monitoring.EventListenerDemultiplexer;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientNotificationType;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.NotificationListener;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.client.thin.io.ClientConnection;
import org.apache.ignite.internal.client.thin.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.thin.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.thin.io.ClientMessageHandler;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

class TcpClientChannel
implements ClientChannel,
ClientMessageHandler,
ClientConnectionStateHandler {
    private static final ProtocolVersion DEFAULT_VERSION = ProtocolVersion.CURRENT_VER;
    private static final Collection<ProtocolVersion> supportedVers = Arrays.asList(ProtocolVersion.V1_7_1, ProtocolVersion.V1_7_0, ProtocolVersion.V1_6_0, ProtocolVersion.V1_5_0, ProtocolVersion.V1_4_0, ProtocolVersion.V1_3_0, ProtocolVersion.V1_2_0, ProtocolVersion.V1_1_0, ProtocolVersion.V1_0_0);
    private static final long MIN_RECOMMENDED_HEARTBEAT_INTERVAL = 500L;
    public static final byte[] EMPTY_BYTES = new byte[0];
    private volatile ProtocolContext protocolCtx;
    private volatile UUID srvNodeId;
    private volatile AffinityTopologyVersion srvTopVer;
    private final ClientConnection sock;
    private final AtomicLong reqId = new AtomicLong(1L);
    private final Map<Long, ClientRequestFuture> pendingReqs = new ConcurrentHashMap<Long, ClientRequestFuture>();
    private final ReadWriteLock pendingReqsLock = new ReentrantReadWriteLock();
    private final Collection<Consumer<ClientChannel>> topChangeLsnrs = new CopyOnWriteArrayList<Consumer<ClientChannel>>();
    private final Map<Long, NotificationListener>[] notificationLsnrs = new Map[ClientNotificationType.values().length];
    private final Map<Long, Queue<T2<ByteBuffer, Exception>>>[] pendingNotifications = new Map[ClientNotificationType.values().length];
    private final ReadWriteLock notificationLsnrsGuard = new ReentrantReadWriteLock();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Executor asyncContinuationExecutor;
    private final int timeout;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new IgniteThreadFactory("thin-client", "thin-client-maintenance"));
    private final IgniteLogger log;
    private final EventListenerDemultiplexer eventListener;
    private final ConnectionDescription connDesc;
    private volatile long lastSendMillis;

    TcpClientChannel(ClientChannelConfiguration cfg, ClientConnectionMultiplexer connMgr) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        TcpClientChannel.validateConfiguration(cfg);
        this.log = NullLogger.whenNull(cfg.getLogger());
        this.eventListener = cfg.eventListener();
        for (ClientNotificationType type : ClientNotificationType.values()) {
            if (!type.keepNotificationsWithoutListener()) continue;
            this.pendingNotifications[type.ordinal()] = new ConcurrentHashMap<Long, Queue<T2<ByteBuffer, Exception>>>();
        }
        Executor cfgExec = cfg.getAsyncContinuationExecutor();
        this.asyncContinuationExecutor = cfgExec != null ? cfgExec : ForkJoinPool.commonPool();
        this.timeout = cfg.getTimeout();
        List<InetSocketAddress> addrs = cfg.getAddresses();
        ClientConnection sock = null;
        ClientConnectionException connectionEx = null;
        assert (!addrs.isEmpty());
        for (InetSocketAddress addr : addrs) {
            try {
                sock = connMgr.open(addr, this, this);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Connection established: " + addr);
                break;
            }
            catch (ClientConnectionException e) {
                this.log.info("Can't establish connection with " + addr);
                if (connectionEx != null) {
                    connectionEx.addSuppressed(e);
                    continue;
                }
                connectionEx = e;
            }
        }
        if (sock == null) {
            assert (connectionEx != null);
            throw connectionEx;
        }
        this.sock = sock;
        this.handshake(DEFAULT_VERSION, cfg.getUserName(), cfg.getUserPassword(), cfg.getUserAttributes());
        assert (this.protocolCtx != null) : "Protocol context after handshake is null";
        this.connDesc = new ConnectionDescription(sock.localAddress(), sock.remoteAddress(), this.protocolCtx.toString(), this.srvNodeId);
        if (this.protocolCtx.isFeatureSupported(ProtocolBitmaskFeature.HEARTBEAT) && cfg.getHeartbeatEnabled()) {
            this.initHeartbeat(cfg.getHeartbeatInterval());
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void onMessage(ByteBuffer buf) {
        this.processNextMessage(buf);
    }

    @Override
    public void onDisconnected(@Nullable Exception e) {
        if (e == null) {
            this.log.info("Client disconnected");
        } else {
            this.log.warning("Client disconnected: " + e.getMessage(), e);
        }
        this.close(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Exception cause) {
        if (this.closed.compareAndSet(false, true)) {
            ConnectionDescription connDesc0 = this.connDesc;
            if (connDesc0 != null) {
                this.eventListener.onConnectionClosed(connDesc0, cause);
            }
            this.scheduler.shutdown();
            U.closeQuiet(this.sock);
            this.pendingReqsLock.writeLock().lock();
            try {
                for (ClientRequestFuture pendingReq : this.pendingReqs.values()) {
                    pendingReq.onDone(new ClientConnectionException("Channel is closed", cause));
                }
            }
            finally {
                this.pendingReqsLock.writeLock().unlock();
            }
            this.notificationLsnrsGuard.readLock().lock();
            try {
                for (Map<Long, NotificationListener> lsnrs : this.notificationLsnrs) {
                    if (lsnrs == null) continue;
                    lsnrs.values().forEach(lsnr -> lsnr.onChannelClosed(cause));
                }
            }
            finally {
                this.notificationLsnrsGuard.readLock().unlock();
            }
        }
    }

    @Override
    public <T> T service(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        ClientRequestFuture fut = this.send(op, payloadWriter);
        return this.receive(fut, payloadReader);
    }

    @Override
    public <T> CompletableFuture<T> serviceAsync(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) {
        try {
            ClientRequestFuture fut = this.send(op, payloadWriter);
            return this.receiveAsync(fut, payloadReader);
        }
        catch (Throwable t) {
            CompletableFuture fut = new CompletableFuture();
            fut.completeExceptionally(t);
            return fut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientRequestFuture send(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientException {
        long id = this.reqId.getAndIncrement();
        long startTimeNanos = System.nanoTime();
        PayloadOutputChannel payloadCh = new PayloadOutputChannel(this);
        try {
            ClientRequestFuture fut;
            this.pendingReqsLock.readLock().lock();
            try {
                if (this.closed()) {
                    ClientConnectionException err = new ClientConnectionException("Channel is closed");
                    this.eventListener.onRequestFail(this.connDesc, id, op.code(), op.name(), System.nanoTime() - startTimeNanos, err);
                    throw err;
                }
                fut = new ClientRequestFuture(id, op, startTimeNanos);
                this.pendingReqs.put(id, fut);
            }
            finally {
                this.pendingReqsLock.readLock().unlock();
            }
            this.eventListener.onRequestStart(this.connDesc, id, op.code(), op.name());
            BinaryOutputStream req = payloadCh.out();
            req.writeInt(0);
            req.writeShort(op.code());
            req.writeLong(id);
            if (payloadWriter != null) {
                payloadWriter.accept(payloadCh);
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.array(), req.position(), payloadCh::close);
            return fut;
        }
        catch (Throwable t) {
            this.pendingReqs.remove(id);
            payloadCh.close();
            this.eventListener.onRequestFail(this.connDesc, id, op.code(), op.name(), System.nanoTime() - startTimeNanos, t);
            throw t;
        }
    }

    private <T> T receive(ClientRequestFuture pendingReq, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        long requestId = pendingReq.requestId;
        ClientOperation op = pendingReq.operation;
        long startTimeNanos = pendingReq.startTimeNanos;
        try {
            ByteBuffer payload = this.timeout > 0 ? (ByteBuffer)pendingReq.get(this.timeout) : (ByteBuffer)pendingReq.get();
            T res = null;
            if (payload != null && payloadReader != null) {
                res = payloadReader.apply(new PayloadInputChannel(this, payload));
            }
            this.eventListener.onRequestSuccess(this.connDesc, requestId, op.code(), op.name(), System.nanoTime() - startTimeNanos);
            return res;
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to process response: " + e.getMessage(), e);
            RuntimeException err = this.convertException(e);
            this.eventListener.onRequestFail(this.connDesc, requestId, op.code(), op.name(), System.nanoTime() - startTimeNanos, err);
            throw err;
        }
    }

    private <T> CompletableFuture<T> receiveAsync(ClientRequestFuture pendingReq, Function<PayloadInputChannel, T> payloadReader) {
        CompletableFuture fut = new CompletableFuture();
        long requestId = pendingReq.requestId;
        ClientOperation op = pendingReq.operation;
        long startTimeNanos = pendingReq.startTimeNanos;
        ScheduledFuture<Boolean> timeoutFut = this.timeout <= 0 ? null : this.scheduler.schedule(() -> fut.completeExceptionally(new TimeoutException("Operation timed out")), (long)this.timeout, TimeUnit.MILLISECONDS);
        pendingReq.listen(payloadFut -> this.asyncContinuationExecutor.execute(() -> {
            try {
                ByteBuffer payload = (ByteBuffer)payloadFut.get();
                Object res = null;
                if (payload != null && payloadReader != null) {
                    res = payloadReader.apply(new PayloadInputChannel(this, payload));
                }
                this.eventListener.onRequestSuccess(this.connDesc, requestId, op.code(), op.name(), System.nanoTime() - startTimeNanos);
                if (timeoutFut != null) {
                    timeoutFut.cancel(true);
                }
                fut.complete(res);
            }
            catch (Throwable t) {
                this.log.warning("Failed to process response: " + t.getMessage(), t);
                RuntimeException err = this.convertException(t);
                this.eventListener.onRequestFail(this.connDesc, requestId, op.code(), op.name(), System.nanoTime() - startTimeNanos, err);
                if (timeoutFut != null) {
                    timeoutFut.cancel(true);
                }
                fut.completeExceptionally(err);
            }
        }));
        return fut;
    }

    private RuntimeException convertException(Throwable e) {
        if (e.getCause() instanceof ClientError) {
            return new ClientException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientConnectionException) {
            return new ClientConnectionException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientReconnectedException) {
            return new ClientReconnectedException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientAuthenticationException) {
            return new ClientAuthenticationException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientAuthorizationException) {
            return new ClientAuthorizationException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientFeatureNotSupportedByServerException) {
            return new ClientFeatureNotSupportedByServerException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientException) {
            return new ClientException(e.getMessage(), e.getCause());
        }
        return new ClientException(e.getMessage(), e);
    }

    private void processNextMessage(ByteBuffer buf) throws ClientProtocolError, ClientConnectionException {
        ByteBuffer res;
        RuntimeException err;
        BinaryByteBufferInputStream dataInput = BinaryByteBufferInputStream.create(buf);
        if (this.protocolCtx == null) {
            this.pendingReqs.remove(-1L).onDone(buf);
            return;
        }
        Long resId = dataInput.readLong();
        int status = 0;
        ClientOperation notificationOp = null;
        if (this.protocolCtx.isFeatureSupported(ProtocolVersionFeature.PARTITION_AWARENESS)) {
            short notificationCode;
            short flags = dataInput.readShort();
            if ((flags & 2) != 0) {
                long topVer = dataInput.readLong();
                int minorTopVer = dataInput.readInt();
                this.srvTopVer = new AffinityTopologyVersion(topVer, minorTopVer);
                for (Consumer<ClientChannel> lsnr : this.topChangeLsnrs) {
                    lsnr.accept(this);
                }
            }
            if ((flags & 4) != 0 && ((notificationOp = ClientOperation.fromCode(notificationCode = dataInput.readShort())) == null || notificationOp.notificationType() == null)) {
                throw new ClientProtocolError(String.format("Unexpected notification code [%d]", notificationCode));
            }
            if ((flags & 1) != 0) {
                status = dataInput.readInt();
            }
        } else {
            status = dataInput.readInt();
        }
        int hdrSize = dataInput.position();
        int msgSize = buf.limit();
        if (status == 0) {
            err = null;
            res = msgSize > hdrSize ? buf : null;
        } else {
            String errMsg = ClientUtils.createBinaryReader(null, dataInput).readString();
            err = status == 1012 ? new ClientAuthorizationException(errMsg) : new ClientServerError(errMsg, status, resId);
            res = null;
        }
        if (notificationOp == null) {
            ClientRequestFuture pendingReq = this.pendingReqs.remove(resId);
            if (pendingReq == null) {
                throw new ClientProtocolError(String.format("Unexpected response ID [%s]", resId));
            }
            pendingReq.onDone(res, err);
        } else {
            ClientNotificationType notificationType = notificationOp.notificationType();
            this.asyncContinuationExecutor.execute(() -> {
                NotificationListener lsnr = null;
                this.notificationLsnrsGuard.readLock().lock();
                try {
                    Map<Long, NotificationListener> lsrns = this.notificationLsnrs[notificationType.ordinal()];
                    if (lsrns != null) {
                        lsnr = lsrns.get(resId);
                    }
                    if (notificationType.keepNotificationsWithoutListener() && lsnr == null) {
                        this.pendingNotifications[notificationType.ordinal()].computeIfAbsent(resId, k -> new ConcurrentLinkedQueue()).add(new T2<ByteBuffer, Exception>(res, err));
                    }
                }
                finally {
                    this.notificationLsnrsGuard.readLock().unlock();
                }
                if (lsnr != null) {
                    lsnr.acceptNotification(res, err);
                }
            });
        }
    }

    @Override
    public ProtocolContext protocolCtx() {
        return this.protocolCtx;
    }

    @Override
    public UUID serverNodeId() {
        return this.srvNodeId;
    }

    @Override
    public AffinityTopologyVersion serverTopologyVersion() {
        return this.srvTopVer;
    }

    @Override
    public void addTopologyChangeListener(Consumer<ClientChannel> lsnr) {
        this.topChangeLsnrs.add(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(ClientNotificationType type, Long rsrcId, NotificationListener lsnr) {
        Queue<T2<ByteBuffer, Exception>> pendingQueue = null;
        this.notificationLsnrsGuard.writeLock().lock();
        try {
            if (this.closed()) {
                throw new ClientConnectionException("Channel is closed");
            }
            Map<Long, NotificationListener> lsnrs = this.notificationLsnrs[type.ordinal()];
            if (lsnrs == null) {
                this.notificationLsnrs[type.ordinal()] = lsnrs = new ConcurrentHashMap<Long, NotificationListener>();
            }
            lsnrs.put(rsrcId, lsnr);
            if (type.keepNotificationsWithoutListener()) {
                pendingQueue = this.pendingNotifications[type.ordinal()].remove(rsrcId);
            }
        }
        finally {
            this.notificationLsnrsGuard.writeLock().unlock();
        }
        if (pendingQueue != null) {
            pendingQueue.forEach(n -> lsnr.acceptNotification((ByteBuffer)n.get1(), (Exception)n.get2()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(ClientNotificationType type, Long rsrcId) {
        this.notificationLsnrsGuard.writeLock().lock();
        try {
            Map<Long, NotificationListener> lsnrs = this.notificationLsnrs[type.ordinal()];
            if (lsnrs == null) {
                return;
            }
            lsnrs.remove(rsrcId);
            if (type.keepNotificationsWithoutListener()) {
                this.pendingNotifications[type.ordinal()].remove(rsrcId);
            }
        }
        finally {
            this.notificationLsnrsGuard.writeLock().unlock();
        }
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    private static void validateConfiguration(ClientChannelConfiguration cfg) {
        String error = null;
        List<InetSocketAddress> addrs = cfg.getAddresses();
        if (F.isEmpty(addrs)) {
            error = "At least one Ignite server node must be specified in the Ignite client configuration";
        }
        if (error == null && cfg.getHeartbeatInterval() <= 0L) {
            error = "heartbeatInterval cannot be zero or less.";
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(ProtocolVersion ver, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        long requestId = -1L;
        long startTime = System.nanoTime();
        this.eventListener.onHandshakeStart(new ConnectionDescription(this.sock.localAddress(), this.sock.remoteAddress(), new ProtocolContext(ver).toString(), null));
        while (true) {
            ClientRequestFuture fut;
            this.pendingReqsLock.readLock().lock();
            try {
                if (this.closed()) {
                    throw new ClientConnectionException("Channel is closed");
                }
                fut = new ClientRequestFuture(requestId, ClientOperation.HANDSHAKE);
                this.pendingReqs.put(requestId, fut);
            }
            finally {
                this.pendingReqsLock.readLock().unlock();
            }
            this.handshakeReq(ver, user, pwd, userAttrs);
            try {
                ByteBuffer buf = this.timeout > 0 ? (ByteBuffer)fut.get(this.timeout) : (ByteBuffer)fut.get();
                BinaryByteBufferInputStream res = BinaryByteBufferInputStream.create(buf);
                BinaryReaderExImpl reader = ClientUtils.createBinaryReader(null, res);
                Throwable throwable = null;
                try {
                    boolean success = res.readBoolean();
                    if (success) {
                        byte[] features = EMPTY_BYTES;
                        if (ProtocolContext.isFeatureSupported(ver, ProtocolVersionFeature.BITMAP_FEATURES)) {
                            features = reader.readByteArray();
                        }
                        this.protocolCtx = new ProtocolContext(ver, ProtocolBitmaskFeature.enumSet(features));
                        if (this.protocolCtx.isFeatureSupported(ProtocolVersionFeature.PARTITION_AWARENESS)) {
                            this.srvNodeId = reader.readUuid();
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Handshake succeeded [protocolVersion=" + this.protocolCtx.version() + ", srvNodeId=" + this.srvNodeId + ']');
                        }
                        this.eventListener.onHandshakeSuccess(new ConnectionDescription(this.sock.localAddress(), this.sock.remoteAddress(), this.protocolCtx.toString(), this.srvNodeId), System.nanoTime() - startTime);
                        break;
                    }
                    ProtocolVersion srvVer = new ProtocolVersion(res.readShort(), res.readShort(), res.readShort());
                    String err = reader.readString();
                    int errCode = 1;
                    if (res.remaining() > 0) {
                        errCode = reader.readInt();
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Handshake failed [protocolVersion=" + srvVer + ", err=" + err + ", errCode=" + errCode + ']');
                    }
                    RuntimeException resultErr = null;
                    if (errCode == 2000) {
                        resultErr = new ClientAuthenticationException(err);
                    } else if (ver.equals(srvVer)) {
                        resultErr = new ClientProtocolError(err);
                    } else if (srvVer.equals(ProtocolVersion.V_UNKNOWN)) {
                        resultErr = new ClientConnectionException(err);
                    } else if (!supportedVers.contains(srvVer) || !ProtocolContext.isFeatureSupported(srvVer, ProtocolVersionFeature.AUTHORIZATION) && !F.isEmpty(user)) {
                        resultErr = new ClientProtocolError(String.format("Protocol version mismatch: client %s / server %s. Server details: %s", ver, srvVer, err));
                    }
                    if (resultErr != null) {
                        ConnectionDescription connDesc = new ConnectionDescription(this.sock.localAddress(), this.sock.remoteAddress(), new ProtocolContext(ver).toString(), null);
                        long elapsedNanos = System.nanoTime() - startTime;
                        this.eventListener.onHandshakeFail(connDesc, elapsedNanos, resultErr);
                        throw resultErr;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Retrying handshake with server version [protocolVersion=" + srvVer + ']');
                    }
                    ver = srvVer;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException | IgniteCheckedException e) {
                ClientException err = e instanceof IOException ? this.handleIOError((IOException)e) : new ClientConnectionException(e.getMessage(), e);
                this.eventListener.onHandshakeFail(new ConnectionDescription(this.sock.localAddress(), this.sock.remoteAddress(), new ProtocolContext(ver).toString(), null), System.nanoTime() - startTime, err);
                throw err;
            }
        }
    }

    private void handshakeReq(ProtocolVersion proposedVer, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException {
        BinaryContext ctx = new BinaryContext(BinaryCachingMetadataHandler.create(), new IgniteConfiguration(), null);
        try (BinaryWriterExImpl writer = new BinaryWriterExImpl(ctx, new BinaryHeapOutputStream(32), null, null);){
            boolean authSupported;
            ProtocolContext protocolCtx = this.protocolContextFromVersion(proposedVer);
            writer.writeInt(0);
            writer.writeByte((byte)1);
            writer.writeShort(proposedVer.major());
            writer.writeShort(proposedVer.minor());
            writer.writeShort(proposedVer.patch());
            writer.writeByte((byte)2);
            if (protocolCtx.isFeatureSupported(ProtocolVersionFeature.BITMAP_FEATURES)) {
                byte[] features = ProtocolBitmaskFeature.featuresAsBytes(protocolCtx.features());
                writer.writeByteArray(features);
            }
            if (protocolCtx.isFeatureSupported(ProtocolVersionFeature.USER_ATTRIBUTES)) {
                writer.writeMap(userAttrs);
            }
            if ((authSupported = protocolCtx.isFeatureSupported(ProtocolVersionFeature.AUTHORIZATION)) && user != null && !user.isEmpty()) {
                writer.writeString(user);
                writer.writeString(pwd);
            }
            writer.out().writeInt(0, writer.out().position() - 4);
            this.write(writer.out().arrayCopy(), writer.out().position(), null);
        }
    }

    private ProtocolContext protocolContextFromVersion(ProtocolVersion ver) {
        EnumSet<ProtocolBitmaskFeature> features = null;
        if (ProtocolContext.isFeatureSupported(ver, ProtocolVersionFeature.BITMAP_FEATURES)) {
            features = ProtocolBitmaskFeature.allFeaturesAsEnumSet();
        }
        return new ProtocolContext(ver, features);
    }

    private void write(byte[] bytes, int len, @Nullable Runnable onDone) throws ClientConnectionException {
        ByteBuffer buf = ByteBuffer.wrap(bytes, 0, len);
        try {
            this.sock.send(buf, onDone);
            this.lastSendMillis = System.currentTimeMillis();
        }
        catch (IgniteCheckedException e) {
            throw new ClientConnectionException(e.getMessage(), e);
        }
    }

    private ClientException handleIOError(@Nullable IOException ex) {
        return this.handleIOError("sock=" + this.sock, ex);
    }

    private ClientException handleIOError(String chInfo, @Nullable IOException ex) {
        return new ClientConnectionException("Ignite cluster is unavailable [" + chInfo + ']', ex);
    }

    private void initHeartbeat(long configuredInterval) {
        long heartbeatInterval = this.getHeartbeatInterval(configuredInterval);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                if (System.currentTimeMillis() - this.lastSendMillis > heartbeatInterval) {
                    this.service(ClientOperation.HEARTBEAT, null, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, heartbeatInterval, heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    private long getHeartbeatInterval(long configuredInterval) {
        long serverIdleTimeoutMs = this.service(ClientOperation.GET_IDLE_TIMEOUT, null, in -> in.in().readLong());
        if (serverIdleTimeoutMs <= 0L) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Server-side IdleTimeout is not set, using configured ClientConfiguration.heartbeatInterval: " + configuredInterval);
            }
            return configuredInterval;
        }
        long recommendedHeartbeatInterval = serverIdleTimeoutMs / 3L;
        if (recommendedHeartbeatInterval < 500L) {
            recommendedHeartbeatInterval = 500L;
        }
        long res = Math.min(configuredInterval, recommendedHeartbeatInterval);
        if (this.log.isInfoEnabled()) {
            this.log.info("Using heartbeat interval: " + res + " (configured: " + configuredInterval + ", recommended: " + recommendedHeartbeatInterval + ", server-side IdleTimeout: " + serverIdleTimeoutMs + ")");
        }
        return res;
    }

    private static class ClientRequestFuture
    extends GridFutureAdapter<ByteBuffer> {
        final long startTimeNanos;
        final long requestId;
        final ClientOperation operation;

        ClientRequestFuture(long requestId, ClientOperation op) {
            this(requestId, op, System.nanoTime());
        }

        ClientRequestFuture(long requestId, ClientOperation op, long startTimeNanos) {
            this.requestId = requestId;
            this.operation = op;
            this.startTimeNanos = startTimeNanos;
        }
    }
}

