/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientOperationType;
import org.apache.ignite.client.ClientRetryPolicy;
import org.apache.ignite.client.IgniteClientFuture;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.thin.ClientCacheAffinityContext;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientDiscoveryContext;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientRetryPolicyContextImpl;
import org.apache.ignite.internal.client.thin.IgniteClientFutureImpl;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.thin.io.gridnioserver.GridNioClientConnectionMultiplexer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.logger.NullLogger;
import org.jetbrains.annotations.Nullable;

final class ReliableChannel
implements AutoCloseable {
    private final BiFunction<ClientChannelConfiguration, ClientConnectionMultiplexer, ClientChannel> chFactory;
    private volatile List<ClientChannelHolder> channels;
    private volatile int attemptsLimit;
    private volatile int curChIdx = -1;
    private final boolean partitionAwarenessEnabled;
    private final ClientCacheAffinityContext affinityCtx;
    private final ClientDiscoveryContext discoveryCtx;
    private final ClientConfiguration clientCfg;
    private final IgniteLogger log;
    private final Map<UUID, ClientChannelHolder> nodeChannels = new ConcurrentHashMap<UUID, ClientChannelHolder>();
    private final AtomicBoolean scheduledChannelsReinit = new AtomicBoolean();
    private volatile long startChannelsReInit;
    private volatile long finishChannelsReInit;
    private final AtomicBoolean affinityUpdateInProgress = new AtomicBoolean();
    private volatile boolean closed;
    private final ArrayList<Runnable> chFailLsnrs = new ArrayList();
    private final ReadWriteLock curChannelsGuard = new ReentrantReadWriteLock();
    private final ClientConnectionMultiplexer connMgr;
    private final AtomicInteger channelsCnt = new AtomicInteger();

    ReliableChannel(BiFunction<ClientChannelConfiguration, ClientConnectionMultiplexer, ClientChannel> chFactory, ClientConfiguration clientCfg, IgniteBinary binary) {
        if (chFactory == null) {
            throw new NullPointerException("chFactory");
        }
        if (clientCfg == null) {
            throw new NullPointerException("clientCfg");
        }
        this.clientCfg = clientCfg;
        this.chFactory = chFactory;
        this.log = NullLogger.whenNull(clientCfg.getLogger());
        this.partitionAwarenessEnabled = clientCfg.isAffinityAwarenessEnabled();
        this.affinityCtx = new ClientCacheAffinityContext(binary);
        this.discoveryCtx = new ClientDiscoveryContext(clientCfg);
        this.connMgr = new GridNioClientConnectionMultiplexer(clientCfg);
        this.connMgr.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReliableChannel created");
        }
    }

    @Override
    public synchronized void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReliableChannel stopping");
        }
        this.closed = true;
        this.connMgr.stop();
        List<ClientChannelHolder> holders = this.channels;
        if (holders != null) {
            for (ClientChannelHolder hld : holders) {
                hld.close();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReliableChannel stopped");
        }
    }

    public <T> T service(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        return (T)this.applyOnDefaultChannel(channel -> channel.service(op, payloadWriter, payloadReader), op);
    }

    public <T> IgniteClientFuture<T> serviceAsync(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        CompletableFuture fut = new CompletableFuture();
        this.handleServiceAsync(fut, op, payloadWriter, payloadReader, new ArrayList<ClientConnectionException>());
        return new IgniteClientFutureImpl(fut);
    }

    private <T> void handleServiceAsync(CompletableFuture<T> fut, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader, List<ClientConnectionException> failures) {
        try {
            this.applyOnDefaultChannel(channel -> this.applyOnClientChannelAsync(fut, (ClientChannel)channel, op, payloadWriter, payloadReader, failures), null, failures);
        }
        catch (Throwable ex) {
            fut.completeExceptionally(ex);
        }
    }

    private <T> Object applyOnClientChannelAsync(CompletableFuture<T> fut, ClientChannel ch, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader, List<ClientConnectionException> failures) {
        return ch.serviceAsync(op, payloadWriter, payloadReader).handle((res, err) -> {
            if (err == null) {
                fut.complete(res);
                return null;
            }
            if (err instanceof ClientConnectionException) {
                ClientConnectionException failure0 = (ClientConnectionException)err;
                failures.add(failure0);
                try {
                    this.onChannelFailure(ch, (Throwable)err, failures);
                }
                catch (Throwable ex) {
                    fut.completeExceptionally(ex);
                    return null;
                }
                if (failures.size() < this.attemptsLimit && this.shouldRetry(op, failures.size() - 1, failure0)) {
                    this.handleServiceAsync(fut, op, payloadWriter, payloadReader, failures);
                    return null;
                }
                fut.completeExceptionally(this.composeException(failures));
            } else {
                fut.completeExceptionally(err instanceof ClientException ? err : new ClientException((Throwable)err));
            }
            return null;
        });
    }

    public <T> T service(ClientOperation op, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        return this.service(op, null, payloadReader);
    }

    public <T> IgniteClientFuture<T> serviceAsync(ClientOperation op, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        return this.serviceAsync(op, null, payloadReader);
    }

    public void request(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientException, ClientError {
        this.service(op, payloadWriter, null);
    }

    public IgniteClientFuture<Void> requestAsync(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientException, ClientError {
        return this.serviceAsync(op, payloadWriter, null);
    }

    public <T> T affinityService(int cacheId, Object key, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        UUID affNodeId;
        if (this.partitionAwarenessEnabled && this.affinityInfoIsUpToDate(cacheId) && (affNodeId = this.affinityCtx.affinityNode(cacheId, key)) != null) {
            return (T)this.applyOnNodeChannelWithFallback(affNodeId, channel -> channel.service(op, payloadWriter, payloadReader), op);
        }
        return this.service(op, payloadWriter, payloadReader);
    }

    public <T> T affinityService(int cacheId, int part, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        UUID affNodeId;
        if (this.partitionAwarenessEnabled && this.affinityInfoIsUpToDate(cacheId) && (affNodeId = this.affinityCtx.affinityNode(cacheId, part)) != null) {
            return (T)this.applyOnNodeChannelWithFallback(affNodeId, channel -> channel.service(op, payloadWriter, payloadReader), op);
        }
        return this.service(op, payloadWriter, payloadReader);
    }

    public <T> IgniteClientFuture<T> affinityServiceAsync(int cacheId, Object key, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        ArrayList<ClientConnectionException> failures;
        CompletableFuture fut;
        Object result;
        UUID affNodeId;
        if (this.partitionAwarenessEnabled && this.affinityInfoIsUpToDate(cacheId) && (affNodeId = this.affinityCtx.affinityNode(cacheId, key)) != null && (result = this.applyOnNodeChannel(affNodeId, arg_0 -> this.lambda$affinityServiceAsync$5(fut = new CompletableFuture(), op, payloadWriter, payloadReader, failures = new ArrayList<ClientConnectionException>(), arg_0), failures)) != null) {
            return new IgniteClientFutureImpl(fut);
        }
        return this.serviceAsync(op, payloadWriter, payloadReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean affinityInfoIsUpToDate(int cacheId) {
        if (this.affinityCtx.affinityUpdateRequired(cacheId)) {
            if (this.affinityUpdateInProgress.compareAndSet(false, true)) {
                try {
                    ClientCacheAffinityContext.TopologyNodes lastTop = this.affinityCtx.lastTopology();
                    if (lastTop == null) {
                        boolean bl = false;
                        return bl;
                    }
                    ArrayList<ClientConnectionException> failures = new ArrayList<ClientConnectionException>();
                    for (UUID nodeId : lastTop.nodes()) {
                        if (lastTop != this.affinityCtx.lastTopology()) {
                            boolean bl = false;
                            return bl;
                        }
                        Boolean result = this.applyOnNodeChannel(nodeId, channel -> channel.service(ClientOperation.CACHE_PARTITIONS, this.affinityCtx::writePartitionsUpdateRequest, this.affinityCtx::readPartitionsUpdateResponse), failures);
                        if (result == null) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Cache partitions mapping updated [cacheId=" + cacheId + ", nodeId=" + nodeId + ']');
                        }
                        boolean bl = result;
                        return bl;
                    }
                    this.log.warning("Failed to update cache partitions mapping [cacheId=" + cacheId + ']', this.composeException(failures));
                    this.affinityCtx.reset(lastTop);
                }
                finally {
                    this.affinityUpdateInProgress.set(false);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentChannel(ClientChannelHolder hld) {
        this.curChannelsGuard.writeLock().lock();
        try {
            int idx = this.curChIdx;
            List<ClientChannelHolder> holders = this.channels;
            ClientChannelHolder dfltHld = holders.get(idx);
            if (dfltHld == hld) {
                this.curChIdx = ++idx >= holders.size() ? 0 : idx;
            }
        }
        finally {
            this.curChannelsGuard.writeLock().unlock();
        }
    }

    private void onChannelFailure(ClientChannel ch, Throwable t, @Nullable List<ClientConnectionException> failures) {
        this.onChannelFailure(this.channels.get(this.curChIdx), ch, t, failures);
    }

    private void onChannelFailure(ClientChannelHolder hld, ClientChannel ch, Throwable t, @Nullable List<ClientConnectionException> failures) {
        this.log.warning("Channel failure [channel=" + ch + ", err=" + t.getMessage() + ']', t);
        if (ch != null && ch == hld.ch) {
            hld.closeChannel();
        }
        this.chFailLsnrs.forEach(Runnable::run);
        this.rollCurrentChannel(hld);
        if (this.channelsCnt.get() == 0 && F.size(failures, new IgnitePredicate[0]) == this.attemptsLimit) {
            this.discoveryCtx.reset();
            this.channelsInit(failures);
        } else if (this.scheduledChannelsReinit.get() && !this.partitionAwarenessEnabled) {
            this.channelsInit(failures);
        }
    }

    private void initAllChannelsAsync() {
        ForkJoinPool.commonPool().submit(() -> {
            List<ClientChannelHolder> holders = this.channels;
            for (ClientChannelHolder hld : holders) {
                if (this.closed || this.startChannelsReInit > this.finishChannelsReInit) {
                    return;
                }
                try {
                    hld.getOrCreateChannel(true);
                }
                catch (Exception e) {
                    this.log.warning("Failed to initialize channel [addresses=" + hld.getAddresses() + ", err=" + e.getMessage() + ']', e);
                }
            }
        });
    }

    private void onTopologyChanged(ClientChannel ch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Topology change detected [ch=" + ch + ", top=" + ch.serverTopologyVersion() + ']');
        }
        if (this.affinityCtx.updateLastTopologyVersion(ch.serverTopologyVersion(), ch.serverNodeId())) {
            ForkJoinPool.commonPool().submit(() -> {
                try {
                    this.discoveryCtx.refresh(ch);
                }
                catch (ClientException e) {
                    this.log.warning("Failed to get nodes endpoints", e);
                }
                if (this.scheduledChannelsReinit.compareAndSet(false, true) && this.partitionAwarenessEnabled) {
                    this.channelsInit();
                }
            });
        }
    }

    public void addChannelFailListener(Runnable chFailLsnr) {
        this.chFailLsnrs.add(chFailLsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void initChannelHolders() {
        List<ClientChannelHolder> holders = this.channels;
        this.startChannelsReInit = System.currentTimeMillis();
        this.scheduledChannelsReinit.set(false);
        Collection<List<InetSocketAddress>> newAddrs = this.discoveryCtx.getEndpoints();
        if (newAddrs == null) {
            this.finishChannelsReInit = System.currentTimeMillis();
            return;
        }
        if (holders != null && this.clientCfg.getAddressesFinder() == null) {
            newAddrs = new ArrayList<List<InetSocketAddress>>(newAddrs);
            for (ClientChannelHolder h : holders) {
                ClientChannel ch = h.ch;
                if (ch == null || ch.closed()) continue;
                newAddrs.add(h.getAddresses());
            }
        }
        HashMap<InetSocketAddress, ClientChannelHolder> curAddrs = new HashMap<InetSocketAddress, ClientChannelHolder>();
        Set newAddrsSet = newAddrs.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (holders != null) {
            for (ClientChannelHolder h : holders) {
                boolean found = false;
                for (InetSocketAddress inetSocketAddress : h.getAddresses()) {
                    ClientChannelHolder oldHld;
                    if (!newAddrsSet.contains(inetSocketAddress) || (oldHld = curAddrs.putIfAbsent(inetSocketAddress, h)) != null && oldHld != h) continue;
                    found = true;
                }
                if (found) continue;
                h.close();
            }
        }
        ArrayList<ClientChannelHolder> reinitHolders = new ArrayList<ClientChannelHolder>();
        int dfltChannelIdx = -1;
        ClientChannelHolder currDfltHolder = null;
        int idx = this.curChIdx;
        if (idx != -1) {
            currDfltHolder = holders.get(idx);
        }
        for (List<InetSocketAddress> addrs : newAddrs) {
            ClientChannelHolder hld = null;
            for (InetSocketAddress addr : addrs) {
                hld = (ClientChannelHolder)curAddrs.get(addr);
                if (hld == null) continue;
                if (hld.getAddresses().equals(addrs)) break;
                hld.setConfiguration(new ClientChannelConfiguration(this.clientCfg, addrs));
                break;
            }
            if (hld == null) {
                hld = new ClientChannelHolder(new ClientChannelConfiguration(this.clientCfg, addrs));
                for (InetSocketAddress addr : addrs) {
                    curAddrs.putIfAbsent(addr, hld);
                }
            }
            reinitHolders.add(hld);
            if (hld != currDfltHolder) continue;
            dfltChannelIdx = reinitHolders.size() - 1;
        }
        if (dfltChannelIdx == -1) {
            if (reinitHolders.isEmpty()) {
                throw new ClientException("No nodes available for connection");
            }
            dfltChannelIdx = 0;
            int n = ThreadLocalRandom.current().nextInt(reinitHolders.size());
            Collections.rotate(reinitHolders, -n);
        }
        this.curChannelsGuard.writeLock().lock();
        try {
            this.channels = reinitHolders;
            this.attemptsLimit = this.getRetryLimit();
            this.curChIdx = dfltChannelIdx;
        }
        finally {
            this.curChannelsGuard.writeLock().unlock();
        }
        this.finishChannelsReInit = System.currentTimeMillis();
    }

    void channelsInit() {
        this.channelsInit(null);
    }

    void channelsInit(@Nullable List<ClientConnectionException> failures) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Init channel holders");
        }
        this.initChannelHolders();
        if (failures == null || failures.size() < this.attemptsLimit) {
            this.applyOnDefaultChannel(channel -> null, null, failures);
            if (this.channelsCnt.get() == 0) {
                boolean discoveryUpdated = this.applyOnDefaultChannel(this.discoveryCtx::refresh, null, failures);
                if (discoveryUpdated) {
                    this.initChannelHolders();
                }
            }
        }
        if (this.partitionAwarenessEnabled) {
            this.initAllChannelsAsync();
        }
    }

    private <T> T applyOnNodeChannel(UUID nodeId, Function<ClientChannel, T> function, @Nullable List<ClientConnectionException> failures) {
        ClientChannelHolder hld = null;
        ClientChannel channel = null;
        try {
            hld = this.nodeChannels.get(nodeId);
            ClientChannel clientChannel = channel = hld != null ? hld.getOrCreateChannel() : null;
            if (channel != null) {
                return function.apply(channel);
            }
        }
        catch (ClientConnectionException e) {
            if (failures == null) {
                failures = new ArrayList<ClientConnectionException>();
            }
            failures.add(e);
            this.onChannelFailure(hld, channel, e, failures);
        }
        return null;
    }

    <T> T applyOnDefaultChannel(Function<ClientChannel, T> function, ClientOperation op) {
        return this.applyOnDefaultChannel(function, op, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T applyOnDefaultChannel(Function<ClientChannel, T> function, ClientOperation op, @Nullable List<ClientConnectionException> failures) {
        while (this.attemptsLimit > (failures == null ? 0 : failures.size())) {
            ClientChannelHolder hld = null;
            ClientChannel c = null;
            try {
                if (this.closed) {
                    throw new ClientException("Channel is closed");
                }
                this.curChannelsGuard.readLock().lock();
                try {
                    if (!this.partitionAwarenessEnabled || this.channelsCnt.get() <= 1 || F.size(failures, new IgnitePredicate[0]) > 0) {
                        hld = this.channels.get(this.curChIdx);
                    } else {
                        int idx;
                        int idx0 = idx = ThreadLocalRandom.current().nextInt(this.channels.size());
                        do {
                            hld = this.channels.get(idx);
                            if (++idx != this.channels.size()) continue;
                            idx = 0;
                        } while (hld.ch == null && idx != idx0);
                    }
                }
                finally {
                    this.curChannelsGuard.readLock().unlock();
                }
                ClientChannel c0 = hld.ch;
                c = hld.getOrCreateChannel();
                try {
                    return function.apply(c);
                }
                catch (ClientConnectionException e) {
                    if (c0 == c && this.partitionAwarenessEnabled) {
                        this.onChannelFailure(hld, c, e, failures);
                        c = hld.getOrCreateChannel();
                        return function.apply(c);
                    }
                    throw e;
                }
            }
            catch (ClientConnectionException e) {
                if (failures == null) {
                    failures = new ArrayList<ClientConnectionException>();
                }
                failures.add(e);
                this.onChannelFailure(hld, c, e, failures);
                if (op == null || this.shouldRetry(op, failures.size() - 1, e)) continue;
                break;
            }
        }
        throw this.composeException(failures);
    }

    private ClientConnectionException composeException(List<ClientConnectionException> failures) {
        if (F.isEmpty(failures)) {
            return null;
        }
        ClientConnectionException failure = failures.get(0);
        failures.subList(1, failures.size()).forEach(failure::addSuppressed);
        return failure;
    }

    private <T> T applyOnNodeChannelWithFallback(UUID tryNodeId, Function<ClientChannel, T> function, ClientOperation op) {
        ArrayList<ClientConnectionException> failures;
        block3: {
            ClientChannelHolder hld = this.nodeChannels.get(tryNodeId);
            failures = null;
            if (hld != null) {
                ClientChannel channel = null;
                try {
                    channel = hld.getOrCreateChannel();
                    return function.apply(channel);
                }
                catch (ClientConnectionException e) {
                    failures = new ArrayList<ClientConnectionException>();
                    failures.add(e);
                    this.onChannelFailure(hld, channel, e, failures);
                    if (this.attemptsLimit != 1 && this.shouldRetry(op, 0, e)) break block3;
                    throw e;
                }
            }
        }
        return this.applyOnDefaultChannel(function, op, failures);
    }

    private int getRetryLimit() {
        List<ClientChannelHolder> holders = this.channels;
        if (holders == null) {
            throw new ClientException("Connections to nodes aren't initialized.");
        }
        int size = holders.size();
        return this.clientCfg.getRetryLimit() > 0 ? Math.min(this.clientCfg.getRetryLimit(), size) : size;
    }

    private boolean shouldRetry(ClientOperation op, int iteration, ClientConnectionException exception) {
        ClientOperationType opType = op.toPublicOperationType();
        if (opType == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrying system operation [op=" + (Object)((Object)op) + ", iteration=" + iteration + ']');
            }
            return true;
        }
        ClientRetryPolicy plc = this.clientCfg.getRetryPolicy();
        if (plc == null) {
            return false;
        }
        ClientRetryPolicyContextImpl ctx = new ClientRetryPolicyContextImpl(this.clientCfg, opType, iteration, exception);
        try {
            boolean res = plc.shouldRetry(ctx);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retry policy returned " + res + " [op=" + (Object)((Object)op) + ", iteration=" + iteration + ']');
            }
            return res;
        }
        catch (Throwable t) {
            exception.addSuppressed(t);
            return false;
        }
    }

    ClientCacheAffinityContext affinityContext() {
        return this.affinityCtx;
    }

    List<ClientChannelHolder> getChannelHolders() {
        return this.channels;
    }

    Map<UUID, ClientChannelHolder> getNodeChannels() {
        return this.nodeChannels;
    }

    int getCurrentChannelIndex() {
        return this.curChIdx;
    }

    AtomicBoolean getScheduledChannelsReinit() {
        return this.scheduledChannelsReinit;
    }

    private /* synthetic */ Object lambda$affinityServiceAsync$5(CompletableFuture fut, ClientOperation op, Consumer payloadWriter, Function payloadReader, List failures, ClientChannel channel) {
        return this.applyOnClientChannelAsync(fut, channel, op, payloadWriter, payloadReader, failures);
    }

    class ClientChannelHolder {
        private volatile ClientChannelConfiguration chCfg;
        private volatile ClientChannel ch;
        private volatile UUID serverNodeId;
        private volatile boolean close;
        private final long[] reconnectRetries;

        private ClientChannelHolder(ClientChannelConfiguration chCfg) {
            this.chCfg = chCfg;
            this.reconnectRetries = chCfg.getReconnectThrottlingRetries() > 0 && chCfg.getReconnectThrottlingPeriod() > 0L ? new long[chCfg.getReconnectThrottlingRetries()] : null;
        }

        private boolean applyReconnectionThrottling() {
            if (this.reconnectRetries == null) {
                return false;
            }
            long ts = System.currentTimeMillis();
            for (int i = 0; i < this.reconnectRetries.length; ++i) {
                if (ts - this.reconnectRetries[i] < this.chCfg.getReconnectThrottlingPeriod()) continue;
                this.reconnectRetries[i] = ts;
                return false;
            }
            return true;
        }

        private ClientChannel getOrCreateChannel() throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
            return this.getOrCreateChannel(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientChannel getOrCreateChannel(boolean ignoreThrottling) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
            if (this.close) {
                throw new ClientConnectionException("Channel is closed");
            }
            if (this.ch == null) {
                ClientChannelHolder clientChannelHolder = this;
                synchronized (clientChannelHolder) {
                    if (this.close) {
                        throw new ClientConnectionException("Channel is closed");
                    }
                    if (this.ch != null) {
                        return this.ch;
                    }
                    if (!ignoreThrottling && this.applyReconnectionThrottling()) {
                        throw new ClientConnectionException("Reconnect is not allowed due to applied throttling");
                    }
                    ClientChannel channel = (ClientChannel)ReliableChannel.this.chFactory.apply(this.chCfg, ReliableChannel.this.connMgr);
                    if (channel.serverNodeId() != null) {
                        channel.addTopologyChangeListener(x$0 -> ReliableChannel.this.onTopologyChanged(x$0));
                        UUID prevId = this.serverNodeId;
                        if (prevId != null && !prevId.equals(channel.serverNodeId())) {
                            ReliableChannel.this.nodeChannels.remove(prevId, this);
                        }
                        if (!channel.serverNodeId().equals(prevId)) {
                            this.serverNodeId = channel.serverNodeId();
                            ReliableChannel.this.nodeChannels.putIfAbsent(channel.serverNodeId(), this);
                        }
                    }
                    this.ch = channel;
                    ReliableChannel.this.channelsCnt.incrementAndGet();
                }
            }
            return this.ch;
        }

        private synchronized void closeChannel() {
            if (this.ch != null) {
                U.closeQuiet(this.ch);
                this.ch = null;
                ReliableChannel.this.channelsCnt.decrementAndGet();
            }
        }

        void close() {
            this.close = true;
            if (this.serverNodeId != null) {
                ReliableChannel.this.nodeChannels.remove(this.serverNodeId, this);
            }
            this.closeChannel();
        }

        boolean isClosed() {
            return this.close;
        }

        List<InetSocketAddress> getAddresses() {
            return this.chCfg.getAddresses();
        }

        void setConfiguration(ClientChannelConfiguration chCfg) {
            this.chCfg = chCfg;
        }
    }
}

