/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.security.MessageDigest;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.internal.io.DecryptionReadableChannel;
import org.gridgain.grid.internal.io.GridReadableByteChannel;
import org.gridgain.grid.internal.io.GridReadableDigestByteChannel;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.snapshot.file.DigestSnapshotInputStream;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotInputStream;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotDigestRegistryCache;
import org.jetbrains.annotations.Nullable;

public class SnapshotInputStreamFactory {
    public static final String MISSING_PART_HASH_ERROR = "Data/Index partition hash not found in snapshot digest registry.";
    private final IgniteLogger log;
    private final long id;
    private final FileStore fileStore;
    private final MessageDigestFactory msgDigestFactory;
    private final SnapshotSecurityLevel securityLevel;
    private final SnapshotDigestRegistryCache registryCache;
    private final RecordSerializerFactory recordSerializerFactory;
    private final SnapshotEncryptionOptions encryptionOptions;
    private final EncryptionSpi encryptionSpi;

    public SnapshotInputStreamFactory(IgniteConfiguration igCfg, long id, SnapshotPath snapshotDir, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer transformer, SnapshotSecurityLevel securityLevel, @Nullable RecordSerializerFactory recordSerializerFactory, @Nullable SnapshotEncryptionOptions encryptionOptions, EncryptionSpi encryptionSpi) {
        this.log = igCfg.getGridLogger().getLogger(this.getClass());
        this.id = id;
        this.msgDigestFactory = msgDigestFactory;
        this.securityLevel = securityLevel;
        this.recordSerializerFactory = recordSerializerFactory;
        this.encryptionOptions = encryptionOptions;
        this.encryptionSpi = encryptionSpi;
        SnapshotDigestRegistryCache snapshotDigestRegistryCache = this.registryCache = this.securityLevel.compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0 ? null : new SnapshotDigestRegistryCache(igCfg, id, snapshotDir, msgDigestFactory, transformer, securityLevel);
        if (snapshotDir instanceof FsSnapshotPath) {
            FileStore store = null;
            try {
                store = Files.getFileStore(((FsSnapshotPath)snapshotDir).getFile().toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileStore = store;
        } else {
            this.fileStore = null;
        }
    }

    public SnapshotDigestRegistryCache getRegistryCache() {
        return this.registryCache;
    }

    public SnapshotInputStream makeInputStream(SnapshotPath file, int cacheGrpId, int partId, int pageSize, String constId, boolean initWALFileInput) {
        GroupKey encryptionKey = this.encryptionOptions != null ? this.encryptionOptions.getGroupKey(Integer.valueOf(cacheGrpId)) : null;
        boolean optimizedCompressedEncryption = encryptionKey != null && this.encryptionOptions.optimizedCompressedEncryption();
        SnapshotUtils.CompressedChannelInfo channelPair = SnapshotUtils.channel(file, this.fileStore, optimizedCompressedEncryption);
        SnapshotReadableByteChannel channel = channelPair.channel;
        if (channel == null) {
            return null;
        }
        SnapshotDigestRegistry registry = null;
        MessageDigest msgDigest = null;
        byte[] expHash = null;
        try {
            if (this.securityLevel != SnapshotSecurityLevel.DISABLED && this.securityLevel != SnapshotSecurityLevel.IGNORE_EXISTING) {
                registry = this.registryCache.cachedRegistry(constId);
                if (registry != null) {
                    expHash = registry.partitionDataDigest(new GroupPartitionId(cacheGrpId, partId));
                    if (expHash == null) {
                        throw new SnapshotDigestException("Data/Index partition hash not found in snapshot digest registry. [consistentId='" + constId + "', cacheGrpId=" + cacheGrpId + ", partId=" + partId + "]");
                    }
                    msgDigest = SnapshotUtils.createMessageDigest(this.msgDigestFactory, this.id);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Expected hash : [snapshotId=" + this.id + ", cacheGrpPrt=" + cacheGrpId + ":" + partId + ", consistentId=" + constId + ", hash=" + U.byteArray2HexString((byte[])expHash) + ", file=" + file + "]");
                    }
                    channel = new GridReadableDigestByteChannel(channel, msgDigest);
                } else if (this.securityLevel != SnapshotSecurityLevel.IGNORE_MISSING) {
                    throw new SnapshotDigestException("Snapshot digest registry is missing. [consistentId='" + constId + "']");
                }
            }
            if (optimizedCompressedEncryption) {
                channel = new DecryptionReadableChannel(channel, encryptionKey, this.encryptionSpi, pageSize, false);
                SnapshotPath canonicalFile = SnapshotUtils.resolveCanonicalFile(file);
                InputStream stream = SnapshotUtils.decompressingInputStream(channelPair.compressionOption, channel.asInputStream(), canonicalFile);
                channel = new GridReadableByteChannel(stream);
            } else if (encryptionKey != null) {
                channel = new DecryptionReadableChannel(channel, encryptionKey, this.encryptionSpi, pageSize, true);
            }
            if (msgDigest == null) {
                return new FileSnapshotInputStream(channel, partId, pageSize, constId, initWALFileInput, this.recordSerializerFactory);
            }
            return new DigestSnapshotInputStream(this.log, channel, cacheGrpId, partId, pageSize, constId, initWALFileInput, this.recordSerializerFactory, msgDigest, expHash);
        }
        catch (Throwable t) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }
}

