/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotInputStream;
import org.jetbrains.annotations.Nullable;

public class DigestSnapshotInputStream
extends FileSnapshotInputStream {
    public static final String CORRUPTED_PART_HASH_ERROR = "Data/Index partition hash verification failure.";
    private final IgniteLogger log;
    private final MessageDigest msgDigest;
    private final byte[] expHash;
    private final int cacheGrpId;
    private boolean isValidated;

    DigestSnapshotInputStream(IgniteLogger log, SnapshotReadableByteChannel channel, int cacheGrpId, int partId, int pageSize, String consistentId, boolean initWALFileInput, @Nullable RecordSerializerFactory recordSerializerFactory, MessageDigest msgDigest, byte[] expHash) {
        super(channel, partId, pageSize, consistentId, initWALFileInput, recordSerializerFactory);
        this.log = log;
        this.msgDigest = msgDigest;
        this.expHash = expHash;
        this.cacheGrpId = cacheGrpId;
    }

    @Override
    public boolean readNextPage(ByteBuffer buf) throws IOException {
        boolean read = super.readNextPage(buf);
        if (read) {
            return true;
        }
        if (this.terminationPageReached()) {
            return false;
        }
        this.verifyDigest();
        return false;
    }

    @Override
    public WALRecord readNextRecord() {
        WALRecord rec = super.readNextRecord();
        if (rec == null && this.terminationPageReached()) {
            this.verifyDigest();
        }
        return rec;
    }

    private void verifyDigest() {
        if (this.isValidated) {
            return;
        }
        this.isValidated = true;
        byte[] actual = this.msgDigest.digest();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Data/Index partition hash comparison. [cacheGrpId=" + this.cacheGrpId + ", partId=" + this.partId() + ", expected='" + U.byteArray2HexString((byte[])this.expHash) + "', actual='" + U.byteArray2HexString((byte[])actual) + "']");
        }
        if (!Arrays.equals(this.expHash, actual)) {
            throw new SnapshotDigestException("Data/Index partition hash verification failure. [cacheGrpId=" + this.cacheGrpId + ", partId=" + this.partId() + ", expected='" + U.byteArray2HexString((byte[])this.expHash) + "', actual='" + U.byteArray2HexString((byte[])actual) + "']");
        }
    }

    @Override
    public void close() throws IgniteCheckedException {
        try {
            if (!this.isValidated && this.terminationPageReached()) {
                while (this.readNextRecord() != null) {
                }
            }
        }
        finally {
            super.close();
        }
    }
}

