/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.ignite.IgniteCheckedException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStreamListener;
import org.gridgain.grid.internal.util.GridUtils;

public class ByteChannelSnapshotOutputStream
implements SnapshotOutputStream {
    private final WritableByteChannel channel;
    private final SnapshotOutputStreamListener listener;
    private volatile long pos;

    ByteChannelSnapshotOutputStream(OutputStream outputStream, SnapshotOutputStreamListener listener) {
        this.channel = Channels.newChannel(outputStream);
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plainWrite(ByteBuffer data) throws IgniteCheckedException {
        try {
            WritableByteChannel writableByteChannel = this.channel;
            synchronized (writableByteChannel) {
                this.pos += (long)data.remaining();
                while (data.hasRemaining()) {
                    this.channel.write(data);
                }
            }
        }
        catch (IOException e) {
            if (GridUtils.isDiskFullException((IOException)e)) {
                throw new IgniteCheckedException("Storage device is full, error writing snapshot file", (Throwable)e);
            }
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IgniteCheckedException {
        WritableByteChannel writableByteChannel = this.channel;
        synchronized (writableByteChannel) {
            boolean isOpen = false;
            try {
                isOpen = this.channel.isOpen();
                this.channel.close();
            }
            catch (IOException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
            finally {
                if (isOpen) {
                    this.listener.onClose();
                }
            }
        }
    }

    public long position() {
        return this.pos;
    }
}

